/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.HttpDigestUserDetailsServiceWrapper;
import org.geoserver.security.config.DigestAuthenticationFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.AuthenticationCachingFilter;
import org.geoserver.security.filter.GeoServerAuthenticationFilter;
import org.geoserver.security.filter.GeoServerCompositeFilter;
import org.geoserver.security.impl.DigestAuthUtils;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.DigestAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.DigestAuthenticationFilter;
import org.springframework.util.StringUtils;

public class GeoServerDigestAuthenticationFilter
extends GeoServerCompositeFilter
implements AuthenticationCachingFilter,
GeoServerAuthenticationFilter {
    private DigestAuthenticationEntryPoint aep;

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        DigestAuthenticationFilterConfig authConfig = (DigestAuthenticationFilterConfig)config;
        this.aep = new DigestAuthenticationEntryPoint();
        this.aep.setKey(config.getName());
        this.aep.setNonceValiditySeconds(authConfig.getNonceValiditySeconds() <= 0 ? 300 : authConfig.getNonceValiditySeconds());
        this.aep.setRealmName("GeoServer Realm");
        try {
            this.aep.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        DigestAuthenticationFilter filter = new DigestAuthenticationFilter();
        filter.setCreateAuthenticatedToken(true);
        filter.setPasswordAlreadyEncoded(true);
        filter.setAuthenticationEntryPoint(this.aep);
        HttpDigestUserDetailsServiceWrapper wrapper = new HttpDigestUserDetailsServiceWrapper(this.getSecurityManager().loadUserGroupService(authConfig.getUserGroupServiceName()), Charset.defaultCharset());
        filter.setUserDetailsService((UserDetailsService)wrapper);
        filter.afterPropertiesSet();
        this.getNestedFilters().add((Filter)filter);
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        req.setAttribute("_AUTHENTICATION_ENTRY_POINT_HEADER", (Object)this.aep);
        Integer validity = this.aep.getNonceValiditySeconds();
        req.setAttribute("_geoserver_security_cache_key_idle_secs", (Object)validity);
        req.setAttribute("_geoserver_security_cache_key_live_secs", (Object)validity);
        super.doFilter(req, res, chain);
    }

    @Override
    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.aep;
    }

    @Override
    public String getCacheKey(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Digest ")) {
            String section212response = header.substring(7);
            String[] headerEntries = DigestAuthUtils.splitIgnoringQuotes(section212response, ',');
            Map<String, String> headerMap = DigestAuthUtils.splitEachArrayElementAndCreateMap(headerEntries, "=", "\"");
            String username = headerMap.get("username");
            String realm = headerMap.get("realm");
            String nonce = headerMap.get("nonce");
            String responseDigest = headerMap.get("response");
            if (!(StringUtils.hasLength((String)username) && StringUtils.hasLength((String)realm) && StringUtils.hasLength((String)nonce) && StringUtils.hasLength((String)responseDigest))) {
                return null;
            }
            if ("root".equals(username)) {
                return null;
            }
            StringBuffer buff = new StringBuffer();
            buff.append(username).append(":");
            buff.append(realm).append(":");
            buff.append(nonce).append(":");
            buff.append(responseDigest);
            return buff.toString();
        }
        return null;
    }
}

