/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.file;

import java.io.IOException;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.event.RoleLoadedEvent;
import org.geoserver.security.event.RoleLoadedListener;
import org.geoserver.security.file.FileWatcher;

public class RoleFileWatcher
extends FileWatcher
implements RoleLoadedListener {
    protected GeoServerRoleService service;

    public RoleFileWatcher(String fileName, GeoServerRoleService service) {
        super(fileName);
        this.service = service;
        this.checkAndConfigure();
    }

    public RoleFileWatcher(String fileName, GeoServerRoleService service, long lastModified) {
        super(fileName);
        this.service = service;
        this.lastModified = lastModified;
        this.checkAndConfigure();
    }

    public synchronized GeoServerRoleService getService() {
        return this.service;
    }

    public synchronized void setService(GeoServerRoleService service) {
        this.service = service;
    }

    @Override
    protected void doOnChange() {
        GeoServerRoleService theService = this.getService();
        try {
            if (theService != null) {
                theService.load();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        String serviceName = this.service == null ? "UNKNOWN" : this.service.getName();
        buff.append("FileWatcher for ").append(serviceName);
        buff.append(", ").append(this.getFileInfo());
        return buff.toString();
    }

    @Override
    public void rolesChanged(RoleLoadedEvent event) {
        this.setLastModified(this.file.lastModified());
        LOGGER.info("Adjusted last modified for file: " + this.filename);
    }
}

