/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.file;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

public abstract class FileWatcher
extends Thread {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    public static final long DEFAULT_DELAY = 10000L;
    protected String filename;
    protected long delay = 10000L;
    File file;
    long lastModified = 0L;
    boolean warnedAlready = false;
    boolean terminate = false;
    Object terminateLock = new Object();
    Object lastModifiedLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.terminateLock;
        synchronized (object) {
            return this.terminate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerminate(boolean terminated) {
        Object object = this.terminateLock;
        synchronized (object) {
            this.terminate = terminated;
        }
    }

    protected FileWatcher(String filename) {
        this.filename = filename;
        this.file = new File(filename);
        this.setDaemon(true);
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    protected abstract void doOnChange();

    protected void checkAndConfigure() {
        boolean fileExists;
        try {
            fileExists = this.file.exists();
        }
        catch (SecurityException e) {
            LOGGER.warning("Was not allowed to read check file existance, file:[" + this.filename + "].");
            this.setTerminate(true);
            return;
        }
        if (fileExists) {
            long l = this.file.lastModified();
            if (this.testAndSetLastModified(l)) {
                this.doOnChange();
                this.warnedAlready = false;
            }
        } else if (!this.warnedAlready) {
            LOGGER.warning("[" + this.filename + "] does not exist.");
            this.warnedAlready = true;
        }
    }

    @Override
    public void run() {
        while (!this.isTerminated()) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkAndConfigure();
        }
    }

    public String getFileInfo() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        StringBuffer buff = new StringBuffer(this.file.getPath());
        buff.append(" last modified: ");
        buff.append(sdf.format(this.file.lastModified()));
        return buff.toString();
    }

    @Override
    public String toString() {
        return "FileWatcher: " + this.getFileInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testAndSetLastModified(long l) {
        Object object = this.lastModifiedLock;
        synchronized (object) {
            if (l > this.lastModified) {
                this.lastModified = l;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastModified(long lastModified) {
        Object object = this.lastModifiedLock;
        synchronized (object) {
            this.lastModified = lastModified;
        }
    }
}

