/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingLayerInfo;
import org.geoserver.security.decorators.SecuredCoverageInfo;
import org.geoserver.security.decorators.SecuredFeatureTypeInfo;
import org.geoserver.security.decorators.SecuredWMSLayerInfo;

public class SecuredLayerInfo
extends DecoratingLayerInfo {
    WrapperPolicy policy;

    public SecuredLayerInfo(LayerInfo delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    @Override
    public ResourceInfo getResource() {
        ResourceInfo r = super.getResource();
        if (r == null) {
            return null;
        }
        if (r instanceof FeatureTypeInfo) {
            return new SecuredFeatureTypeInfo((FeatureTypeInfo)r, this.policy);
        }
        if (r instanceof CoverageInfo) {
            return new SecuredCoverageInfo((CoverageInfo)r, this.policy);
        }
        if (r instanceof WMSLayerInfo) {
            return new SecuredWMSLayerInfo((WMSLayerInfo)r, this.policy);
        }
        throw new RuntimeException("Don't know how to make resource of type " + r.getClass());
    }

    @Override
    public void setResource(ResourceInfo resource) {
        if (resource instanceof SecuredFeatureTypeInfo || resource instanceof SecuredCoverageInfo) {
            resource = (ResourceInfo)SecureCatalogImpl.unwrap((Object)resource);
        }
        ((LayerInfo)this.delegate).setResource(resource);
    }
}

