/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingGridCoverage2DReader;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.Crop;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.coverage.grid.Format;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public class SecuredGridCoverage2DReader
extends DecoratingGridCoverage2DReader {
    private static final ParameterValueGroup cropParams;
    private static final Crop coverageCropFactory;
    WrapperPolicy policy;

    public SecuredGridCoverage2DReader(AbstractGridCoverage2DReader delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    @Override
    public Format getFormat() {
        Format format = this.delegate.getFormat();
        if (format == null) {
            return null;
        }
        return (Format)SecuredObjects.secure(format, this.policy);
    }

    @Override
    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        MultiPolygon rasterFilter = null;
        if (this.policy.getLimits() instanceof CoverageAccessLimits) {
            CoverageAccessLimits limits = (CoverageAccessLimits)this.policy.getLimits();
            rasterFilter = limits.getRasterFilter();
            Filter readFilter = limits.getReadFilter();
            GeneralParameterValue[] limitParams = limits.getParams();
            if (parameters == null) {
                parameters = limitParams;
            } else if (limitParams != null) {
                ArrayList<GeneralParameterValue> params = new ArrayList<GeneralParameterValue>(Arrays.asList(parameters));
                for (GeneralParameterValue lparam : limitParams) {
                    GeneralParameterDescriptor ldescriptor = lparam.getDescriptor();
                    Iterator it = params.iterator();
                    while (it.hasNext()) {
                        GeneralParameterValue param = (GeneralParameterValue)it.next();
                        if (!param.getDescriptor().equals(lparam.getDescriptor())) continue;
                        it.remove();
                        break;
                    }
                    params.add(lparam);
                }
                parameters = params.toArray(new GeneralParameterValue[params.size()]);
            }
            if (readFilter != null && !Filter.INCLUDE.equals(readFilter)) {
                ParameterValueGroup readParameters = this.delegate.getFormat().getReadParameters();
                List descriptors = readParameters.getDescriptor().descriptors();
                parameters = CoverageUtils.mergeParameter(descriptors, parameters, readFilter, "FILTER", "Filter");
            }
        }
        GridCoverage2D grid = this.delegate.read(parameters);
        if (rasterFilter != null) {
            Polygon coverageBounds = JTS.toGeometry((Envelope)new ReferencedEnvelope((BoundingBox)grid.getEnvelope2D()));
            if (coverageBounds.intersects((Geometry)rasterFilter)) {
                ParameterValueGroup param = cropParams.clone();
                param.parameter("source").setValue((Object)grid);
                param.parameter("ROI").setValue((Object)rasterFilter);
                grid = (GridCoverage2D)coverageCropFactory.doOperation(param, this.hints);
            } else {
                return null;
            }
        }
        return grid;
    }

    static {
        coverageCropFactory = new Crop();
        CoverageProcessor processor = new CoverageProcessor((RenderingHints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        cropParams = processor.getOperation("CoverageCrop").getParameters();
    }
}

