/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredCoverageInfo;
import org.geoserver.security.decorators.SecuredCoverageStoreInfo;
import org.geoserver.security.decorators.SecuredDataStoreInfo;
import org.geoserver.security.decorators.SecuredFeatureTypeInfo;
import org.geoserver.security.decorators.SecuredLayerInfo;
import org.geoserver.security.decorators.SecuredObjectFactory;

public class DefaultSecureCatalogFactory
implements SecuredObjectFactory {
    @Override
    public boolean canSecure(Class clazz) {
        return CoverageInfo.class.isAssignableFrom(clazz) || CoverageStoreInfo.class.isAssignableFrom(clazz) || DataStoreInfo.class.isAssignableFrom(clazz) || FeatureTypeInfo.class.isAssignableFrom(clazz) || LayerInfo.class.isAssignableFrom(clazz);
    }

    @Override
    public Object secure(Object object, WrapperPolicy policy) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (CoverageInfo.class.isAssignableFrom(clazz)) {
            return new SecuredCoverageInfo((CoverageInfo)object, policy);
        }
        if (CoverageStoreInfo.class.isAssignableFrom(clazz)) {
            return new SecuredCoverageStoreInfo((CoverageStoreInfo)object, policy);
        }
        if (DataStoreInfo.class.isAssignableFrom(clazz)) {
            return new SecuredDataStoreInfo((DataStoreInfo)object, policy);
        }
        if (FeatureTypeInfo.class.isAssignableFrom(clazz)) {
            return new SecuredFeatureTypeInfo((FeatureTypeInfo)object, policy);
        }
        if (LayerInfo.class.isAssignableFrom(clazz)) {
            return new SecuredLayerInfo((LayerInfo)object, policy);
        }
        throw new IllegalArgumentException("Don't know how to wrap");
    }

    public int getPriority() {
        return 100;
    }
}

