/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geoserver.security.Response;
import org.geoserver.security.SecureCatalogImpl;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FeatureIteratorIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

class CheckAttributesFeatureCollection
extends DecoratingSimpleFeatureCollection {
    Set<String> writableAttributes;
    Response response;

    protected CheckAttributesFeatureCollection(SimpleFeatureCollection delegate, Collection<String> writableAttributes, Response response) {
        super(delegate);
        this.writableAttributes = new HashSet<String>(writableAttributes);
        this.response = response;
    }

    public SimpleFeatureIterator features() {
        return new CheckAttributesFeatureIterator(this.delegate.features(), this.writableAttributes);
    }

    public Iterator iterator() {
        return new FeatureIteratorIterator((FeatureIterator)this.features());
    }

    public class CheckAttributesFeatureIterator
    implements SimpleFeatureIterator {
        SimpleFeatureIterator delegate;

        public CheckAttributesFeatureIterator(SimpleFeatureIterator delegate, Set<String> writableAttributes) {
            this.delegate = delegate;
        }

        public void close() {
            this.delegate.close();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() throws NoSuchElementException {
            SimpleFeature next = (SimpleFeature)this.delegate.next();
            SimpleFeatureType featureType = next.getFeatureType();
            for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                Object value;
                String name = att.getLocalName();
                if (CheckAttributesFeatureCollection.this.writableAttributes.contains(name) || (value = next.getAttribute(name)) == null) continue;
                String typeName = CheckAttributesFeatureCollection.this.getSchema().getName().getLocalPart();
                if (CheckAttributesFeatureCollection.this.response == Response.CHALLENGE) {
                    throw SecureCatalogImpl.unauthorizedAccess(typeName);
                }
                throw new UnsupportedOperationException("Trying to write on the write protected attribute " + name);
            }
            return next;
        }
    }
}

