/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.concurrent;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.concurrent.AbstractLockingService;
import org.geoserver.security.concurrent.LockingRoleStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.RoleLoadedEvent;
import org.geoserver.security.event.RoleLoadedListener;
import org.geoserver.security.impl.GeoServerRole;

public class LockingRoleService
extends AbstractLockingService
implements GeoServerRoleService,
RoleLoadedListener {
    protected Set<RoleLoadedListener> listeners = Collections.synchronizedSet(new HashSet());

    public LockingRoleService(GeoServerRoleService service) {
        super(service);
        service.registerRoleLoadedListener(this);
    }

    @Override
    public GeoServerRoleService getService() {
        return (GeoServerRoleService)super.getService();
    }

    @Override
    public GeoServerRoleStore createStore() throws IOException {
        GeoServerRoleStore store = this.getService().createStore();
        return store != null ? new LockingRoleStore(store) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException {
        this.writeLock();
        try {
            this.getService().load();
        }
        finally {
            this.writeUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<GeoServerRole> getRolesForUser(String username) throws IOException {
        this.readLock();
        try {
            SortedSet<GeoServerRole> sortedSet = this.getService().getRolesForUser(username);
            return sortedSet;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<GeoServerRole> getRolesForGroup(String groupname) throws IOException {
        this.readLock();
        try {
            SortedSet<GeoServerRole> sortedSet = this.getService().getRolesForGroup(groupname);
            return sortedSet;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<GeoServerRole> getRoles() throws IOException {
        this.readLock();
        try {
            SortedSet<GeoServerRole> sortedSet = this.getService().getRoles();
            return sortedSet;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeoServerRole createRoleObject(String role) throws IOException {
        this.readLock();
        try {
            GeoServerRole geoServerRole = this.getService().createRoleObject(role);
            return geoServerRole;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeoServerRole getParentRole(GeoServerRole role) throws IOException {
        this.readLock();
        try {
            GeoServerRole geoServerRole = this.getService().getParentRole(role);
            return geoServerRole;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeoServerRole getRoleByName(String role) throws IOException {
        this.readLock();
        try {
            GeoServerRole geoServerRole = this.getService().getRoleByName(role);
            return geoServerRole;
        }
        finally {
            this.readUnLock();
        }
    }

    protected void fireRoleChangedEvent() {
        RoleLoadedEvent event = new RoleLoadedEvent(this);
        for (RoleLoadedListener listener : this.listeners) {
            listener.rolesChanged(event);
        }
    }

    @Override
    public void registerRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void rolesChanged(RoleLoadedEvent event) {
        this.fireRoleChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<String> getGroupNamesForRole(GeoServerRole role) throws IOException {
        this.readLock();
        try {
            SortedSet<String> sortedSet = this.getService().getGroupNamesForRole(role);
            return sortedSet;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<String> getUserNamesForRole(GeoServerRole role) throws IOException {
        this.readLock();
        try {
            SortedSet<String> sortedSet = this.getService().getUserNamesForRole(role);
            return sortedSet;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getParentMappings() throws IOException {
        this.readLock();
        try {
            Map<String, String> map = this.getService().getParentMappings();
            return map;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties personalizeRoleParams(String roleName, Properties roleParams, String userName, Properties userProps) throws IOException {
        this.readLock();
        try {
            Properties properties = this.getService().personalizeRoleParams(roleName, roleParams, userName, userProps);
            return properties;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        this.writeLock();
        try {
            this.getService().initializeFromConfig(config);
        }
        finally {
            this.writeUnLock();
        }
    }

    @Override
    public GeoServerRole getAdminRole() {
        return this.getService().getAdminRole();
    }

    @Override
    public GeoServerRole getGroupAdminRole() {
        return this.getService().getGroupAdminRole();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRoleCount() throws IOException {
        this.readLock();
        try {
            int n = this.getService().getRoleCount();
            return n;
        }
        finally {
            this.readUnLock();
        }
    }
}

