/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final int capacity;
    private long accessCount = 0L;
    private long hitCount = 0L;

    public LRUCache(int capacity) {
        super(capacity + 1, 1.1f, true);
        this.capacity = capacity;
    }

    @Override
    public V get(Object key) {
        ++this.accessCount;
        if (this.containsKey(key)) {
            ++this.hitCount;
        }
        return super.get(key);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.capacity;
    }

    public long getAccessCount() {
        return this.accessCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }
}

