/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.geoserver.security.auth.AuthenticationCache;
import org.geoserver.security.auth.AuthenticationCacheEntry;
import org.geoserver.security.auth.AuthenticationCacheKey;
import org.geoserver.security.auth.LRUCache;
import org.geotools.util.logging.Logging;
import org.springframework.security.core.Authentication;

public class LRUAuthenticationCacheImpl
implements AuthenticationCache {
    protected LRUCache<AuthenticationCacheKey, AuthenticationCacheEntry> cache;
    int timeToIdleSeconds;
    int timeToLiveSeconds;
    int maxEntries;
    protected final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();
    protected final Timer timer = new Timer(true);
    private static final int DEFAULT_MILLIS_BETWEEN_REMOVE_EXPIRED = 60000;
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    TimerTask removeExpiredTask = new TimerTask(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.fine("Start searching for expired authentication tokens");
            LRUAuthenticationCacheImpl.this.writeLock.lock();
            try {
                HashSet toBeRemoved = new HashSet();
                long currentTime = System.currentTimeMillis();
                for (Map.Entry e : LRUAuthenticationCacheImpl.this.cache.entrySet()) {
                    if (!((AuthenticationCacheEntry)e.getValue()).hasExpired(currentTime)) continue;
                    toBeRemoved.add(e.getKey());
                }
                LOGGER.fine("Number of expired authentication tokens found: " + toBeRemoved.size());
                for (AuthenticationCacheKey key : toBeRemoved) {
                    LRUAuthenticationCacheImpl.this.cache.remove(key);
                }
            }
            finally {
                LRUAuthenticationCacheImpl.this.writeLock.unlock();
            }
            LOGGER.fine("End searching for expired authentication tokens");
        }
    };

    public LRUAuthenticationCacheImpl(int maxEntries) {
        this(300, 600, maxEntries);
    }

    public LRUAuthenticationCacheImpl(int timeToIdleSeconds, int timeToLiveSeconds, int maxEntries) {
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.maxEntries = maxEntries;
        this.cache = new LRUCache(maxEntries);
        this.timer.schedule(this.removeExpiredTask, 60000L, 60000L);
    }

    public int getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        this.writeLock.lock();
        try {
            this.cache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(String filterName) {
        if (filterName == null) {
            return;
        }
        this.writeLock.lock();
        try {
            HashSet<AuthenticationCacheKey> toBeRemoved = new HashSet<AuthenticationCacheKey>();
            for (AuthenticationCacheKey key : this.cache.keySet()) {
                if (!filterName.equals(key.getFilterName())) continue;
                toBeRemoved.add(key);
            }
            for (AuthenticationCacheKey key : toBeRemoved) {
                this.cache.remove(key);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String filterName, String cacheKey) {
        this.writeLock.lock();
        try {
            this.cache.remove(new AuthenticationCacheKey(filterName, cacheKey));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Authentication get(String filterName, String cacheKey) {
        this.readLock.lock();
        boolean hasTobeRemoved = false;
        try {
            long currentTime = System.currentTimeMillis();
            AuthenticationCacheEntry entry = this.cache.get(new AuthenticationCacheKey(filterName, cacheKey));
            if (entry == null) {
                Authentication authentication = null;
                return authentication;
            }
            if (entry.hasExpired(currentTime)) {
                hasTobeRemoved = true;
                Authentication authentication = null;
                return authentication;
            }
            entry.setLastAccessed(currentTime);
            Authentication authentication = entry.getAuthentication();
            return authentication;
        }
        finally {
            this.readLock.unlock();
            if (hasTobeRemoved) {
                this.remove(filterName, cacheKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String filterName, String cacheKey, Authentication auth, Integer timeToIdleSeconds, Integer timeToLiveSeconds) {
        timeToIdleSeconds = timeToIdleSeconds != null ? timeToIdleSeconds : this.timeToIdleSeconds;
        timeToLiveSeconds = timeToLiveSeconds != null ? timeToLiveSeconds : this.timeToLiveSeconds;
        this.writeLock.lock();
        try {
            this.cache.put(new AuthenticationCacheKey(filterName, cacheKey), new AuthenticationCacheEntry(auth, timeToIdleSeconds, timeToLiveSeconds));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void put(String filterName, String cacheKey, Authentication auth) {
        this.put(filterName, cacheKey, auth, this.timeToIdleSeconds, this.timeToLiveSeconds);
    }

    public void runRemoveExpiredTaskSynchron() {
        this.removeExpiredTask.run();
    }
}

