/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RequestFilterChain
implements Serializable {
    String name;
    List<String> patterns;
    List<String> filterNames;
    boolean constant;

    public RequestFilterChain(String ... patterns) {
        this.patterns = new ArrayList<String>(Arrays.asList(patterns));
        this.filterNames = new ArrayList<String>();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public List<String> getFilterNames() {
        return this.filterNames;
    }

    public void setFilterNames(String ... filterNames) {
        this.setFilterNames(new ArrayList<String>(Arrays.asList(filterNames)));
    }

    public void setFilterNames(List<String> filterNames) {
        this.filterNames = filterNames;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public boolean updateAuthFilters(List<String> newFilterNames) {
        int i = this.filterNames.indexOf("contextAsc");
        i = i != -1 ? i : this.filterNames.indexOf("contextNoAsc");
        int j = this.filterNames.indexOf("exception");
        int n = j = j != -1 ? j : this.filterNames.indexOf("guiException");
        if (i == -1 || j == -1) {
            return false;
        }
        ArrayList<String> sub = new ArrayList<String>(this.filterNames.subList(i + 1, j));
        this.filterNames.removeAll(sub);
        this.filterNames.addAll(i + 1, newFilterNames);
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.patterns).append(":").append(this.filterNames);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constant ? 1231 : 1237);
        result = 31 * result + (this.filterNames == null ? 0 : ((Object)this.filterNames).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.patterns == null ? 0 : ((Object)this.patterns).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestFilterChain other = (RequestFilterChain)obj;
        if (this.constant != other.constant) {
            return false;
        }
        if (this.filterNames == null ? other.filterNames != null : !((Object)this.filterNames).equals(other.filterNames)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.patterns == null ? other.patterns != null : !((Object)this.patterns).equals(other.patterns));
    }
}

