/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class RESTfulPathBasedFilterInvocationDefinitionMap
implements FilterInvocationSecurityMetadataSource {
    private static Log log = LogFactory.getLog(RESTfulPathBasedFilterInvocationDefinitionMap.class);
    private Collection<EntryHolder> requestMap = new Vector<EntryHolder>();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private boolean convertUrlToLowercaseBeforeComparison = false;

    public boolean supports(Class clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public void addSecureUrl(String antPath, String[] httpMethods, Collection<ConfigAttribute> attrs) {
        this.requestMap.add(new EntryHolder(antPath, httpMethods, attrs));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added Ant path: " + antPath + "; attributes: " + attrs + ", httpMethods: " + httpMethods));
            if (httpMethods != null) {
                for (int ii = 0; ii < httpMethods.length; ++ii) {
                    log.debug((Object)("httpMethods[" + ii + "]: " + httpMethods[ii]));
                }
            }
        }
    }

    public void addSecureUrl(String antPath, Collection<ConfigAttribute> attrs) {
        throw new IllegalArgumentException("addSecureUrl(String, Collection<ConfigAttribute> ) is INVALID for RESTfulDefinitionSource");
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        HashSet<ConfigAttribute> set = new HashSet<ConfigAttribute>();
        for (EntryHolder h : this.requestMap) {
            set.addAll(h.getConfigAttributes());
        }
        return set;
    }

    public int getMapSize() {
        return this.requestMap.size();
    }

    public boolean isConvertUrlToLowercaseBeforeComparison() {
        return this.convertUrlToLowercaseBeforeComparison;
    }

    public void setConvertUrlToLowercaseBeforeComparison(boolean convertUrlToLowercaseBeforeComparison) {
        this.convertUrlToLowercaseBeforeComparison = convertUrlToLowercaseBeforeComparison;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        if (object == null || !this.supports(object.getClass())) {
            throw new IllegalArgumentException("Object must be a FilterInvocation");
        }
        String url = ((FilterInvocation)object).getRequestUrl();
        String method = ((FilterInvocation)object).getHttpRequest().getMethod();
        return this.lookupAttributes(url, method);
    }

    public Collection<ConfigAttribute> lookupAttributes(String url) {
        throw new IllegalArgumentException("lookupAttributes(String url) is INVALID for RESTfulDefinitionSource");
    }

    public Collection<ConfigAttribute> lookupAttributes(String url, String httpMethod) {
        int firstQuestionMarkIndex = url.indexOf("?");
        if (firstQuestionMarkIndex != -1) {
            url = url.substring(0, firstQuestionMarkIndex);
        }
        if (this.isConvertUrlToLowercaseBeforeComparison()) {
            url = url.toLowerCase();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Converted URL to lowercase, from: '" + url + "'; to: '" + url + "'  and httpMethod= " + httpMethod));
            }
        }
        for (EntryHolder entryHolder : this.requestMap) {
            String antPath = entryHolder.getAntPath();
            String[] methodList = entryHolder.getHttpMethodList();
            if (log.isDebugEnabled()) {
                log.debug((Object)("~~~~~~~~~~ antPath= " + antPath + " methodList= " + methodList));
                if (methodList != null) {
                    for (int ii = 0; ii < methodList.length; ++ii) {
                        log.debug((Object)("method[" + ii + "]: " + methodList[ii]));
                    }
                }
            }
            boolean matchedPath = this.pathMatcher.match(antPath, url);
            boolean matchedMethods = true;
            if (methodList != null) {
                matchedMethods = false;
                for (int ii = 0; ii < methodList.length; ++ii) {
                    if (!methodList[ii].equals(httpMethod)) continue;
                    matchedMethods = true;
                    break;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Candidate is: '" + url + "'; antPath is " + antPath + "; matchedPath=" + matchedPath + "; matchedMethods=" + matchedMethods));
            }
            if (!matchedPath || !matchedMethods) continue;
            return entryHolder.getConfigAttributes();
        }
        return null;
    }

    protected class EntryHolder {
        private Collection<ConfigAttribute> configAttributes;
        private String antPath;
        private String[] httpMethodList;

        public EntryHolder(String antPath, String[] httpMethodList, Collection<ConfigAttribute> attrs) {
            this.antPath = antPath;
            this.configAttributes = attrs;
            this.httpMethodList = httpMethodList;
        }

        protected EntryHolder() {
            throw new IllegalArgumentException("Cannot use default constructor");
        }

        public String getAntPath() {
            return this.antPath;
        }

        public String[] getHttpMethodList() {
            return this.httpMethodList;
        }

        public Collection<ConfigAttribute> getConfigAttributes() {
            return this.configAttributes;
        }
    }
}

