/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.SecurityManagerListener;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.filter.GeoServerAnonymousAuthenticationFilter;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.AntPathRequestMatcher;

public class GeoServerSecurityFilterChainProxy
extends FilterChainProxy
implements SecurityManagerListener,
ApplicationContextAware {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    static ThreadLocal<HttpServletRequest> REQUEST = new ThreadLocal();
    private boolean chainsInitialized;
    GeoServerSecurityManager securityManager;
    ApplicationContext appContext;

    public GeoServerSecurityFilterChainProxy(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
        this.securityManager.addListener(this);
        this.chainsInitialized = false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        REQUEST.set((HttpServletRequest)request);
        try {
            super.doFilter(request, response, chain);
        }
        finally {
            REQUEST.remove();
        }
    }

    @Override
    public void handlePostChanged(GeoServerSecurityManager securityManager) {
        this.createFilterChain();
    }

    public void afterPropertiesSet() {
        this.createFilterChain();
        super.afterPropertiesSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createFilterChain() {
        if (!this.securityManager.isInitialized()) {
            // empty if block
        }
        SecurityManagerConfig config = this.securityManager.getSecurityConfig();
        GeoServerSecurityFilterChain filterChain = new GeoServerSecurityFilterChain(config.getFilterChain());
        filterChain.postConfigure(this.securityManager);
        Map<String, List<String>> rawFilterChainMap = filterChain.compileFilterMap();
        LinkedHashMap filterChainMap = new LinkedHashMap();
        for (String pattern : rawFilterChainMap.keySet()) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (String filterName : rawFilterChainMap.get(pattern)) {
                try {
                    Filter filter = this.lookupFilter(filterName);
                    if (filter == null) {
                        throw new NullPointerException("No filter named " + filterName + " could " + "be found");
                    }
                    if (filter instanceof GeoServerAnonymousAuthenticationFilter && !config.isAnonymousAuth().booleanValue()) continue;
                    filters.add(filter);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Error loading filter: " + filterName, ex);
                }
            }
            for (String p : pattern.split(",")) {
                filterChainMap.put(new AntPathRequestMatcher(p), filters);
            }
        }
        GeoServerSecurityFilterChainProxy geoServerSecurityFilterChainProxy = this;
        synchronized (geoServerSecurityFilterChainProxy) {
            if (this.chainsInitialized) {
                for (SecurityFilterChain chain : this.getFilterChains()) {
                    for (Filter filter : chain.getFilters()) {
                        filter.destroy();
                    }
                }
            }
            this.securityManager.getAuthenticationCache().removeAll();
            this.setFilterChainMap(filterChainMap);
            this.chainsInitialized = true;
        }
    }

    Filter lookupFilter(String filterName) throws IOException {
        Object obj;
        GeoServerSecurityFilter filter = this.securityManager.loadFilter(filterName);
        if (filter == null && (obj = GeoServerExtensions.bean((String)filterName, (ApplicationContext)this.appContext)) != null && obj instanceof Filter) {
            filter = (Filter)obj;
        }
        return filter;
    }

    public void destroy() {
        super.destroy();
        this.securityManager.removeListener(this);
    }

    protected final void addConstantFilterChains(GeoServerSecurityFilterChain chain) {
    }
}

