/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityProvider;
import org.geoserver.security.RequestFilterChain;

public class GeoServerSecurityFilterChain
implements Serializable {
    private static final long serialVersionUID = 1L;
    List<RequestFilterChain> requestChains = new ArrayList<RequestFilterChain>();
    public static final String WEB_CHAIN = "/web/**";
    public static final String FORM_LOGIN_CHAIN = "/j_spring_security_check,/j_spring_security_check/";
    public static final String FORM_LOGOUT_CHAIN = "/j_spring_security_logout,/j_spring_security_logout/";
    public static final String REST_CHAIN = "/rest/**";
    public static final String GWC_WEB_CHAIN = "/gwc/rest/web/**";
    public static final String GWC_REST_CHAIN = "/gwc/rest/**";
    public static final String DEFAULT_CHAIN = "/**";
    public static final String SECURITY_CONTEXT_ASC_FILTER = "contextAsc";
    public static final String SECURITY_CONTEXT_NO_ASC_FILTER = "contextNoAsc";
    public static final String FORM_LOGIN_FILTER = "form";
    public static final String FORM_LOGOUT_FILTER = "formLogout";
    public static final String REMEMBER_ME_FILTER = "rememberme";
    public static final String ANONYMOUS_FILTER = "anonymous";
    public static final String BASIC_AUTH_FILTER = "basic";
    public static final String DYNAMIC_EXCEPTION_TRANSLATION_FILTER = "exception";
    public static final String GUI_EXCEPTION_TRANSLATION_FILTER = "guiException";
    public static final String FILTER_SECURITY_INTERCEPTOR = "interceptor";
    public static final String FILTER_SECURITY_REST_INTERCEPTOR = "restInterceptor";
    static RequestFilterChain WEB = new RequestFilterChain("/web/**", "/gwc/rest/web/**");
    private static RequestFilterChain WEB_LOGIN;
    private static RequestFilterChain WEB_LOGOUT;
    private static RequestFilterChain REST;
    private static RequestFilterChain GWC;
    private static RequestFilterChain DEFAULT;
    private static List<RequestFilterChain> INITIAL;

    public GeoServerSecurityFilterChain() {
        this.requestChains = new ArrayList<RequestFilterChain>();
    }

    public GeoServerSecurityFilterChain(List<RequestFilterChain> requestChains) {
        this.requestChains = requestChains;
    }

    public GeoServerSecurityFilterChain(GeoServerSecurityFilterChain other) {
        this.requestChains = new ArrayList<RequestFilterChain>(other.getRequestChains());
    }

    public static GeoServerSecurityFilterChain createInitialChain() {
        return new GeoServerSecurityFilterChain(new ArrayList<RequestFilterChain>(INITIAL));
    }

    public void postConfigure(GeoServerSecurityManager secMgr) {
        for (GeoServerSecurityProvider p : secMgr.lookupSecurityProviders()) {
            p.configureFilterChain(this);
        }
    }

    public static RequestFilterChain lookupRequestChainByName(String name, GeoServerSecurityManager secMgr) {
        GeoServerSecurityFilterChain filterChain = GeoServerSecurityFilterChain.createInitialChain();
        filterChain.postConfigure(secMgr);
        for (RequestFilterChain requestChain : filterChain.getRequestChains()) {
            if (!requestChain.getName().equals(name)) continue;
            return requestChain;
        }
        return null;
    }

    public static RequestFilterChain lookupRequestChainByPattern(String pattern, GeoServerSecurityManager secMgr) {
        GeoServerSecurityFilterChain filterChain = GeoServerSecurityFilterChain.createInitialChain();
        filterChain.postConfigure(secMgr);
        for (RequestFilterChain requestChain : filterChain.getRequestChains()) {
            if (!requestChain.getPatterns().contains(pattern)) continue;
            return requestChain;
        }
        return null;
    }

    public List<RequestFilterChain> getRequestChains() {
        return this.requestChains;
    }

    public RequestFilterChain getRequestChainByName(String name) {
        for (RequestFilterChain requestChain : this.requestChains) {
            if (!requestChain.getName().equals(name)) continue;
            return requestChain;
        }
        return null;
    }

    public Map<String, List<String>> compileFilterMap() {
        LinkedHashMap<String, List<String>> filterMap = new LinkedHashMap<String, List<String>>();
        for (RequestFilterChain ch : this.requestChains) {
            for (String p : ch.getPatterns()) {
                filterMap.put(p, ch.getFilterNames());
            }
        }
        return filterMap;
    }

    public void simplify() {
        int j = 0;
        Iterator<RequestFilterChain> it = this.requestChains.iterator();
        while (it.hasNext()) {
            RequestFilterChain requestChain = it.next();
            RequestFilterChain toMerge = null;
            for (int i = 0; i < j; ++i) {
                RequestFilterChain requestChain2 = this.requestChains.get(i);
                if (requestChain2 == requestChain || !((Object)requestChain2.getFilterNames()).equals(requestChain.getFilterNames())) continue;
                toMerge = requestChain2;
                break;
            }
            if (toMerge != null) {
                toMerge.getPatterns().addAll(requestChain.getPatterns());
                it.remove();
                --j;
            }
            ++j;
        }
    }

    public void decompileFilterMap(Map<String, List<String>> filterMap) {
        ArrayList<RequestFilterChain> requestChains = new ArrayList<RequestFilterChain>();
        for (String pattern : filterMap.keySet()) {
            List<String> filterNames = filterMap.get(pattern);
            RequestFilterChain requestChain = null;
            for (RequestFilterChain chain : requestChains) {
                if (!((Object)chain.getFilterNames()).equals(filterNames)) continue;
                requestChain = chain;
                break;
            }
            if (requestChain == null) {
                requestChain = new RequestFilterChain(pattern);
                requestChain.setFilterNames(filterNames);
            } else {
                requestChain.getPatterns().add(pattern);
            }
            requestChains.add(requestChain);
        }
        this.requestChains = requestChains;
    }

    public boolean insertFirst(String pattern, String filterName) {
        RequestFilterChain requestChain = this.findAndCheck(pattern, filterName);
        if (requestChain == null) {
            return false;
        }
        requestChain.getFilterNames().add(0, filterName);
        return false;
    }

    public boolean insertLast(String pattern, String filterName) {
        RequestFilterChain requestChain = this.findAndCheck(pattern, filterName);
        if (requestChain == null) {
            return false;
        }
        return requestChain.getFilterNames().add(filterName);
    }

    public boolean insertBefore(String pattern, String filterName, String positionName) {
        RequestFilterChain requestChain = this.findAndCheck(pattern, filterName);
        if (requestChain == null) {
            return false;
        }
        List<String> filterNames = requestChain.getFilterNames();
        int index = filterNames.indexOf(positionName);
        if (index == -1) {
            return false;
        }
        filterNames.add(index, filterName);
        return true;
    }

    public boolean insertAfter(String pattern, String filterName, String positionName) {
        RequestFilterChain requestChain = this.findAndCheck(pattern, filterName);
        if (requestChain == null) {
            return false;
        }
        List<String> filterNames = requestChain.getFilterNames();
        int index = filterNames.indexOf(positionName);
        if (index == -1) {
            return false;
        }
        filterNames.add(index + 1, filterName);
        return true;
    }

    public RequestFilterChain find(String pattern) {
        return this.requestChain(pattern);
    }

    public List<String> patternsForFilter(String filterName) {
        ArrayList<String> result = new ArrayList<String>();
        for (RequestFilterChain requestChain : this.requestChains) {
            if (!requestChain.getFilterNames().contains(filterName)) continue;
            result.addAll(requestChain.getPatterns());
        }
        return result;
    }

    public List<String> filtersFor(String pattern) {
        RequestFilterChain requestChain = this.requestChain(pattern);
        if (requestChain == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<String>(requestChain.getFilterNames());
    }

    public boolean removeForPattern(String pattern) {
        RequestFilterChain requestChain = this.requestChain(pattern);
        if (requestChain != null) {
            return this.requestChains.remove(requestChain);
        }
        return false;
    }

    RequestFilterChain findAndCheck(String pattern, String filterName) {
        RequestFilterChain requestChain = this.requestChain(pattern);
        if (requestChain == null) {
            return null;
        }
        if (requestChain.getFilterNames().contains(filterName)) {
            return null;
        }
        return requestChain;
    }

    RequestFilterChain requestChain(String pattern) {
        for (RequestFilterChain requestChain : this.requestChains) {
            if (!requestChain.getPatterns().contains(pattern)) continue;
            return requestChain;
        }
        return null;
    }

    static {
        WEB.setName("web");
        WEB.setFilterNames(SECURITY_CONTEXT_ASC_FILTER, REMEMBER_ME_FILTER, ANONYMOUS_FILTER, GUI_EXCEPTION_TRANSLATION_FILTER, FILTER_SECURITY_INTERCEPTOR);
        WEB_LOGIN = new RequestFilterChain(FORM_LOGIN_CHAIN);
        WEB_LOGIN.setName("webLogin");
        WEB_LOGIN.setFilterNames(SECURITY_CONTEXT_ASC_FILTER, FORM_LOGIN_FILTER);
        WEB_LOGOUT = new RequestFilterChain(FORM_LOGOUT_CHAIN);
        WEB_LOGOUT.setName("webLogout");
        WEB_LOGOUT.setFilterNames(SECURITY_CONTEXT_ASC_FILTER, FORM_LOGOUT_FILTER);
        REST = new RequestFilterChain(REST_CHAIN);
        REST.setName("rest");
        REST.setFilterNames(SECURITY_CONTEXT_NO_ASC_FILTER, BASIC_AUTH_FILTER, ANONYMOUS_FILTER, DYNAMIC_EXCEPTION_TRANSLATION_FILTER, FILTER_SECURITY_REST_INTERCEPTOR);
        GWC = new RequestFilterChain(GWC_REST_CHAIN);
        GWC.setName("gwc");
        GWC.setFilterNames(SECURITY_CONTEXT_NO_ASC_FILTER, BASIC_AUTH_FILTER, DYNAMIC_EXCEPTION_TRANSLATION_FILTER, FILTER_SECURITY_REST_INTERCEPTOR);
        DEFAULT = new RequestFilterChain(DEFAULT_CHAIN);
        DEFAULT.setName("default");
        DEFAULT.setFilterNames(SECURITY_CONTEXT_NO_ASC_FILTER, BASIC_AUTH_FILTER, ANONYMOUS_FILTER, DYNAMIC_EXCEPTION_TRANSLATION_FILTER, FILTER_SECURITY_INTERCEPTOR);
        INITIAL = new ArrayList<RequestFilterChain>();
        INITIAL.add(WEB);
        INITIAL.add(WEB_LOGIN);
        INITIAL.add(WEB_LOGOUT);
        INITIAL.add(REST);
        INITIAL.add(GWC);
        INITIAL.add(DEFAULT);
    }
}

