/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class DelegatingAuthenticationProvider
extends GeoServerAuthenticationProvider {
    AuthenticationProvider authProvider;

    public DelegatingAuthenticationProvider(AuthenticationProvider authProvider) {
        this.authProvider = authProvider;
    }

    @Override
    public boolean supports(Class<? extends Object> authentication, HttpServletRequest request) {
        return this.authProvider.supports(authentication);
    }

    @Override
    public final Authentication authenticate(Authentication authentication, HttpServletRequest request) {
        try {
            return this.doAuthenticate(authentication, request);
        }
        catch (AuthenticationException ex) {
            this.log(ex);
            return null;
        }
    }

    protected Authentication doAuthenticate(Authentication authentication, HttpServletRequest request) throws AuthenticationException {
        return this.authProvider.authenticate(authentication);
    }
}

