/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.UserGroupLoadedListener;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.validation.PasswordPolicyException;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public abstract class AuthorizingUserGroupService
implements GeoServerUserGroupStore {
    protected GeoServerUserGroupService delegate;

    protected AuthorizingUserGroupService(GeoServerUserGroupService delegate) {
        this.delegate = delegate;
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        this.delegate.initializeFromConfig(config);
    }

    @Override
    public boolean canCreateStore() {
        return this.delegate.canCreateStore();
    }

    @Override
    public GeoServerUserGroupStore createStore() throws IOException {
        try {
            return (GeoServerUserGroupStore)this.getClass().getConstructor(GeoServerUserGroupService.class).newInstance(this.delegate.createStore());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public void setName(String name) {
        this.delegate.setName(name);
    }

    @Override
    public void setSecurityManager(GeoServerSecurityManager securityManager) {
        this.delegate.setSecurityManager(securityManager);
    }

    @Override
    public GeoServerSecurityManager getSecurityManager() {
        return this.delegate.getSecurityManager();
    }

    @Override
    public void registerUserGroupLoadedListener(UserGroupLoadedListener listener) {
        this.delegate.registerUserGroupLoadedListener(listener);
    }

    @Override
    public void unregisterUserGroupLoadedListener(UserGroupLoadedListener listener) {
        this.delegate.unregisterUserGroupLoadedListener(listener);
    }

    @Override
    public String getPasswordEncoderName() {
        return this.delegate.getPasswordEncoderName();
    }

    @Override
    public String getPasswordValidatorName() {
        return this.delegate.getPasswordValidatorName();
    }

    @Override
    public void load() throws IOException {
        this.delegate.load();
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.filterUser((GeoServerUser)this.delegate.loadUserByUsername(username));
    }

    @Override
    public GeoServerUserGroup getGroupByGroupname(String groupname) throws IOException {
        return this.filterGroup(this.delegate.getGroupByGroupname(groupname));
    }

    @Override
    public GeoServerUser getUserByUsername(String username) throws IOException {
        return this.filterUser(this.delegate.getUserByUsername(username));
    }

    @Override
    public GeoServerUser createUserObject(String username, String password, boolean isEnabled) throws IOException {
        return this.filterUser(this.delegate.createUserObject(username, password, isEnabled));
    }

    @Override
    public GeoServerUserGroup createGroupObject(String groupname, boolean isEnabled) throws IOException {
        return this.filterGroup(this.delegate.createGroupObject(groupname, isEnabled));
    }

    @Override
    public SortedSet<GeoServerUser> getUsers() throws IOException {
        return this.filterUsers(new TreeSet<GeoServerUser>(this.delegate.getUsers()));
    }

    @Override
    public SortedSet<GeoServerUserGroup> getUserGroups() throws IOException {
        return this.filterGroups(new TreeSet<GeoServerUserGroup>(this.delegate.getUserGroups()));
    }

    @Override
    public SortedSet<GeoServerUser> getUsersForGroup(GeoServerUserGroup group) throws IOException {
        return this.filterUsers(new TreeSet<GeoServerUser>(this.delegate.getUsersForGroup(group)));
    }

    @Override
    public SortedSet<GeoServerUserGroup> getGroupsForUser(GeoServerUser user) throws IOException {
        return this.filterGroups(new TreeSet<GeoServerUserGroup>(this.delegate.getGroupsForUser(user)));
    }

    @Override
    public int getUserCount() throws IOException {
        return this.getUsers().size();
    }

    @Override
    public int getGroupCount() throws IOException {
        return this.getUserGroups().size();
    }

    protected GeoServerUserGroupStore delegateAsStore() {
        return (GeoServerUserGroupStore)this.delegate;
    }

    @Override
    public void initializeFromService(GeoServerUserGroupService service) throws IOException {
        this.delegateAsStore().initializeFromService(service);
    }

    @Override
    public void clear() throws IOException {
        this.delegateAsStore().clear();
    }

    @Override
    public void store() throws IOException {
        this.delegateAsStore().store();
    }

    @Override
    public void addUser(GeoServerUser user) throws IOException, PasswordPolicyException {
        if (this.filterUser(user) != null) {
            this.delegateAsStore().addUser(user);
        }
    }

    @Override
    public void updateUser(GeoServerUser user) throws IOException, PasswordPolicyException {
        if (this.filterUser(user) != null) {
            this.delegateAsStore().updateUser(user);
        }
    }

    @Override
    public boolean removeUser(GeoServerUser user) throws IOException {
        if (this.filterUser(user) != null) {
            return this.delegateAsStore().removeUser(user);
        }
        return false;
    }

    @Override
    public void addGroup(GeoServerUserGroup group) throws IOException {
        if (this.filterGroup(group) != null) {
            this.delegateAsStore().addGroup(group);
        }
    }

    @Override
    public void updateGroup(GeoServerUserGroup group) throws IOException {
        if (this.filterGroup(group) != null) {
            this.delegateAsStore().updateGroup(group);
        }
    }

    @Override
    public boolean removeGroup(GeoServerUserGroup group) throws IOException {
        if (this.filterGroup(group) != null) {
            return this.delegateAsStore().removeGroup(group);
        }
        return false;
    }

    @Override
    public void associateUserToGroup(GeoServerUser user, GeoServerUserGroup group) throws IOException {
        if (this.filterUser(user) != null && this.filterGroup(group) != null) {
            this.delegateAsStore().associateUserToGroup(user, group);
        }
    }

    @Override
    public void disAssociateUserFromGroup(GeoServerUser user, GeoServerUserGroup group) throws IOException {
        if (this.filterUser(user) != null && this.filterGroup(group) != null) {
            this.delegateAsStore().disAssociateUserFromGroup(user, group);
        }
    }

    @Override
    public boolean isModified() {
        return this.delegateAsStore().isModified();
    }

    protected abstract GeoServerUser filterUser(GeoServerUser var1);

    protected abstract GeoServerUserGroup filterGroup(GeoServerUserGroup var1);

    protected SortedSet<GeoServerUser> filterUsers(SortedSet<GeoServerUser> users) {
        Iterator it = users.iterator();
        while (it.hasNext()) {
            if (this.filterUser((GeoServerUser)it.next()) != null) continue;
            it.remove();
        }
        return users;
    }

    protected SortedSet<GeoServerUserGroup> filterGroups(SortedSet<GeoServerUserGroup> groups) {
        Iterator it = groups.iterator();
        while (it.hasNext()) {
            if (this.filterGroup((GeoServerUserGroup)it.next()) != null) continue;
            it.remove();
        }
        return groups;
    }
}

