/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.Wrapper;
import org.geoserver.ows.LocalLayer;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.security.AbstractCatalogFilter;

public class LocalWorkspaceCatalogFilter
extends AbstractCatalogFilter {
    Catalog catalog;

    public LocalWorkspaceCatalogFilter(Catalog catalog) {
        Catalog unwrapped;
        while (catalog instanceof Wrapper && ((Wrapper)((Object)catalog)).isWrapperFor(Catalog.class) && (unwrapped = ((Wrapper)((Object)catalog)).unwrap(Catalog.class)) != catalog && unwrapped != null) {
            catalog = unwrapped;
        }
        this.catalog = catalog;
    }

    @Override
    public boolean hideLayer(LayerInfo layer) {
        return LocalLayer.get() != null && !LocalLayer.get().equals(layer);
    }

    @Override
    public boolean hideResource(ResourceInfo resource) {
        if (LocalLayer.get() != null) {
            for (LayerInfo l : resource.getCatalog().getLayers(resource)) {
                if (l.equals(LocalLayer.get())) continue;
                return true;
            }
        }
        return this.hideWorkspace(resource.getStore().getWorkspace());
    }

    @Override
    public boolean hideWorkspace(WorkspaceInfo workspace) {
        return LocalWorkspace.get() != null && !LocalWorkspace.get().equals(workspace);
    }

    @Override
    public boolean hideStyle(StyleInfo style) {
        if (style.getWorkspace() == null) {
            return LocalWorkspace.get() != null && this.catalog.getStyleByName(LocalWorkspace.get(), style.getName()) != null;
        }
        return this.hideWorkspace(style.getWorkspace());
    }

    @Override
    public boolean hideLayerGroup(LayerGroupInfo layerGroup) {
        if (layerGroup.getWorkspace() == null) {
            return LocalWorkspace.get() != null && this.catalog.getLayerGroupByName(LocalWorkspace.get(), layerGroup.getName()) != null;
        }
        return this.hideWorkspace(layerGroup.getWorkspace());
    }
}

