/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.jai;

import com.sun.media.jai.util.SunTileCache;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.config.JAIInfo;
import org.geoserver.jai.ConcurrentOperationRegistry;
import org.geoserver.jai.ConcurrentTileFactory;
import org.geotools.image.jai.Registry;

public class JAIInitializer
implements GeoServerInitializer {
    @Override
    public void initialize(GeoServer geoServer) throws Exception {
        this.initJAI(geoServer.getGlobal().getJAI());
        geoServer.addListener(new ConfigurationListenerAdapter(){

            @Override
            public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                if (propertyNames.contains("jAI")) {
                    JAIInitializer.this.initJAI(global.getJAI());
                }
            }

            @Override
            public void handlePostGlobalChange(GeoServerInfo global) {
            }
        });
    }

    void initJAI(JAIInfo jai) {
        JAI jaiDef = JAI.getDefaultInstance();
        jai.setJAI(jaiDef);
        if (!(jaiDef.getOperationRegistry() instanceof ConcurrentOperationRegistry)) {
            jaiDef.setOperationRegistry(ConcurrentOperationRegistry.initializeRegistry());
        }
        jaiDef.setRenderingHint(JAI.KEY_CACHED_TILE_RECYCLING_ENABLED, (Object)jai.isRecycling());
        if (jai.isRecycling() && !(jaiDef.getRenderingHint(JAI.KEY_TILE_FACTORY) instanceof ConcurrentTileFactory)) {
            ConcurrentTileFactory recyclingFactory = new ConcurrentTileFactory();
            jaiDef.setRenderingHint(JAI.KEY_TILE_FACTORY, (Object)recyclingFactory);
            jaiDef.setRenderingHint(JAI.KEY_TILE_RECYCLER, (Object)recyclingFactory);
        }
        SunTileCache jaiCache = (SunTileCache)jaiDef.getTileCache();
        jai.setTileCache((TileCache)jaiCache);
        long jaiMemory = (long)(jai.getMemoryCapacity() * (double)Runtime.getRuntime().maxMemory());
        jaiCache.setMemoryCapacity(jaiMemory);
        jaiCache.setMemoryThreshold((float)jai.getMemoryThreshold());
        jaiDef.getTileScheduler().setParallelism(jai.getTileThreads());
        jaiDef.getTileScheduler().setPrefetchParallelism(jai.getTileThreads());
        jaiDef.getTileScheduler().setPriority(jai.getTilePriority());
        jaiDef.getTileScheduler().setPrefetchPriority(jai.getTilePriority());
        Registry.setNativeAccelerationAllowed((String)"Mosaic", (boolean)jai.isAllowNativeMosaic(), (JAI)jaiDef);
    }
}

