/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.jai;

import com.sun.media.jai.util.DataBufferUtils;
import java.awt.Point;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.TileFactory;
import javax.media.jai.TileRecycler;
import org.apache.commons.beanutils.PropertyUtils;
import org.geotools.util.logging.Logging;

public class ConcurrentTileFactory
implements TileFactory,
TileRecycler {
    private volatile ArrayCache recycledArrays = new ArrayCache();

    public boolean canReclaimMemory() {
        return true;
    }

    public boolean isMemoryCache() {
        return true;
    }

    public long getMemoryUsed() {
        return -1L;
    }

    public void flush() {
        this.recycledArrays.clear();
    }

    public WritableRaster createTile(SampleModel sampleModel, Point location) {
        Object array;
        if (sampleModel == null) {
            throw new NullPointerException("sampleModel cannot be null");
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        DataBuffer db = null;
        int type = sampleModel.getTransferType();
        long numBanks = 0L;
        long size = 0L;
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel csm = (ComponentSampleModel)sampleModel;
            numBanks = ConcurrentTileFactory.getNumBanksCSM(csm);
            size = ConcurrentTileFactory.getBufferSizeCSM(csm);
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel mppsm = (MultiPixelPackedSampleModel)sampleModel;
            numBanks = 1L;
            int dataTypeSize = DataBuffer.getDataTypeSize(type);
            size = mppsm.getScanlineStride() * mppsm.getHeight() + (mppsm.getDataBitOffset() + dataTypeSize - 1) / dataTypeSize;
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sampleModel;
            numBanks = 1L;
            size = sppsm.getScanlineStride() * (sppsm.getHeight() - 1) + sppsm.getWidth();
        }
        if (size > 0L && (array = this.recycledArrays.getRecycledArray(type, numBanks, size)) != null) {
            switch (type) {
                case 0: {
                    byte[][] bankData = (byte[][])array;
                    int i = 0;
                    while ((long)i < numBanks) {
                        Arrays.fill(bankData[i], (byte)0);
                        ++i;
                    }
                    db = new DataBufferByte(bankData, (int)size);
                    break;
                }
                case 1: {
                    short[][] bankData = (short[][])array;
                    int i = 0;
                    while ((long)i < numBanks) {
                        Arrays.fill(bankData[i], (short)0);
                        ++i;
                    }
                    db = new DataBufferUShort(bankData, (int)size);
                    break;
                }
                case 2: {
                    short[][] bankData = (short[][])array;
                    int i = 0;
                    while ((long)i < numBanks) {
                        Arrays.fill(bankData[i], (short)0);
                        ++i;
                    }
                    db = new DataBufferShort(bankData, (int)size);
                    break;
                }
                case 3: {
                    int[][] bankData = (int[][])array;
                    int i = 0;
                    while ((long)i < numBanks) {
                        Arrays.fill(bankData[i], 0);
                        ++i;
                    }
                    db = new DataBufferInt(bankData, (int)size);
                    break;
                }
                case 4: {
                    float[][] bankData = (float[][])array;
                    int i = 0;
                    while ((long)i < numBanks) {
                        Arrays.fill(bankData[i], 0.0f);
                        ++i;
                    }
                    db = DataBufferUtils.createDataBufferFloat((float[][])bankData, (int)((int)size));
                    break;
                }
                case 5: {
                    double[][] bankData = (double[][])array;
                    int i = 0;
                    while ((long)i < numBanks) {
                        Arrays.fill(bankData[i], 0.0);
                        ++i;
                    }
                    db = DataBufferUtils.createDataBufferDouble((double[][])bankData, (int)((int)size));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown array type");
                }
            }
        }
        if (db == null) {
            db = sampleModel.createDataBuffer();
        }
        return Raster.createWritableRaster(sampleModel, db, location);
    }

    private static long getBufferSizeCSM(ComponentSampleModel csm) {
        int scanlineStride;
        int pixelStride;
        int[] bandOffsets = csm.getBandOffsets();
        int maxBandOff = bandOffsets[0];
        for (int i = 1; i < bandOffsets.length; ++i) {
            maxBandOff = Math.max(maxBandOff, bandOffsets[i]);
        }
        long size = 0L;
        if (maxBandOff >= 0) {
            size += (long)(maxBandOff + 1);
        }
        if ((pixelStride = csm.getPixelStride()) > 0) {
            size += (long)(pixelStride * (csm.getWidth() - 1));
        }
        if ((scanlineStride = csm.getScanlineStride()) > 0) {
            size += (long)(scanlineStride * (csm.getHeight() - 1));
        }
        return size;
    }

    private static long getNumBanksCSM(ComponentSampleModel csm) {
        int[] bankIndices = csm.getBankIndices();
        int maxIndex = bankIndices[0];
        for (int i = 1; i < bankIndices.length; ++i) {
            int bankIndex = bankIndices[i];
            if (bankIndex <= maxIndex) continue;
            maxIndex = bankIndex;
        }
        return maxIndex + 1;
    }

    public void recycleTile(Raster tile) {
        if (tile.getWidth() != tile.getHeight() || tile.getWidth() > 512) {
            return;
        }
        this.recycledArrays.recycleTile(tile);
    }

    private static class ArrayCache
    extends ConcurrentHashMap<Long, ConcurrentLinkedQueue<SoftReference<?>>> {
        private static final long serialVersionUID = -6905685668738379653L;
        static final Logger LOGGER = Logging.getLogger(ConcurrentTileFactory.class);

        private ArrayCache() {
        }

        Object getRecycledArray(int arrayType, long numBanks, long arrayLength) {
            Long key = this.getKey(arrayType, numBanks, arrayLength);
            ConcurrentLinkedQueue arrays = (ConcurrentLinkedQueue)this.get(key);
            if (arrays != null) {
                SoftReference arrayRef;
                while ((arrayRef = (SoftReference)arrays.poll()) != null) {
                    Object array = arrayRef.get();
                    if (array == null) continue;
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "Recycling tile hit on type:{1}, banks: {2}, arrayLength: {3}", new Object[]{arrayType, numBanks, arrayLength});
                    }
                    return array;
                }
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Recycling tile miss on type:{1}, banks: {2}, arrayLength: {3}", new Object[]{arrayType, numBanks, arrayLength});
            }
            return null;
        }

        private Long getKey(int arrayType, long numBanks, long arrayLength) {
            return (long)arrayType << 56 | numBanks << 32 | arrayLength;
        }

        public void recycleTile(Raster tile) {
            ConcurrentLinkedQueue arrays;
            DataBuffer db = tile.getDataBuffer();
            Long key = this.getKey(db.getDataType(), db.getNumBanks(), db.getSize());
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Recycling tile hit on type:{1}, banks: {2}, arrayLength: {3}", new Object[]{db.getDataType(), db.getNumBanks(), db.getSize()});
            }
            if ((arrays = (ConcurrentLinkedQueue)this.get(key)) == null) {
                arrays = new ConcurrentLinkedQueue();
                arrays.add(ArrayCache.getBankReference(db));
                this.put(key, arrays);
                return;
            }
            arrays.add(ArrayCache.getBankReference(db));
        }

        private static SoftReference<?> getBankReference(DataBuffer db) {
            try {
                Object array = PropertyUtils.getProperty((Object)db, (String)"bankData");
                return new SoftReference<Object>(array);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Unkonwn data buffer type " + db);
            }
        }
    }
}

