/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.geotools.util.logging.Logging;

public class SessionDebugFilter
implements Filter {
    static final Logger LOGGER = Logging.getLogger(SessionDebugWrapper.class);

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)req;
            chain.doFilter((ServletRequest)new SessionDebugWrapper(request), res);
        } else {
            chain.doFilter(req, res);
        }
    }

    class SessionDebugWrapper
    extends HttpServletRequestWrapper {
        public SessionDebugWrapper(HttpServletRequest request) {
            super(request);
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public HttpSession getSession(boolean create) {
            HttpSession session = super.getSession(false);
            if (session != null || !create) {
                return session;
            }
            if (this.getPathInfo().startsWith("/web")) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    Exception e = new Exception("Full stack trace for the session creation path");
                    e.fillInStackTrace();
                    LOGGER.log(Level.FINE, "Creating a new http session inside the web UI (normal behavior)", e);
                }
            } else if (LOGGER.isLoggable(Level.INFO)) {
                Exception e = new Exception("Full stack trace for the session creation path");
                e.fillInStackTrace();
                LOGGER.log(Level.INFO, "Creating a new http session outside of the web UI! (normally not desirable), the path is" + this.getPathInfo(), e);
            }
            session = super.getSession(true);
            return session;
        }
    }
}

