/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.filters.BufferedRequestWrapper;
import org.geotools.util.logging.Logging;

public class LoggingFilter
implements Filter {
    protected Logger logger = Logging.getLogger((String)"org.geoserver.filters");
    protected boolean enabled = true;
    protected boolean logBodies = true;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String message = "";
        String body = null;
        String path = "";
        if (this.enabled) {
            if (req instanceof HttpServletRequest) {
                HttpServletRequest hreq = (HttpServletRequest)req;
                path = hreq.getRemoteHost() + " \"" + hreq.getMethod() + " " + hreq.getRequestURI();
                if (hreq.getQueryString() != null) {
                    path = path + "?" + hreq.getQueryString();
                }
                path = path + "\"";
                message = "" + path;
                message = message + " \"" + this.noNull(hreq.getHeader("User-Agent"));
                message = message + "\" \"" + this.noNull(hreq.getHeader("Referer")) + "\" ";
                if (this.logBodies && (hreq.getMethod().equals("PUT") || hreq.getMethod().equals("POST"))) {
                    message = message + " request-size: " + hreq.getContentLength();
                    message = message + " body: ";
                    StringBuffer buff = new StringBuffer();
                    BufferedReader reader = hreq.getReader();
                    char[] readIn = new char[256];
                    int amountRead = 0;
                    while ((amountRead = reader.read(readIn, 0, 256)) != -1) {
                        buff.append(readIn, 0, amountRead);
                    }
                    body = buff.toString();
                    req = new BufferedRequestWrapper(hreq, buff.toString());
                }
            } else {
                message = "" + req.getRemoteHost() + " made a non-HTTP request";
            }
            this.logger.info(message + (body == null ? "" : "\n" + body + "\n"));
            long startTime = System.currentTimeMillis();
            chain.doFilter(req, res);
            long requestTime = System.currentTimeMillis() - startTime;
            this.logger.info(path + " took " + requestTime + "ms");
        } else {
            chain.doFilter(req, res);
        }
    }

    public void init(FilterConfig filterConfig) {
        this.enabled = this.getConfigBool("enabled", filterConfig);
        this.logBodies = this.getConfigBool("log-request-bodies", filterConfig);
    }

    protected boolean getConfigBool(String name, FilterConfig conf) {
        try {
            String value = conf.getInitParameter(name);
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected String noNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public void destroy() {
    }
}

