/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.SingleValueConverterWrapper;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SortableFieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.Sun14ReflectionProvider;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.ClassAliasingMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MultiHashMap;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.AttributeTypeInfoImpl;
import org.geoserver.catalog.impl.AttributionInfoImpl;
import org.geoserver.catalog.impl.AuthorityURL;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.CoverageDimensionImpl;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.CoverageStoreInfoImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.DefaultCatalogFacade;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerIdentifier;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.MetadataLinkInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.ResolvingProxy;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.catalog.impl.StoreInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.catalog.impl.WMSLayerInfoImpl;
import org.geoserver.catalog.impl.WMSStoreInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.CoverageAccessInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.JAIInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.config.impl.CoverageAccessInfoImpl;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.config.impl.JAIInfoImpl;
import org.geoserver.config.impl.LoggingInfoImpl;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.config.impl.SettingsInfoImpl;
import org.geoserver.config.util.AuthorityURLInfoInfoListConverter;
import org.geoserver.config.util.LaxCollectionConverter;
import org.geoserver.config.util.LayerIdentifierInfoListConverter;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.SecureCatalogImpl;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.RegexpValidator;
import org.geotools.jdbc.VirtualTable;
import org.geotools.jdbc.VirtualTableParameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.util.Converters;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class XStreamPersister {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver");
    XStream xs;
    GeoServer geoserver;
    Catalog catalog;
    Callback callback;
    boolean referenceByName = false;
    Map<String, Class<?>> forwardBreifMap = new HashMap();
    Map<Class<?>, String> backwardBreifMap = new HashMap();

    protected XStreamPersister() {
        this(null);
    }

    protected XStreamPersister(HierarchicalStreamDriver streamDriver) {
        SortableFieldKeySorter sorter = new SortableFieldKeySorter();
        CustomReflectionProvider reflectionProvider = new CustomReflectionProvider(new FieldDictionary((FieldKeySorter)sorter));
        this.xs = streamDriver != null ? new XStream((ReflectionProvider)reflectionProvider, streamDriver) : new XStream((ReflectionProvider)reflectionProvider);
        this.xs.setMode(1001);
        this.init(this.xs);
    }

    protected void init(XStream xs) {
        this.initImplementationDefaults(xs);
        xs.alias("global", GeoServerInfo.class);
        xs.alias("settings", SettingsInfo.class);
        xs.alias("logging", LoggingInfo.class);
        xs.alias("jai", JAIInfo.class);
        xs.alias("coverageAccess", CoverageAccessInfo.class);
        xs.alias("catalog", Catalog.class);
        xs.alias("namespace", NamespaceInfo.class);
        xs.alias("workspace", WorkspaceInfo.class);
        xs.alias("dataStore", DataStoreInfo.class);
        xs.alias("wmsStore", WMSStoreInfo.class);
        xs.alias("coverageStore", CoverageStoreInfo.class);
        xs.alias("style", StyleInfo.class);
        xs.alias("featureType", FeatureTypeInfo.class);
        xs.alias("coverage", CoverageInfo.class);
        xs.alias("wmsLayer", WMSLayerInfo.class);
        xs.alias("coverageDimension", CoverageDimensionInfo.class);
        xs.alias("metadataLink", MetadataLinkInfo.class);
        xs.alias("attribute", AttributeTypeInfo.class);
        xs.alias("layer", LayerInfo.class);
        xs.alias("layerGroup", LayerGroupInfo.class);
        xs.alias("gridGeometry", GridGeometry2D.class);
        xs.alias("projected", DefaultProjectedCRS.class);
        xs.alias("attribution", AttributionInfo.class);
        xs.aliasField("abstract", ResourceInfoImpl.class, "_abstract");
        xs.alias("AuthorityURL", AuthorityURLInfo.class);
        xs.alias("Identifier", LayerIdentifierInfo.class);
        xs.omitField(this.impl(GeoServerInfo.class), "clientProperties");
        xs.omitField(this.impl(GeoServerInfo.class), "geoServer");
        xs.registerLocalConverter(this.impl(GeoServerInfo.class), "metadata", (Converter)new MetadataMapConverter());
        xs.omitField(this.impl(ServiceInfo.class), "clientProperties");
        xs.omitField(this.impl(ServiceInfo.class), "geoServer");
        xs.registerLocalConverter(this.impl(ServiceInfo.class), "workspace", (Converter)new ReferenceConverter(WorkspaceInfo.class));
        xs.registerLocalConverter(this.impl(ServiceInfo.class), "metadata", (Converter)new MetadataMapConverter());
        xs.registerLocalConverter(this.impl(ServiceInfo.class), "keywords", (Converter)new KeywordListConverter());
        xs.omitField(this.impl(Catalog.class), "resourcePool");
        xs.omitField(this.impl(Catalog.class), "resourceLoader");
        xs.omitField(this.impl(Catalog.class), "listeners");
        xs.omitField(this.impl(Catalog.class), "LOGGER");
        xs.omitField(this.impl(DefaultCatalogFacade.class), "catalog");
        xs.omitField(this.impl(DefaultCatalogFacade.class), "resources");
        xs.omitField(this.impl(DefaultCatalogFacade.class), "layers");
        xs.omitField(this.impl(DefaultCatalogFacade.class), "maps");
        xs.omitField(this.impl(DefaultCatalogFacade.class), "layerGroups");
        xs.registerLocalConverter(DefaultCatalogFacade.class, "stores", (Converter)new StoreMultiHashMapConverter());
        xs.registerLocalConverter(DefaultCatalogFacade.class, "namespaces", (Converter)new SpaceMapConverter("namespace"));
        xs.registerLocalConverter(DefaultCatalogFacade.class, "workspaces", (Converter)new SpaceMapConverter("workspace"));
        xs.omitField(this.impl(WorkspaceInfo.class), "_default");
        xs.registerLocalConverter(this.impl(WorkspaceInfo.class), "metadata", (Converter)new MetadataMapConverter());
        xs.omitField(this.impl(NamespaceInfo.class), "catalog");
        xs.omitField(this.impl(NamespaceInfo.class), "_default");
        xs.registerLocalConverter(this.impl(NamespaceInfo.class), "metadata", (Converter)new MetadataMapConverter());
        xs.omitField(this.impl(StoreInfo.class), "catalog");
        xs.omitField(this.impl(StoreInfo.class), "error");
        xs.registerLocalConverter(this.impl(StoreInfo.class), "workspace", (Converter)new ReferenceConverter(WorkspaceInfo.class));
        xs.registerLocalConverter(this.impl(StoreInfo.class), "connectionParameters", (Converter)new BreifMapConverter());
        xs.registerLocalConverter(this.impl(StoreInfo.class), "metadata", (Converter)new MetadataMapConverter());
        xs.omitField(this.impl(StyleInfo.class), "catalog");
        xs.registerLocalConverter(this.impl(StyleInfo.class), "workspace", (Converter)new ReferenceConverter(WorkspaceInfo.class));
        xs.registerLocalConverter(this.impl(StyleInfo.class), "metadata", (Converter)new MetadataMapConverter());
        xs.omitField(this.impl(ResourceInfo.class), "catalog");
        xs.omitField(this.impl(ResourceInfo.class), "crs");
        xs.registerLocalConverter(this.impl(ResourceInfo.class), "nativeCRS", (SingleValueConverter)new CRSConverter());
        xs.registerLocalConverter(this.impl(ResourceInfo.class), "store", (Converter)new ReferenceConverter(StoreInfo.class));
        xs.registerLocalConverter(this.impl(ResourceInfo.class), "namespace", (Converter)new ReferenceConverter(NamespaceInfo.class));
        xs.registerLocalConverter(this.impl(ResourceInfo.class), "metadata", (Converter)new MetadataMapConverter());
        xs.registerLocalConverter(this.impl(ResourceInfo.class), "keywords", (Converter)new KeywordListConverter());
        xs.registerLocalConverter(this.impl(CoverageInfo.class), "supportedFormats", (Converter)new LaxCollectionConverter(xs.getMapper()));
        xs.registerLocalConverter(this.impl(CoverageInfo.class), "requestSRS", (Converter)new LaxCollectionConverter(xs.getMapper()));
        xs.registerLocalConverter(this.impl(CoverageInfo.class), "responseSRS", (Converter)new LaxCollectionConverter(xs.getMapper()));
        xs.registerLocalConverter(this.impl(CoverageInfo.class), "interpolationMethods", (Converter)new LaxCollectionConverter(xs.getMapper()));
        xs.registerLocalConverter(this.impl(CoverageInfo.class), "dimensions", (Converter)new LaxCollectionConverter(xs.getMapper()));
        xs.registerLocalConverter(this.impl(CoverageDimensionInfo.class), "range", (Converter)new NumberRangeConverter());
        xs.omitField(this.impl(AttributeTypeInfo.class), "featureType");
        xs.omitField(this.impl(AttributeTypeInfo.class), "attribute");
        xs.registerLocalConverter(this.impl(LayerInfo.class), "resource", (Converter)new ReferenceConverter(ResourceInfo.class));
        xs.registerLocalConverter(this.impl(LayerInfo.class), "defaultStyle", (Converter)new ReferenceConverter(StyleInfo.class));
        xs.registerLocalConverter(this.impl(LayerInfo.class), "styles", (Converter)new ReferenceCollectionConverter(StyleInfo.class));
        xs.registerLocalConverter(this.impl(LayerInfo.class), "metadata", (Converter)new MetadataMapConverter());
        xs.registerLocalConverter(this.impl(LayerGroupInfo.class), "workspace", (Converter)new ReferenceConverter(WorkspaceInfo.class));
        xs.registerLocalConverter(this.impl(LayerGroupInfo.class), "layers", (Converter)new ReferenceCollectionConverter(LayerInfo.class));
        xs.registerLocalConverter(this.impl(LayerGroupInfo.class), "styles", (Converter)new ReferenceCollectionConverter(StyleInfo.class));
        xs.registerLocalConverter(this.impl(LayerGroupInfo.class), "metadata", (Converter)new MetadataMapConverter());
        xs.registerLocalConverter(ReferencedEnvelope.class, "crs", (SingleValueConverter)new SRSConverter());
        xs.registerLocalConverter(GeneralEnvelope.class, "crs", (SingleValueConverter)new SRSConverter());
        xs.omitField(this.impl(ServiceInfo.class), "geoServer");
        xs.registerConverter((Converter)new SpaceInfoConverter());
        xs.registerConverter((Converter)new StoreInfoConverter());
        xs.registerConverter((Converter)new ResourceInfoConverter());
        xs.registerConverter((Converter)new FeatureTypeInfoConverter());
        xs.registerConverter((Converter)new CoverageInfoConverter());
        xs.registerConverter((Converter)new LayerInfoConverter());
        xs.registerConverter((Converter)new LayerGroupInfoConverter());
        xs.registerConverter((Converter)new GridGeometry2DConverter());
        xs.registerConverter((Converter)new ProxyCollectionConverter(xs.getMapper()));
        xs.registerConverter((Converter)new VirtualTableConverter());
        xs.registerConverter((SingleValueConverter)new KeywordInfoConverter());
        this.registerBreifMapComplexType("virtualTable", VirtualTable.class);
        this.registerBreifMapComplexType("dimensionInfo", DimensionInfoImpl.class);
        this.callback = new Callback();
    }

    public void registerBreifMapComplexType(String typeId, Class clazz) {
        this.forwardBreifMap.put(typeId, clazz);
        this.backwardBreifMap.put(clazz, typeId);
    }

    public XStream getXStream() {
        return this.xs;
    }

    public ClassAliasingMapper getClassAliasingMapper() {
        return (ClassAliasingMapper)this.xs.getMapper().lookupMapperOfType(ClassAliasingMapper.class);
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public void setGeoServer(GeoServer geoserver) {
        this.geoserver = geoserver;
    }

    public GeoServerSecurityManager getSecurityManager() {
        return (GeoServerSecurityManager)((Object)GeoServerExtensions.bean(GeoServerSecurityManager.class));
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public void setReferenceByName(boolean referenceByName) {
        this.referenceByName = referenceByName;
    }

    public void setExcludeIds() {
        this.xs.omitField(WorkspaceInfoImpl.class, "id");
        this.xs.omitField(NamespaceInfoImpl.class, "id");
        this.xs.omitField(StoreInfoImpl.class, "id");
        this.xs.omitField(StyleInfoImpl.class, "id");
        this.xs.omitField(ResourceInfoImpl.class, "id");
        this.xs.omitField(LayerInfoImpl.class, "id");
        this.xs.omitField(LayerGroupInfoImpl.class, "id");
        this.xs.omitField(AttributeTypeInfoImpl.class, "id");
    }

    public void setHideFeatureTypeAttributes() {
        this.xs.omitField(FeatureTypeInfoImpl.class, "attributes");
    }

    public void save(Object obj, OutputStream out) throws IOException {
        obj = XStreamPersister.unwrapProxies(obj);
        this.xs.toXML(obj, (Writer)new OutputStreamWriter(out, "UTF-8"));
    }

    public static Object unwrapProxies(Object obj) {
        obj = SecureCatalogImpl.unwrap(obj);
        obj = GeoServerImpl.unwrap(obj);
        obj = CatalogImpl.unwrap(obj);
        return obj;
    }

    public <T> T load(InputStream in, Class<T> clazz) throws IOException {
        T obj = clazz.cast(this.xs.fromXML(in));
        if (obj instanceof CatalogImpl) {
            ((CatalogImpl)obj).resolve();
        }
        return obj;
    }

    public ReferenceConverter buildReferenceConverter(Class clazz) {
        return new ReferenceConverter(clazz);
    }

    public ReferenceCollectionConverter buildReferenceCollectionConverter(Class clazz) {
        return new ReferenceCollectionConverter(clazz);
    }

    protected void initImplementationDefaults(XStream xs) {
        xs.addDefaultImplementation(GeoServerInfoImpl.class, GeoServerInfo.class);
        xs.addDefaultImplementation(SettingsInfoImpl.class, SettingsInfo.class);
        xs.addDefaultImplementation(LoggingInfoImpl.class, LoggingInfo.class);
        xs.addDefaultImplementation(JAIInfoImpl.class, JAIInfo.class);
        xs.addDefaultImplementation(CoverageAccessInfoImpl.class, CoverageAccessInfo.class);
        xs.addDefaultImplementation(ContactInfoImpl.class, ContactInfo.class);
        xs.addDefaultImplementation(AttributionInfoImpl.class, AttributionInfo.class);
        xs.addDefaultImplementation(CatalogImpl.class, Catalog.class);
        xs.addDefaultImplementation(NamespaceInfoImpl.class, NamespaceInfo.class);
        xs.addDefaultImplementation(WorkspaceInfoImpl.class, WorkspaceInfo.class);
        xs.addDefaultImplementation(DataStoreInfoImpl.class, DataStoreInfo.class);
        xs.addDefaultImplementation(WMSStoreInfoImpl.class, WMSStoreInfo.class);
        xs.addDefaultImplementation(CoverageStoreInfoImpl.class, CoverageStoreInfo.class);
        xs.addDefaultImplementation(StyleInfoImpl.class, StyleInfo.class);
        xs.addDefaultImplementation(FeatureTypeInfoImpl.class, FeatureTypeInfo.class);
        xs.addDefaultImplementation(CoverageInfoImpl.class, CoverageInfo.class);
        xs.addDefaultImplementation(WMSLayerInfoImpl.class, WMSLayerInfo.class);
        xs.addDefaultImplementation(CoverageDimensionImpl.class, CoverageDimensionInfo.class);
        xs.addDefaultImplementation(MetadataLinkInfoImpl.class, MetadataLinkInfo.class);
        xs.addDefaultImplementation(AttributeTypeInfoImpl.class, AttributeTypeInfo.class);
        xs.addDefaultImplementation(LayerInfoImpl.class, LayerInfo.class);
        xs.addDefaultImplementation(LayerGroupInfoImpl.class, LayerGroupInfo.class);
        xs.addDefaultImplementation(LayerIdentifier.class, LayerIdentifierInfo.class);
        xs.addDefaultImplementation(AuthorityURL.class, AuthorityURLInfo.class);
        xs.addDefaultImplementation(GridGeometry2D.class, GridGeometry.class);
        xs.addDefaultImplementation(DefaultGeographicCRS.class, CoordinateReferenceSystem.class);
        xs.addDefaultImplementation(ArrayList.class, List.class);
    }

    protected Class impl(Class interfce) {
        if (interfce == ServiceInfo.class) {
            return ServiceInfoImpl.class;
        }
        if (interfce == StoreInfo.class) {
            return StoreInfoImpl.class;
        }
        if (interfce == ResourceInfo.class) {
            return ResourceInfoImpl.class;
        }
        Class clazz = this.getXStream().getMapper().defaultImplementationOf(interfce);
        if (clazz == null) {
            throw new RuntimeException("No default mapping for " + interfce);
        }
        return clazz;
    }

    class KeywordListConverter
    extends LaxCollectionConverter {
        public KeywordListConverter() {
            super(XStreamPersister.this.getXStream().getMapper());
        }

        protected Object readItem(HierarchicalStreamReader reader, UnmarshallingContext context, Object current) {
            return context.convertAnother(current, Keyword.class);
        }

        protected void writeItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
            ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)"string", Keyword.class);
            context.convertAnother(item);
            writer.endNode();
        }
    }

    static class KeywordInfoConverter
    extends AbstractSingleValueConverter {
        static Pattern RE = Pattern.compile("([^\\\\]+)(?:\\\\@language=([^\\\\]+)\\\\;)?(?:\\\\@vocabulary=([^\\\\]+)\\\\;)?");

        KeywordInfoConverter() {
        }

        public boolean canConvert(Class type) {
            return Keyword.class.isAssignableFrom(type);
        }

        public Object fromString(String str) {
            Matcher m = RE.matcher(str);
            if (!m.matches()) {
                throw new IllegalArgumentException(String.format("%s does not match regular expression: %s", str, RE));
            }
            Keyword kw = new Keyword(m.group(1));
            if (m.group(2) != null) {
                kw.setLanguage(m.group(2));
            }
            if (m.group(3) != null) {
                kw.setVocabulary(m.group(3));
            }
            return kw;
        }

        public String toString(Object obj) {
            KeywordInfo kw = (KeywordInfo)obj;
            StringBuilder sb = new StringBuilder();
            sb.append(kw.getValue());
            if (kw.getLanguage() != null) {
                sb.append("\\@language=").append(kw.getLanguage()).append("\\;");
            }
            if (kw.getVocabulary() != null) {
                sb.append("\\@vocabulary=").append(kw.getVocabulary()).append("\\;");
            }
            return sb.toString();
        }
    }

    class VirtualTableConverter
    implements Converter {
        VirtualTableConverter() {
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            VirtualTable vt = (VirtualTable)source;
            writer.startNode("name");
            writer.setValue(vt.getName());
            writer.endNode();
            writer.startNode("sql");
            writer.setValue(vt.getSql());
            writer.endNode();
            if (vt.getPrimaryKeyColumns() != null) {
                for (String pk : vt.getPrimaryKeyColumns()) {
                    writer.startNode("keyColumn");
                    writer.setValue(pk);
                    writer.endNode();
                }
            }
            if (vt.getGeometries() != null) {
                for (String geom : vt.getGeometries()) {
                    writer.startNode("geometry");
                    writer.startNode("name");
                    writer.setValue(geom);
                    writer.endNode();
                    writer.startNode("type");
                    writer.setValue(Geometries.getForBinding((Class)vt.getGeometryType(geom)).getName());
                    writer.endNode();
                    writer.startNode("srid");
                    writer.setValue(String.valueOf(vt.getNativeSrid(geom)));
                    writer.endNode();
                    writer.endNode();
                }
            }
            if (vt.getParameterNames().size() > 0) {
                for (String name : vt.getParameterNames()) {
                    VirtualTableParameter param = vt.getParameter(name);
                    writer.startNode("parameter");
                    writer.startNode("name");
                    writer.setValue(name);
                    writer.endNode();
                    if (param.getDefaultValue() != null) {
                        writer.startNode("defaultValue");
                        writer.setValue(param.getDefaultValue());
                        writer.endNode();
                    }
                    if (param.getValidator() != null) {
                        if (param.getValidator() instanceof RegexpValidator) {
                            writer.startNode("regexpValidator");
                            writer.setValue(((RegexpValidator)param.getValidator()).getPattern().pattern());
                            writer.endNode();
                        } else {
                            throw new RuntimeException("Cannot handle this type of validator, please extend the VirtualTableConverter " + param.getValidator().getClass());
                        }
                    }
                    writer.endNode();
                }
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String name = this.readValue("name", String.class, reader);
            String sql = this.readValue("sql", String.class, reader);
            VirtualTable vt = new VirtualTable(name, sql);
            ArrayList<String> primaryKeys = new ArrayList<String>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if (reader.getNodeName().equals("keyColumn")) {
                    primaryKeys.add(reader.getValue());
                } else if (reader.getNodeName().equals("geometry")) {
                    String geomName = this.readValue("name", String.class, reader);
                    Geometries geomType = Geometries.getForName((String)this.readValue("type", String.class, reader));
                    Class type = geomType == null ? Geometry.class : geomType.getBinding();
                    int srid = this.readValue("srid", Integer.class, reader);
                    vt.addGeometryMetadatata(geomName, type, srid);
                } else if (reader.getNodeName().equals("parameter")) {
                    String pname = this.readValue("name", String.class, reader);
                    String defaultValue = null;
                    RegexpValidator validator = null;
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        if (reader.getNodeName().equals("defaultValue")) {
                            defaultValue = reader.getValue();
                        } else if (reader.getNodeName().equals("regexpValidator")) {
                            validator = new RegexpValidator(reader.getValue());
                        }
                        reader.moveUp();
                    }
                    vt.addParameter(new VirtualTableParameter(pname, defaultValue, validator));
                }
                reader.moveUp();
            }
            vt.setPrimaryKeyColumns(primaryKeys);
            return vt;
        }

        <T> T readValue(String name, Class<T> type, HierarchicalStreamReader reader) {
            if (!reader.hasMoreChildren()) {
                throw new IllegalArgumentException("Expected element " + name + " but could not find it");
            }
            reader.moveDown();
            if (!name.equals(reader.getNodeName())) {
                throw new IllegalArgumentException("Expected element " + name + " but found " + reader.getNodeName() + " instead");
            }
            String value = reader.getValue();
            reader.moveUp();
            return (T)Converters.convert((Object)value, type);
        }

        public boolean canConvert(Class type) {
            return VirtualTable.class.isAssignableFrom(type);
        }
    }

    class LayerGroupInfoConverter
    extends AbstractReflectionConverter {
        public LayerGroupInfoConverter() {
            super(LayerGroupInfo.class);
        }

        @Override
        protected void postDoMarshal(Object result, HierarchicalStreamWriter writer, MarshallingContext context) {
            XStreamPersister.this.callback.postEncodeLayerGroup((LayerGroupInfo)result, writer, context);
        }

        public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
            String serialized;
            LayerGroupInfoImpl lgi = (LayerGroupInfoImpl)super.doUnmarshal(result, reader, context);
            MetadataMap metadata = lgi.getMetadata();
            if (lgi.getAuthorityURLs() == null && metadata != null) {
                serialized = metadata.get("authorityURLs", String.class);
                List<AuthorityURLInfo> authorities = serialized == null ? new ArrayList<AuthorityURLInfo>(1) : AuthorityURLInfoInfoListConverter.fromString(serialized);
                lgi.setAuthorityURLs(authorities);
            }
            if (lgi.getIdentifiers() == null && metadata != null) {
                serialized = metadata.get("identifiers", String.class);
                List<LayerIdentifierInfo> identifiers = serialized == null ? new ArrayList<LayerIdentifierInfo>(1) : LayerIdentifierInfoListConverter.fromString(serialized);
                lgi.setIdentifiers(identifiers);
            }
            return lgi;
        }

        @Override
        protected void doMarshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            super.doMarshal(source, writer, context);
        }
    }

    class LayerInfoConverter
    extends AbstractReflectionConverter {
        public LayerInfoConverter() {
            super(LayerInfo.class);
        }

        @Override
        protected void doMarshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            LayerInfo l = (LayerInfo)source;
            writer.startNode("name");
            writer.setValue(l.getName());
            writer.endNode();
            super.doMarshal(source, writer, context);
        }

        @Override
        protected void postDoMarshal(Object result, HierarchicalStreamWriter writer, MarshallingContext context) {
            XStreamPersister.this.callback.postEncodeLayer((LayerInfo)result, writer, context);
        }

        public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
            String serialized;
            LayerInfoImpl li = (LayerInfoImpl)super.doUnmarshal(result, reader, context);
            MetadataMap metadata = li.getMetadata();
            if (li.getAuthorityURLs() == null && metadata != null) {
                serialized = metadata.get("authorityURLs", String.class);
                List<AuthorityURLInfo> authorities = serialized == null ? new ArrayList<AuthorityURLInfo>(1) : AuthorityURLInfoInfoListConverter.fromString(serialized);
                li.setAuthorityURLs(authorities);
            }
            if (li.getIdentifiers() == null && metadata != null) {
                serialized = metadata.get("identifiers", String.class);
                List<LayerIdentifierInfo> identifiers = serialized == null ? new ArrayList<LayerIdentifierInfo>(1) : LayerIdentifierInfoListConverter.fromString(serialized);
                li.setIdentifiers(identifiers);
            }
            return li;
        }
    }

    class CoverageInfoConverter
    extends ResourceInfoConverter {
        public CoverageInfoConverter() {
            super(CoverageInfo.class);
        }

        @Override
        protected void postDoMarshal(Object result, HierarchicalStreamWriter writer, MarshallingContext context) {
            XStreamPersister.this.callback.postEncodeCoverage((CoverageInfo)result, writer, context);
        }
    }

    class FeatureTypeInfoConverter
    extends ResourceInfoConverter {
        public FeatureTypeInfoConverter() {
            super(FeatureTypeInfo.class);
        }

        @Override
        protected void postDoMarshal(Object result, HierarchicalStreamWriter writer, MarshallingContext context) {
            FeatureTypeInfoImpl featureType = (FeatureTypeInfoImpl)result;
            if (featureType.getAttributes() == null) {
                featureType.setAttributes(new ArrayList<AttributeTypeInfo>());
            }
            if (featureType.getMetadata() == null) {
                featureType.setMetadata(new MetadataMap());
            }
            XStreamPersister.this.callback.postEncodeFeatureType(featureType, writer, context);
        }
    }

    class ResourceInfoConverter
    extends AbstractReflectionConverter {
        public ResourceInfoConverter() {
            this(ResourceInfo.class);
        }

        public ResourceInfoConverter(Class clazz) {
            super(clazz);
        }

        public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
            String enabled;
            ResourceInfo obj = (ResourceInfo)super.doUnmarshal(result, reader, context);
            String string = enabled = obj.isEnabled() ? "enabled" : "disabled";
            String type = obj instanceof CoverageInfo ? "coverage" : (obj instanceof FeatureTypeInfo ? "feature type" : "resource");
            LOGGER.info("Loaded " + type + " '" + obj.getName() + "', " + enabled);
            return obj;
        }
    }

    static class SpaceMapConverter
    implements Converter {
        String name;

        public SpaceMapConverter(String name) {
            this.name = name;
        }

        public boolean canConvert(Class type) {
            return Map.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Map map = (Map)source;
            for (Map.Entry o : map.entrySet()) {
                Map.Entry e = o;
                if (e.getKey() == null) continue;
                writer.startNode(this.name);
                if (map.get(null) == e.getValue()) {
                    writer.addAttribute("default", "true");
                }
                context.convertAnother(e.getValue());
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            HashMap<String, CatalogInfo> map = new HashMap<String, CatalogInfo>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                boolean def = "true".equals(reader.getAttribute("default"));
                if ("namespace".equals(this.name)) {
                    NamespaceInfoImpl ns = (NamespaceInfoImpl)context.convertAnother(map, NamespaceInfoImpl.class);
                    map.put(ns.getPrefix(), ns);
                    if (def) {
                        map.put(null, ns);
                    }
                    LOGGER.info("Loading namespace '" + ns.getPrefix() + "'");
                } else {
                    WorkspaceInfoImpl ws = (WorkspaceInfoImpl)context.convertAnother(map, WorkspaceInfoImpl.class);
                    map.put(ws.getName(), ws);
                    if (def) {
                        map.put(null, ws);
                    }
                    LOGGER.info("Loading workspace '" + ws.getName() + "'");
                }
                reader.moveUp();
            }
            return map;
        }
    }

    static class StoreMultiHashMapConverter
    implements Converter {
        StoreMultiHashMapConverter() {
        }

        public boolean canConvert(Class type) {
            return MultiHashMap.class.equals((Object)type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            MultiHashMap map = (MultiHashMap)source;
            for (Object v : map.values()) {
                if (v instanceof DataStoreInfo) {
                    writer.startNode("dataStore");
                    context.convertAnother(v);
                    writer.endNode();
                }
                if (!(v instanceof CoverageStoreInfo)) continue;
                writer.startNode("coverageStore");
                context.convertAnother(v);
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            MultiHashMap map = new MultiHashMap();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                Object o = 0;
                o = "dataStore".equals(reader.getNodeName()) ? context.convertAnother((Object)map, DataStoreInfoImpl.class) : context.convertAnother((Object)map, CoverageStoreInfoImpl.class);
                map.put(o.getClass(), o);
                reader.moveUp();
            }
            return map;
        }
    }

    class StoreInfoConverter
    extends AbstractReflectionConverter {
        public StoreInfoConverter() {
            super(StoreInfo.class);
        }

        @Override
        protected void doMarshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            GeoServerSecurityManager secMgr = XStreamPersister.this.getSecurityManager();
            if (secMgr != null && secMgr.isInitialized()) {
                context.put((Object)"org.geoserver.config.encryptedFields", secMgr.getConfigPasswordEncryptionHelper().getEncryptedFields((StoreInfo)source));
            }
            super.doMarshal(source, writer, context);
        }

        @Override
        protected void postDoMarshal(Object result, HierarchicalStreamWriter writer, MarshallingContext context) {
            StoreInfo store = (StoreInfo)result;
            if (store instanceof DataStoreInfo) {
                XStreamPersister.this.callback.postEncodeDataStore((DataStoreInfo)store, writer, context);
            } else if (store instanceof CoverageStoreInfo) {
                XStreamPersister.this.callback.postEncodeCoverageStore((CoverageStoreInfo)store, writer, context);
            } else if (store instanceof WMSStoreInfo) {
                XStreamPersister.this.callback.postEncodeWMSStore((WMSStoreInfo)store, writer, context);
            } else {
                throw new IllegalArgumentException("Unknown store type: " + (store == null ? "null" : store.getClass().getName()));
            }
        }

        public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
            GeoServerSecurityManager secMgr;
            StoreInfo store = (StoreInfo)super.doUnmarshal(result, reader, context);
            if (store instanceof WMSStoreInfo) {
                WMSStoreInfo wmsStore = (WMSStoreInfo)store;
                MetadataMap metadata = wmsStore.getMetadata();
                Integer maxConnections = null;
                Integer connectTimeout = null;
                Integer readTimeout = null;
                if (metadata != null) {
                    maxConnections = metadata.get("maxConnections", Integer.class);
                    connectTimeout = metadata.get("connectTimeout", Integer.class);
                    readTimeout = metadata.get("readTimeout", Integer.class);
                    metadata.remove("maxConnections");
                    metadata.remove("connectTimeout");
                    metadata.remove("readTimeout");
                }
                if (wmsStore.getMaxConnections() <= 0) {
                    wmsStore.setMaxConnections(maxConnections != null && maxConnections > 0 ? maxConnections : 6);
                }
                if (wmsStore.getConnectTimeout() <= 0) {
                    wmsStore.setConnectTimeout(connectTimeout != null && connectTimeout > 0 ? connectTimeout : 30);
                }
                if (wmsStore.getReadTimeout() <= 0) {
                    wmsStore.setReadTimeout(readTimeout != null && readTimeout > 0 ? readTimeout : 60);
                }
            }
            if ((secMgr = XStreamPersister.this.getSecurityManager()) != null) {
                secMgr.getConfigPasswordEncryptionHelper().decode(store);
            }
            LOGGER.info("Loaded store '" + store.getName() + "', " + (store.isEnabled() ? "enabled" : "disabled"));
            return store;
        }
    }

    class SpaceInfoConverter
    extends AbstractReflectionConverter {
        SpaceInfoConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return WorkspaceInfo.class.isAssignableFrom(type) || NamespaceInfo.class.isAssignableFrom(type);
        }

        @Override
        protected void postDoMarshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            if (source instanceof WorkspaceInfo) {
                XStreamPersister.this.callback.postEncodeWorkspace((WorkspaceInfo)source, writer, context);
            } else {
                XStreamPersister.this.callback.postEncodeNamespace((NamespaceInfo)source, writer, context);
            }
        }
    }

    class AbstractReflectionConverter
    extends ReflectionConverter {
        Class clazz;

        public AbstractReflectionConverter() {
            this(Object.class);
        }

        public AbstractReflectionConverter(Class clazz) {
            super(XStreamPersister.this.getXStream().getMapper(), XStreamPersister.this.getXStream().getReflectionProvider());
            this.clazz = clazz;
        }

        public boolean canConvert(Class type) {
            return this.clazz.isAssignableFrom(type);
        }

        protected void doMarshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            super.doMarshal(source, writer, context);
            this.postDoMarshal(source, writer, context);
        }

        protected void postDoMarshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }
    }

    class NumberRangeConverter
    extends AbstractReflectionConverter {
        NumberRangeConverter() {
        }

        @Override
        public boolean canConvert(Class clazz) {
            return NumberRange.class.isAssignableFrom(clazz);
        }

        public void marshal(Object original, HierarchicalStreamWriter writer, MarshallingContext context) {
            NumberRange range = (NumberRange)original;
            writer.startNode("min");
            if (Double.isInfinite(((Number)((Object)range.getMinValue())).doubleValue())) {
                context.convertAnother((Object)"-inf");
            } else {
                context.convertAnother((Object)range.getMinValue());
            }
            writer.endNode();
            writer.startNode("max");
            if (Double.isInfinite(((Number)((Object)range.getMaxValue())).doubleValue())) {
                context.convertAnother((Object)"inf");
            } else {
                context.convertAnother((Object)range.getMaxValue());
            }
            writer.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Double min = null;
            Double max = null;
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if ("min".equals(reader.getNodeName()) && !"-inf".equals(reader.getValue())) {
                    min = Double.parseDouble(reader.getValue());
                }
                if ("max".equals(reader.getNodeName()) && !"inf".equals(reader.getValue())) {
                    max = Double.parseDouble(reader.getValue());
                }
                reader.moveUp();
            }
            min = min != null ? min : Double.NEGATIVE_INFINITY;
            max = max != null ? max : Double.POSITIVE_INFINITY;
            return NumberRange.create((double)min, (boolean)true, (double)max, (boolean)true);
        }
    }

    class GridGeometry2DConverter
    extends AbstractReflectionConverter {
        public GridGeometry2DConverter() {
            super(GridGeometry2D.class);
        }

        @Override
        protected void doMarshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            GridGeometry2D g = (GridGeometry2D)source;
            MathTransform tx = g.getGridToCRS();
            writer.addAttribute("dimension", String.valueOf(g.getGridRange().getDimension()));
            StringBuffer low = new StringBuffer();
            StringBuffer high = new StringBuffer();
            for (int r = 0; r < g.getGridRange().getDimension(); ++r) {
                low.append(g.getGridRange().getLow(r)).append(" ");
                high.append(g.getGridRange().getHigh(r) + 1).append(" ");
            }
            low.setLength(low.length() - 1);
            high.setLength(high.length() - 1);
            writer.startNode("range");
            writer.startNode("low");
            writer.setValue(low.toString());
            writer.endNode();
            writer.startNode("high");
            writer.setValue(high.toString());
            writer.endNode();
            writer.endNode();
            if (tx instanceof AffineTransform) {
                AffineTransform atx = (AffineTransform)tx;
                writer.startNode("transform");
                writer.startNode("scaleX");
                writer.setValue(Double.toString(atx.getScaleX()));
                writer.endNode();
                writer.startNode("scaleY");
                writer.setValue(Double.toString(atx.getScaleY()));
                writer.endNode();
                writer.startNode("shearX");
                writer.setValue(Double.toString(atx.getShearX()));
                writer.endNode();
                writer.startNode("shearY");
                writer.setValue(Double.toString(atx.getShearY()));
                writer.endNode();
                writer.startNode("translateX");
                writer.setValue(Double.toString(atx.getTranslateX()));
                writer.endNode();
                writer.startNode("translateY");
                writer.setValue(Double.toString(atx.getTranslateY()));
                writer.endNode();
                writer.endNode();
            }
            writer.startNode("crs");
            context.convertAnother((Object)g.getCoordinateReferenceSystem(), (Converter)new SingleValueConverterWrapper((SingleValueConverter)new SRSConverter()));
            writer.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            reader.moveDown();
            reader.moveDown();
            int[] low = this.toIntArray(reader.getValue());
            reader.moveUp();
            reader.moveDown();
            int[] high = this.toIntArray(reader.getValue());
            reader.moveUp();
            reader.moveUp();
            if (reader.hasMoreChildren()) {
                reader.moveDown();
            }
            AffineTransform2D gridToCRS = null;
            if ("transform".equals(reader.getNodeName())) {
                reader.moveDown();
                double sx = Double.parseDouble(reader.getValue());
                reader.moveUp();
                reader.moveDown();
                double sy = Double.parseDouble(reader.getValue());
                reader.moveUp();
                reader.moveDown();
                double shx = Double.parseDouble(reader.getValue());
                reader.moveUp();
                reader.moveDown();
                double shy = Double.parseDouble(reader.getValue());
                reader.moveUp();
                reader.moveDown();
                double tx = Double.parseDouble(reader.getValue());
                reader.moveUp();
                reader.moveDown();
                double ty = Double.parseDouble(reader.getValue());
                reader.moveUp();
                gridToCRS = new AffineTransform2D(sx, shx, shy, sy, tx, ty);
                reader.moveUp();
                if (reader.hasMoreChildren()) {
                    reader.moveDown();
                }
            }
            CoordinateReferenceSystem crs = null;
            if ("crs".equals(reader.getNodeName())) {
                crs = (CoordinateReferenceSystem)context.convertAnother(null, CoordinateReferenceSystem.class, (Converter)new SingleValueConverterWrapper((SingleValueConverter)new SRSConverter()));
                reader.moveUp();
            }
            GeneralGridEnvelope gridRange = new GeneralGridEnvelope(low, high);
            GridGeometry2D gg = new GridGeometry2D((GridEnvelope)gridRange, gridToCRS, crs);
            return this.serializationMethodInvoker.callReadResolve((Object)gg);
        }

        int[] toIntArray(String s) {
            String[] split = s.split(" ");
            int[] ints = new int[split.length];
            for (int i = 0; i < split.length; ++i) {
                ints[i] = Integer.parseInt(split[i]);
            }
            return ints;
        }
    }

    public static class CRSConverter
    extends AbstractSingleValueConverter {
        public boolean canConvert(Class type) {
            return CoordinateReferenceSystem.class.isAssignableFrom(type);
        }

        public String toString(Object obj) {
            return ((Formattable)obj).toWKT(2, false);
        }

        public Object fromString(String str) {
            try {
                return CRS.parseWKT((String)str);
            }
            catch (Exception e) {
                try {
                    return new SRSConverter().fromString(str);
                }
                catch (Exception exception) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class SRSConverter
    extends AbstractSingleValueConverter {
        public boolean canConvert(Class type) {
            return CoordinateReferenceSystem.class.isAssignableFrom(type);
        }

        public String toString(Object obj) {
            CoordinateReferenceSystem crs = (CoordinateReferenceSystem)obj;
            try {
                Integer epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
                if (epsg != null) {
                    return "EPSG:" + epsg;
                }
            }
            catch (FactoryException e) {
                LOGGER.warning("Could not determine epsg code of crs, encoding as WKT");
            }
            return new CRSConverter().toString(crs);
        }

        public Object fromString(String str) {
            if (str.toUpperCase().startsWith("EPSG:")) {
                try {
                    return CRS.decode((String)str);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error decode epsg code: " + str, e);
                }
            } else {
                try {
                    return CRS.parseWKT((String)str);
                }
                catch (FactoryException e) {
                    LOGGER.log(Level.WARNING, "Error decode wkt: " + str, e);
                }
            }
            return null;
        }
    }

    class ProxyCollectionConverter
    extends CollectionConverter {
        public ProxyCollectionConverter(Mapper mapper) {
            super(mapper);
        }

        protected void writeItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
            super.writeItem(XStreamPersister.unwrapProxies(item), context, writer);
        }
    }

    class ReferenceCollectionConverter
    extends LaxCollectionConverter {
        Class clazz;

        public ReferenceCollectionConverter(Class clazz) {
            super(XStreamPersister.this.getXStream().getMapper());
            this.clazz = clazz;
        }

        protected void writeItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
            ClassAliasingMapper cam = (ClassAliasingMapper)this.mapper().lookupMapperOfType(ClassAliasingMapper.class);
            String elementName = cam.serializedClass(this.clazz);
            if (elementName == null) {
                elementName = cam.serializedClass(item.getClass());
            }
            writer.startNode(elementName);
            if (item != null) {
                context.convertAnother(item, (Converter)new ReferenceConverter(this.clazz));
            }
            writer.endNode();
        }

        protected Object readItem(HierarchicalStreamReader reader, UnmarshallingContext context, Object current) {
            return context.convertAnother(current, this.clazz, (Converter)new ReferenceConverter(this.clazz));
        }
    }

    class ReferenceConverter
    implements Converter {
        Class clazz;

        public ReferenceConverter(Class clazz) {
            this.clazz = clazz;
        }

        public boolean canConvert(Class type) {
            return this.clazz.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            String id = (String)OwsUtils.get((Object)(source = CatalogImpl.unwrap(source)), (String)"id");
            if (id != null && !XStreamPersister.this.referenceByName) {
                writer.startNode("id");
                writer.setValue(id);
                writer.endNode();
                XStreamPersister.this.callback.postEncodeReference(source, id, null, writer, context);
            } else {
                WorkspaceInfo workspace;
                String name = (String)OwsUtils.get((Object)source, (String)"name");
                String wsName = null;
                if (OwsUtils.has((Object)source, (String)"workspace") && (workspace = (WorkspaceInfo)OwsUtils.get((Object)source, (String)"workspace")) != null) {
                    wsName = workspace.getName();
                }
                if (name != null) {
                    writer.startNode("name");
                    writer.setValue(name);
                    writer.endNode();
                    XStreamPersister.this.callback.postEncodeReference(source, name, wsName, writer, context);
                } else {
                    throw new IllegalArgumentException("Unable to marshal reference with no id or name.");
                }
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Object proxy;
            String ref = null;
            String pre = null;
            if (reader.hasMoreChildren()) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    if ("workspace".equals(reader.getNodeName())) {
                        if (reader.hasMoreChildren()) {
                            reader.moveDown();
                            pre = reader.getValue();
                            reader.moveUp();
                        } else {
                            pre = reader.getValue();
                        }
                    } else {
                        ref = reader.getValue();
                    }
                    reader.moveUp();
                }
            } else {
                ref = reader.getValue();
            }
            Object resolved = proxy = ResolvingProxy.create(ref, pre, this.clazz);
            if (XStreamPersister.this.catalog != null) {
                resolved = ResolvingProxy.resolve(XStreamPersister.this.catalog, proxy);
            }
            return CatalogImpl.unwrap(resolved);
        }
    }

    class MetadataMapConverter
    extends BreifMapConverter {
        MetadataMapConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return MetadataMap.class.equals((Object)type) || super.canConvert(type);
        }

        @Override
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            if (source instanceof MetadataMap) {
                MetadataMap mdmap = (MetadataMap)source;
                source = mdmap.getMap();
            }
            super.marshal(source, writer, context);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Map map = (Map)super.unmarshal(reader, context);
            if (!(map instanceof MetadataMap)) {
                map = new MetadataMap(map);
            }
            return map;
        }
    }

    protected class BreifMapConverter
    extends MapConverter {
        static final String ENCRYPTED_FIELDS_KEY = "org.geoserver.config.encryptedFields";

        public BreifMapConverter() {
            super(XStreamPersister.this.getXStream().getMapper());
        }

        public boolean canConvert(Class type) {
            return Map.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Set encryptionFields = (Set)context.get((Object)ENCRYPTED_FIELDS_KEY);
            if (encryptionFields == null) {
                encryptionFields = Collections.emptySet();
            }
            GeoServerSecurityManager secMgr = XStreamPersister.this.getSecurityManager();
            Map map = (Map)source;
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                writer.startNode("entry");
                writer.addAttribute("key", entry.getKey().toString());
                if (entry.getValue() != null) {
                    Object value = entry.getValue();
                    String complexTypeId = this.getComplexTypeId(value.getClass());
                    if (complexTypeId == null) {
                        String str = (String)Converters.convert(value, String.class);
                        if (str == null) {
                            str = value.toString();
                        }
                        if (encryptionFields.contains(entry.getKey()) && secMgr != null) {
                            str = secMgr.getConfigPasswordEncryptionHelper().encode(str);
                        }
                        writer.setValue(str);
                    } else {
                        writer.startNode(complexTypeId);
                        context.convertAnother(value);
                        writer.endNode();
                    }
                }
                writer.endNode();
            }
        }

        protected void populateMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map) {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String key = reader.getNodeName();
                Object value = null;
                if ("entry".equals(key)) {
                    if (reader.getAttribute("key") != null) {
                        key = reader.getAttribute("key");
                        if (reader.hasMoreChildren()) {
                            reader.moveDown();
                            String typeId = reader.getNodeName();
                            value = context.convertAnother(null, this.getComplexTypeClass(typeId));
                            reader.moveUp();
                        } else {
                            value = reader.getValue();
                        }
                    } else if (reader.hasMoreChildren()) {
                        reader.moveDown();
                        key = reader.getValue();
                        reader.moveUp();
                        reader.moveDown();
                        value = reader.getValue();
                        reader.moveUp();
                    }
                } else {
                    boolean old = false;
                    if (reader.hasMoreChildren()) {
                        old = true;
                        reader.moveDown();
                    }
                    value = this.readItem(reader, context, map);
                    if (old) {
                        reader.moveUp();
                    }
                }
                map.put(key, value);
                reader.moveUp();
            }
        }

        protected Object readItem(HierarchicalStreamReader reader, UnmarshallingContext context, Object current) {
            return reader.getValue();
        }

        private Class getComplexTypeClass(String typeId) {
            return XStreamPersister.this.forwardBreifMap.get(typeId);
        }

        private String getComplexTypeId(Class clazz) {
            String typeId = XStreamPersister.this.backwardBreifMap.get(clazz);
            if (typeId == null) {
                ArrayList<Class> matches = new ArrayList<Class>();
                this.collectSuperclasses(clazz, matches);
                Iterator it = matches.iterator();
                while (it.hasNext()) {
                    Class sper = (Class)it.next();
                    if (XStreamPersister.this.backwardBreifMap.get(sper) != null) continue;
                    it.remove();
                }
                if (matches.size() > 1) {
                    Comparator<Class> comparator = new Comparator<Class>(){

                        @Override
                        public int compare(Class c1, Class c2) {
                            if (c2.isAssignableFrom(c1)) {
                                return -1;
                            }
                            return 1;
                        }
                    };
                    Collections.sort(matches, comparator);
                }
                if (matches.size() > 0) {
                    typeId = XStreamPersister.this.backwardBreifMap.get(matches.get(0));
                }
            }
            return typeId;
        }

        void collectSuperclasses(Class clazz, List<Class> matches) {
            matches.add(clazz);
            if (clazz.getSuperclass() == null && clazz.getInterfaces().length == 0) {
                return;
            }
            if (clazz.getSuperclass() != null) {
                this.collectSuperclasses(clazz.getSuperclass(), matches);
            }
            for (Class<?> iface : clazz.getInterfaces()) {
                this.collectSuperclasses(iface, matches);
            }
        }
    }

    class CustomReflectionProvider
    extends Sun14ReflectionProvider {
        public CustomReflectionProvider(FieldDictionary fd) {
            super(fd);
        }

        public void visitSerializableFields(Object object, ReflectionProvider.Visitor visitor) {
            super.visitSerializableFields(object, (ReflectionProvider.Visitor)new VisitorWrapper(visitor));
        }

        class VisitorWrapper
        implements ReflectionProvider.Visitor {
            ReflectionProvider.Visitor wrapped;

            public VisitorWrapper(ReflectionProvider.Visitor wrapped) {
                this.wrapped = wrapped;
            }

            public void visit(String name, Class type, Class definedIn, Object value) {
                if (value instanceof Collection && ((Collection)value).isEmpty()) {
                    return;
                }
                if (value instanceof Map && ((Map)value).isEmpty()) {
                    return;
                }
                value = XStreamPersister.unwrapProxies(value);
                this.wrapped.visit(name, type, definedIn, value);
            }
        }
    }

    public static class Callback {
        protected void postEncodeWorkspace(WorkspaceInfo ws, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        protected void postEncodeNamespace(NamespaceInfo ns, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        protected void postEncodeDataStore(DataStoreInfo ds, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        protected void postEncodeCoverageStore(CoverageStoreInfo ds, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        protected void postEncodeFeatureType(FeatureTypeInfo ds, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        protected void postEncodeWMSLayer(WMSLayerInfo ds, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        protected void postEncodeCoverage(CoverageInfo ds, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        protected void postEncodeLayer(LayerInfo ls, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        protected void postEncodeLayerGroup(LayerGroupInfo ls, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        protected void postEncodeReference(Object obj, String ref, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
            if (prefix == null) {
                this.postEncodeReference(obj, ref, writer, context);
            }
        }

        protected void postEncodeWMSStore(WMSStoreInfo store, HierarchicalStreamWriter writer, MarshallingContext context) {
        }
    }
}

