/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.util.LegacyCatalogImporter;
import org.geoserver.config.DefaultGeoServerLoader;
import org.geoserver.config.GeoServer;
import org.geoserver.config.util.LegacyConfigurationImporter;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.platform.GeoServerResourceLoader;

public class LegacyGeoServerLoader
extends DefaultGeoServerLoader {
    public LegacyGeoServerLoader(GeoServerResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    @Override
    protected void readCatalog(Catalog catalog, XStreamPersister xp) throws Exception {
        catalog.setResourceLoader(this.resourceLoader);
        File f = this.resourceLoader.find("catalog.xml");
        if (f != null) {
            LegacyCatalogImporter catalogImporter = new LegacyCatalogImporter();
            catalogImporter.setResourceLoader(this.resourceLoader);
            catalogImporter.setCatalog(catalog);
            catalogImporter.imprt(this.resourceLoader.getBaseDirectory());
        } else {
            LOGGER.warning("No catalog file found.");
        }
    }

    @Override
    protected void readConfiguration(GeoServer geoServer, XStreamPersister xp) throws Exception {
        File f = this.resourceLoader.find("services.xml");
        if (f != null) {
            LegacyConfigurationImporter importer = new LegacyConfigurationImporter();
            importer.setConfiguration(geoServer);
            importer.imprt(this.resourceLoader.getBaseDirectory());
        } else {
            LOGGER.warning("No configuration file found.");
        }
    }
}

