/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.data.util.IOUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.data.DataUtilities;
import org.geotools.styling.AbstractStyleVisitor;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.logging.Logging;

public class GeoServerPersister
implements CatalogListener,
ConfigurationListener {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.config");
    GeoServerResourceLoader rl;
    GeoServerDataDirectory dd;
    XStreamPersister xp;

    public GeoServerPersister(GeoServerResourceLoader rl, XStreamPersister xp) {
        this.rl = rl;
        this.dd = new GeoServerDataDirectory(rl);
        this.xp = xp;
    }

    @Override
    public void handleAddEvent(CatalogAddEvent event) {
        CatalogInfo source = event.getSource();
        try {
            if (source instanceof WorkspaceInfo) {
                this.addWorkspace((WorkspaceInfo)source);
            } else if (source instanceof NamespaceInfo) {
                this.addNamespace((NamespaceInfo)source);
            } else if (source instanceof DataStoreInfo) {
                this.addDataStore((DataStoreInfo)source);
            } else if (source instanceof WMSStoreInfo) {
                this.addWMSStore((WMSStoreInfo)source);
            } else if (source instanceof FeatureTypeInfo) {
                this.addFeatureType((FeatureTypeInfo)source);
            } else if (source instanceof CoverageStoreInfo) {
                this.addCoverageStore((CoverageStoreInfo)source);
            } else if (source instanceof CoverageInfo) {
                this.addCoverage((CoverageInfo)source);
            } else if (source instanceof WMSLayerInfo) {
                this.addWMSLayer((WMSLayerInfo)source);
            } else if (source instanceof LayerInfo) {
                this.addLayer((LayerInfo)source);
            } else if (source instanceof StyleInfo) {
                this.addStyle((StyleInfo)source);
            } else if (source instanceof LayerGroupInfo) {
                this.addLayerGroup((LayerGroupInfo)source);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleModifyEvent(CatalogModifyEvent event) {
        CatalogInfo source = event.getSource();
        try {
            WorkspaceInfo defWorkspace;
            File oldDir;
            WorkspaceInfo newWorkspace;
            int i = event.getPropertyNames().indexOf("name");
            if (i > -1) {
                String newName = (String)event.getNewValues().get(i);
                if (source instanceof WorkspaceInfo) {
                    this.renameWorkspace((WorkspaceInfo)source, newName);
                } else if (source instanceof StoreInfo) {
                    this.renameStore((StoreInfo)source, newName);
                } else if (source instanceof ResourceInfo) {
                    this.renameResource((ResourceInfo)source, newName);
                } else if (source instanceof StyleInfo) {
                    this.renameStyle((StyleInfo)source, newName);
                } else if (source instanceof LayerGroupInfo) {
                    this.renameLayerGroup((LayerGroupInfo)source, newName);
                }
            }
            if (source instanceof StoreInfo && (i = event.getPropertyNames().indexOf("workspace")) > -1) {
                newWorkspace = (WorkspaceInfo)event.getNewValues().get(i);
                oldDir = this.dir((StoreInfo)source);
                oldDir.renameTo(new File(this.dir(newWorkspace), oldDir.getName()));
            }
            if (source instanceof FeatureTypeInfo && (i = event.getPropertyNames().indexOf("store")) > -1) {
                StoreInfo newStore = (StoreInfo)event.getNewValues().get(i);
                oldDir = this.dir((FeatureTypeInfo)source);
                oldDir.renameTo(new File(this.dir(newStore), oldDir.getName()));
            }
            if (source instanceof StyleInfo && (i = event.getPropertyNames().indexOf("workspace")) > -1) {
                newWorkspace = (WorkspaceInfo)event.getNewValues().get(i);
                File newDir = this.dd.styleDir(true, newWorkspace);
                for (File oldFile : this.resources((StyleInfo)source)) {
                    FileUtils.copyFile((File)oldFile, (File)new File(newDir, oldFile.getName()));
                }
                for (File oldFile : this.files((StyleInfo)source)) {
                    oldFile.renameTo(new File(newDir, oldFile.getName()));
                }
            }
            if (source instanceof LayerGroupInfo && (i = event.getPropertyNames().indexOf("workspace")) > -1) {
                newWorkspace = (WorkspaceInfo)event.getNewValues().get(i);
                File oldFile = this.file((LayerGroupInfo)source);
                oldFile.renameTo(new File(this.dd.layerGroupDir(true, newWorkspace), oldFile.getName()));
            }
            if (source instanceof Catalog && (i = event.getPropertyNames().indexOf("defaultWorkspace")) > -1 && (defWorkspace = (WorkspaceInfo)event.getNewValues().get(i)) != null) {
                File d = this.rl.createDirectory("workspaces");
                this.persist(defWorkspace, new File(d, "default.xml"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handlePostModifyEvent(CatalogPostModifyEvent event) {
        CatalogInfo source = event.getSource();
        try {
            if (source instanceof WorkspaceInfo) {
                this.modifyWorkspace((WorkspaceInfo)source);
            } else if (source instanceof DataStoreInfo) {
                this.modifyDataStore((DataStoreInfo)source);
            } else if (source instanceof WMSStoreInfo) {
                this.modifyWMSStore((WMSStoreInfo)source);
            } else if (source instanceof NamespaceInfo) {
                this.modifyNamespace((NamespaceInfo)source);
            } else if (source instanceof FeatureTypeInfo) {
                this.modifyFeatureType((FeatureTypeInfo)source);
            } else if (source instanceof CoverageStoreInfo) {
                this.modifyCoverageStore((CoverageStoreInfo)source);
            } else if (source instanceof CoverageInfo) {
                this.modifyCoverage((CoverageInfo)source);
            } else if (source instanceof WMSLayerInfo) {
                this.modifyWMSLayer((WMSLayerInfo)source);
            } else if (source instanceof LayerInfo) {
                this.modifyLayer((LayerInfo)source);
            } else if (source instanceof StyleInfo) {
                this.modifyStyle((StyleInfo)source);
            } else if (source instanceof LayerGroupInfo) {
                this.modifyLayerGroup((LayerGroupInfo)source);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleRemoveEvent(CatalogRemoveEvent event) {
        CatalogInfo source = event.getSource();
        try {
            if (source instanceof WorkspaceInfo) {
                this.removeWorkspace((WorkspaceInfo)source);
            } else if (source instanceof NamespaceInfo) {
                this.removeNamespace((NamespaceInfo)source);
            } else if (source instanceof DataStoreInfo) {
                this.removeDataStore((DataStoreInfo)source);
            } else if (source instanceof FeatureTypeInfo) {
                this.removeFeatureType((FeatureTypeInfo)source);
            } else if (source instanceof CoverageStoreInfo) {
                this.removeCoverageStore((CoverageStoreInfo)source);
            } else if (source instanceof CoverageInfo) {
                this.removeCoverage((CoverageInfo)source);
            } else if (source instanceof WMSStoreInfo) {
                this.removeWMSStore((WMSStoreInfo)source);
            } else if (source instanceof WMSLayerInfo) {
                this.removeWMSLayer((WMSLayerInfo)source);
            } else if (source instanceof LayerInfo) {
                this.removeLayer((LayerInfo)source);
            } else if (source instanceof StyleInfo) {
                this.removeStyle((StyleInfo)source);
            } else if (source instanceof LayerGroupInfo) {
                this.removeLayerGroup((LayerGroupInfo)source);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
    }

    @Override
    public void handlePostGlobalChange(GeoServerInfo global) {
        try {
            this.persist(global, new File(this.rl.getBaseDirectory(), "global.xml"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleSettingsAdded(SettingsInfo settings) {
        this.handleSettingsPostModified(settings);
    }

    @Override
    public void handleSettingsModified(SettingsInfo settings, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
        int i = propertyNames.indexOf("workspace");
        if (i > -1) {
            WorkspaceInfo newWorkspace = (WorkspaceInfo)newValues.get(i);
            LOGGER.fine("Moving settings '" + settings + " to workspace: " + newWorkspace);
            try {
                File oldFile = this.file(settings);
                oldFile.renameTo(new File(this.dir(newWorkspace), oldFile.getName()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void handleSettingsPostModified(SettingsInfo settings) {
        LOGGER.fine("Persisting settings " + settings);
        try {
            this.persist(settings, this.file(settings));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleSettingsRemoved(SettingsInfo settings) {
        LOGGER.fine("Removing settings " + settings);
        try {
            this.file(settings).delete();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleLoggingChange(LoggingInfo logging, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
    }

    @Override
    public void handlePostLoggingChange(LoggingInfo logging) {
        try {
            this.persist(logging, new File(this.rl.getBaseDirectory(), "logging.xml"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void handleServiceAdded(ServiceInfo service) {
    }

    @Override
    public void handleServiceChange(ServiceInfo service, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
    }

    @Override
    public void handlePostServiceChange(ServiceInfo service) {
    }

    @Override
    public void handleServiceRemove(ServiceInfo service) {
    }

    @Override
    public void reloaded() {
    }

    void addWorkspace(WorkspaceInfo ws) throws IOException {
        LOGGER.fine("Persisting workspace " + ws.getName());
        File dir = this.dir(ws, true);
        dir.mkdirs();
        this.persist(ws, this.file(ws));
    }

    void renameWorkspace(WorkspaceInfo ws, String newName) throws IOException {
        LOGGER.fine("Renaming workspace " + ws.getName() + "to " + newName);
        IOUtils.rename(this.dir(ws), newName);
    }

    void modifyWorkspace(WorkspaceInfo ws) throws IOException {
        LOGGER.fine("Persisting workspace " + ws.getName());
        this.persist(ws, this.file(ws));
    }

    void removeWorkspace(WorkspaceInfo ws) throws IOException {
        LOGGER.fine("Removing workspace " + ws.getName());
        File dir = this.dir(ws);
        FileUtils.deleteDirectory((File)dir);
    }

    File dir(WorkspaceInfo ws) throws IOException {
        return this.dir(ws, false);
    }

    File dir(WorkspaceInfo ws, boolean create) throws IOException {
        File d = this.rl.find(new String[]{"workspaces", ws.getName()});
        if (d == null && create) {
            d = this.rl.createDirectory(new String[]{"workspaces", ws.getName()});
        }
        return d;
    }

    File file(WorkspaceInfo ws) throws IOException {
        return new File(this.dir(ws), "workspace.xml");
    }

    void addNamespace(NamespaceInfo ns) throws IOException {
        LOGGER.fine("Persisting namespace " + ns.getPrefix());
        File dir = this.dir(ns, true);
        dir.mkdirs();
        this.persist(ns, this.file(ns));
    }

    void modifyNamespace(NamespaceInfo ns) throws IOException {
        LOGGER.fine("Persisting namespace " + ns.getPrefix());
        this.persist(ns, this.file(ns));
    }

    void removeNamespace(NamespaceInfo ns) throws IOException {
        LOGGER.fine("Removing namespace " + ns.getPrefix());
        this.file(ns).delete();
    }

    File dir(NamespaceInfo ns) throws IOException {
        return this.dir(ns, false);
    }

    File dir(NamespaceInfo ns, boolean create) throws IOException {
        File d = this.rl.find(new String[]{"workspaces", ns.getPrefix()});
        if (d == null && create) {
            d = this.rl.createDirectory(new String[]{"workspaces", ns.getPrefix()});
        }
        return d;
    }

    File file(NamespaceInfo ns) throws IOException {
        return new File(this.dir(ns), "namespace.xml");
    }

    void addDataStore(DataStoreInfo ds) throws IOException {
        LOGGER.fine("Persisting datastore " + ds.getName());
        File dir = this.dir(ds);
        dir.mkdir();
        this.persist(ds, this.file(ds));
    }

    void renameStore(StoreInfo s, String newName) throws IOException {
        LOGGER.fine("Renaming store " + s.getName() + "to " + newName);
        IOUtils.rename(this.dir(s), newName);
    }

    void modifyDataStore(DataStoreInfo ds) throws IOException {
        LOGGER.fine("Persisting datastore " + ds.getName());
        this.persist(ds, this.file(ds));
    }

    void removeDataStore(DataStoreInfo ds) throws IOException {
        LOGGER.fine("Removing datastore " + ds.getName());
        File dir = this.dir(ds);
        FileUtils.deleteDirectory((File)dir);
    }

    File dir(StoreInfo s) throws IOException {
        return new File(this.dir(s.getWorkspace()), s.getName());
    }

    File file(DataStoreInfo ds) throws IOException {
        return new File(this.dir(ds), "datastore.xml");
    }

    void addFeatureType(FeatureTypeInfo ft) throws IOException {
        LOGGER.fine("Persisting feature type " + ft.getName());
        File dir = this.dir(ft);
        dir.mkdir();
        this.persist(ft, this.file(ft));
    }

    void renameResource(ResourceInfo r, String newName) throws IOException {
        LOGGER.fine("Renaming resource " + r.getName() + " to " + newName);
        IOUtils.rename(this.dir(r), newName);
    }

    void modifyFeatureType(FeatureTypeInfo ft) throws IOException {
        LOGGER.fine("Persisting feature type " + ft.getName());
        this.persist(ft, this.file(ft));
    }

    void removeFeatureType(FeatureTypeInfo ft) throws IOException {
        LOGGER.fine("Removing feature type " + ft.getName());
        File dir = this.dir(ft);
        FileUtils.deleteDirectory((File)dir);
    }

    File dir(ResourceInfo r) throws IOException {
        return new File(this.dir(r.getStore()), r.getName());
    }

    File file(FeatureTypeInfo ft) throws IOException {
        return new File(this.dir(ft), "featuretype.xml");
    }

    void addCoverageStore(CoverageStoreInfo cs) throws IOException {
        LOGGER.fine("Persisting coverage store " + cs.getName());
        File dir = this.dir(cs);
        dir.mkdir();
        this.persist(cs, this.file(cs));
    }

    void modifyCoverageStore(CoverageStoreInfo cs) throws IOException {
        LOGGER.fine("Persisting coverage store " + cs.getName());
        this.persist(cs, this.file(cs));
    }

    void removeCoverageStore(CoverageStoreInfo cs) throws IOException {
        LOGGER.fine("Removing coverage store " + cs.getName());
        File dir = this.dir(cs);
        FileUtils.deleteDirectory((File)dir);
    }

    File file(CoverageStoreInfo cs) throws IOException {
        return new File(this.dir(cs), "coveragestore.xml");
    }

    void addCoverage(CoverageInfo c) throws IOException {
        LOGGER.fine("Persisting coverage " + c.getName());
        File dir = this.dir(c);
        dir.mkdir();
        this.persist(c, dir, "coverage.xml");
    }

    void modifyCoverage(CoverageInfo c) throws IOException {
        LOGGER.fine("Persisting coverage " + c.getName());
        File dir = this.dir(c);
        this.persist(c, dir, "coverage.xml");
    }

    void removeCoverage(CoverageInfo c) throws IOException {
        LOGGER.fine("Removing coverage " + c.getName());
        File dir = this.dir(c);
        FileUtils.deleteDirectory((File)dir);
    }

    void addWMSStore(WMSStoreInfo wms) throws IOException {
        LOGGER.fine("Persisting wms store " + wms.getName());
        File dir = this.dir(wms);
        dir.mkdir();
        this.persist(wms, this.file(wms));
    }

    void modifyWMSStore(WMSStoreInfo ds) throws IOException {
        LOGGER.fine("Persisting wms store " + ds.getName());
        this.persist(ds, this.file(ds));
    }

    void removeWMSStore(WMSStoreInfo ds) throws IOException {
        LOGGER.fine("Removing datastore " + ds.getName());
        File dir = this.dir(ds);
        FileUtils.deleteDirectory((File)dir);
    }

    File file(WMSStoreInfo ds) throws IOException {
        return new File(this.dir(ds), "wmsstore.xml");
    }

    void addWMSLayer(WMSLayerInfo wms) throws IOException {
        LOGGER.fine("Persisting wms layer " + wms.getName());
        File dir = this.dir(wms);
        dir.mkdir();
        this.persist(wms, dir, "wmslayer.xml");
    }

    void modifyWMSLayer(WMSLayerInfo wms) throws IOException {
        LOGGER.fine("Persisting wms layer" + wms.getName());
        File dir = this.dir(wms);
        this.persist(wms, dir, "wmslayer.xml");
    }

    void removeWMSLayer(WMSLayerInfo c) throws IOException {
        LOGGER.fine("Removing wms layer " + c.getName());
        File dir = this.dir(c);
        FileUtils.deleteDirectory((File)dir);
    }

    void addLayer(LayerInfo l) throws IOException {
        LOGGER.fine("Persisting layer " + l.getName());
        File dir = this.dir(l);
        dir.mkdir();
        this.persist(l, this.file(l));
    }

    void modifyLayer(LayerInfo l) throws IOException {
        LOGGER.fine("Persisting layer " + l.getName());
        this.persist(l, this.file(l));
    }

    void removeLayer(LayerInfo l) throws IOException {
        LOGGER.fine("Removing layer " + l.getName());
        File dir = this.dir(l);
        FileUtils.deleteDirectory((File)dir);
    }

    File dir(LayerInfo l) throws IOException {
        if (l.getResource() instanceof FeatureTypeInfo) {
            return this.dir((FeatureTypeInfo)l.getResource());
        }
        if (l.getResource() instanceof CoverageInfo) {
            return this.dir((CoverageInfo)l.getResource());
        }
        if (l.getResource() instanceof WMSLayerInfo) {
            return this.dir((WMSLayerInfo)l.getResource());
        }
        return null;
    }

    File file(LayerInfo l) throws IOException {
        return new File(this.dir(l), "layer.xml");
    }

    void addStyle(StyleInfo s) throws IOException {
        LOGGER.fine("Persisting style " + s.getName());
        this.dir(s, true);
        this.persist(s, this.file(s));
    }

    void renameStyle(StyleInfo s, String newName) throws IOException {
        LOGGER.fine("Renameing style " + s.getName() + " to " + newName);
        IOUtils.rename(this.file(s), newName + ".xml");
    }

    void modifyStyle(StyleInfo s) throws IOException {
        LOGGER.fine("Persisting style " + s.getName());
        this.persist(s, this.file(s));
    }

    void removeStyle(StyleInfo s) throws IOException {
        LOGGER.fine("Removing style " + s.getName());
        this.file(s).delete();
    }

    File dir(StyleInfo s) throws IOException {
        return this.dir(s, false);
    }

    File dir(StyleInfo s, boolean create) throws IOException {
        return this.dd.styleDir(create, s);
    }

    File file(StyleInfo s) throws IOException {
        if (s.getFilename() != null && s.getFilename().endsWith(".xml") && s.getFilename().startsWith(s.getName() + ".")) {
            return new File(this.dir(s), s.getName() + ".xml.xml");
        }
        return new File(this.dir(s), s.getName() + ".xml");
    }

    List<File> files(StyleInfo s) throws IOException {
        File f = this.file(s);
        ArrayList<File> list2 = new ArrayList<File>(Arrays.asList(f, new File(f.getParentFile(), s.getFilename())));
        return list2;
    }

    List<File> resources(StyleInfo s) throws IOException {
        final ArrayList<File> files = new ArrayList<File>();
        try {
            s.getStyle().accept((StyleVisitor)new AbstractStyleVisitor(){

                public void visit(ExternalGraphic exgr) {
                    if (exgr.getOnlineResource() == null) {
                        return;
                    }
                    URI uri = exgr.getOnlineResource().getLinkage();
                    if (uri == null) {
                        return;
                    }
                    File f = null;
                    try {
                        f = DataUtilities.urlToFile((URL)uri.toURL());
                    }
                    catch (MalformedURLException e) {
                        LOGGER.log(Level.WARNING, "Error attemping to processing SLD resource", e);
                    }
                    if (f != null && f.exists()) {
                        files.add(f);
                    }
                }
            });
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error loading style", e);
        }
        return files;
    }

    void addLayerGroup(LayerGroupInfo lg) throws IOException {
        LOGGER.fine("Persisting layer group " + lg.getName());
        this.dir(lg, true);
        this.persist(lg, this.file(lg));
    }

    void renameLayerGroup(LayerGroupInfo lg, String newName) throws IOException {
        LOGGER.fine("Renaming layer group " + lg.getName() + " to " + newName);
        IOUtils.rename(this.file(lg), newName + ".xml");
    }

    void modifyLayerGroup(LayerGroupInfo lg) throws IOException {
        LOGGER.fine("Persisting layer group " + lg.getName());
        this.persist(lg, this.file(lg));
    }

    void removeLayerGroup(LayerGroupInfo lg) throws IOException {
        LOGGER.fine("Removing layer group " + lg.getName());
        this.file(lg).delete();
    }

    File dir(LayerGroupInfo lg) throws IOException {
        return this.dir(lg, false);
    }

    File dir(LayerGroupInfo lg, boolean create) throws IOException {
        return this.dd.layerGroupDir(create, lg);
    }

    File file(LayerGroupInfo lg) throws IOException {
        return new File(this.dir(lg), lg.getName() + ".xml");
    }

    File file(SettingsInfo settings) throws IOException {
        File dir = settings.getWorkspace() != null ? this.dir(settings.getWorkspace()) : this.rl.getBaseDirectory();
        return new File(dir, "settings.xml");
    }

    void persist(Object o, File dir, String filename) throws IOException {
        this.persist(o, new File(dir, filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persist(Object o, File f) throws IOException {
        try {
            XStreamPersister xStreamPersister = this.xp;
            synchronized (xStreamPersister) {
                IOUtils.xStreamPersist(f, o, this.xp);
            }
            LOGGER.fine("Persisted " + o.getClass().getName() + " to " + f.getAbsolutePath());
        }
        catch (Exception e) {
            String msg = "Error persisting " + o + " to " + f.getCanonicalPath();
            throw new CatalogException(msg, e);
        }
    }
}

