/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.util.logging.Logging;

public class ReaderDimensionsAccessor {
    private static final Logger LOGGER = Logging.getLogger(ReaderDimensionsAccessor.class);
    private static final String UTC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private AbstractGridCoverage2DReader reader;

    public ReaderDimensionsAccessor(AbstractGridCoverage2DReader reader) {
        this.reader = reader;
    }

    public boolean hasTime() {
        return "true".equalsIgnoreCase(this.reader.getMetadataValue("HAS_TIME_DOMAIN"));
    }

    public TreeSet<Date> getTimeDomain() {
        SimpleDateFormat df = this.getTimeFormat();
        String domain = this.reader.getMetadataValue("TIME_DOMAIN");
        String[] timeInstants = domain.split("\\s*,\\s*");
        TreeSet<Date> values = new TreeSet<Date>();
        for (String tp : timeInstants) {
            try {
                values.add(df.parse(tp));
            }
            catch (ParseException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return values;
    }

    public Date getMaxTime() {
        String currentTime = this.reader.getMetadataValue("TIME_DOMAIN_MAXIMUM");
        if (currentTime == null) {
            return null;
        }
        try {
            return this.getTimeFormat().parse(currentTime);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to get CURRENT time from coverage reader", e);
        }
    }

    public Date getMinTime() {
        String currentTime = this.reader.getMetadataValue("TIME_DOMAIN_MINIMUM");
        if (currentTime == null) {
            return null;
        }
        try {
            return this.getTimeFormat().parse(currentTime);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to get minimum time from coverage reader", e);
        }
    }

    public SimpleDateFormat getTimeFormat() {
        SimpleDateFormat df = new SimpleDateFormat(UTC_PATTERN);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df;
    }

    public boolean hasElevation() {
        return "true".equalsIgnoreCase(this.reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
    }

    public TreeSet<Double> getElevationDomain() {
        String[] elevationValues = this.reader.getMetadataValue("ELEVATION_DOMAIN").split(",");
        TreeSet<Double> elevations = new TreeSet<Double>();
        for (String val : elevationValues) {
            try {
                elevations.add(Double.parseDouble(val));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return elevations;
    }

    public Double getMaxElevation() {
        String elevation = this.reader.getMetadataValue("ELEVATION_DOMAIN_MAXIMUM");
        if (elevation == null) {
            return null;
        }
        try {
            return Double.parseDouble(elevation);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to get maximum elevation from coverage reader", e);
        }
    }

    public Double getMinElevation() {
        String elevation = this.reader.getMetadataValue("ELEVATION_DOMAIN_MINIMUM");
        if (elevation == null) {
            return null;
        }
        try {
            return Double.parseDouble(elevation);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to get minimum elevation from coverage reader", e);
        }
    }
}

