/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.IOException;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.StoreInfoImpl;
import org.geotools.data.wms.WebMapServer;
import org.opengis.util.ProgressListener;

public class WMSStoreInfoImpl
extends StoreInfoImpl
implements WMSStoreInfo {
    public static final int DEFAULT_MAX_CONNECTIONS = 6;
    public static final int DEFAULT_CONNECT_TIMEOUT = 30;
    public static final int DEFAULT_READ_TIMEOUT = 60;
    String capabilitiesURL;
    private String user;
    private String password;
    private int maxConnections;
    private int readTimeout;
    private int connectTimeout;

    protected WMSStoreInfoImpl() {
    }

    public WMSStoreInfoImpl(CatalogImpl catalog) {
        super(catalog);
    }

    @Override
    public String getCapabilitiesURL() {
        return this.capabilitiesURL;
    }

    @Override
    public void setCapabilitiesURL(String capabilitiesURL) {
        this.capabilitiesURL = capabilitiesURL;
    }

    @Override
    public String getUsername() {
        return this.user;
    }

    @Override
    public void setUsername(String user) {
        this.user = user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public void setMaxConnections(int maxConcurrentConnections) {
        this.maxConnections = maxConcurrentConnections;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int timeoutSeconds) {
        this.readTimeout = timeoutSeconds;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int timeoutSeconds) {
        this.connectTimeout = timeoutSeconds;
    }

    @Override
    public void accept(CatalogVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public WebMapServer getWebMapServer(ProgressListener listener) throws IOException {
        return this.getCatalog().getResourcePool().getWebMapServer(this);
    }

    @Override
    public boolean isUseConnectionPooling() {
        Boolean useConnectionPooling = this.getMetadata().get("useConnectionPooling", Boolean.class);
        return useConnectionPooling == null ? Boolean.TRUE : useConnectionPooling;
    }

    @Override
    public void setUseConnectionPooling(boolean useHttpConnectionPooling) {
        this.getMetadata().put("useConnectionPooling", Boolean.valueOf(useHttpConnectionPooling));
    }
}

