/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.unit.Unit;
import javax.media.jai.PlanarImage;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.catalog.impl.StoreInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.data.util.CoverageStoreUtils;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.FeatureSource;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.Layer;
import org.geotools.data.wms.WebMapServer;
import org.geotools.factory.GeoTools;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CatalogBuilder {
    static final Logger LOGGER = Logging.getLogger(CatalogBuilder.class);
    Catalog catalog;
    WorkspaceInfo workspace;
    StoreInfo store;

    public CatalogBuilder(Catalog catalog) {
        this.catalog = catalog;
    }

    public void setWorkspace(WorkspaceInfo workspace) {
        this.workspace = workspace;
    }

    public void setStore(StoreInfo store) {
        this.store = store;
    }

    public void updateWorkspace(WorkspaceInfo original, WorkspaceInfo update) {
        this.update(original, update, WorkspaceInfo.class);
    }

    public void updateNamespace(NamespaceInfo original, NamespaceInfo update) {
        this.update(original, update, NamespaceInfo.class);
    }

    public void updateDataStore(DataStoreInfo original, DataStoreInfo update) {
        this.update(original, update, DataStoreInfo.class);
    }

    public void updateWMSStore(WMSStoreInfo original, WMSStoreInfo update) {
        this.update(original, update, WMSStoreInfo.class);
    }

    public void updateCoverageStore(CoverageStoreInfo original, CoverageStoreInfo update) {
        this.update(original, update, CoverageStoreInfo.class);
    }

    public void updateFeatureType(FeatureTypeInfo original, FeatureTypeInfo update) {
        this.update(original, update, FeatureTypeInfo.class);
    }

    public void updateCoverage(CoverageInfo original, CoverageInfo update) {
        this.update(original, update, CoverageInfo.class);
    }

    public void updateWMSLayer(WMSLayerInfo original, WMSLayerInfo update) {
        this.update(original, update, WMSLayerInfo.class);
    }

    public void updateLayer(LayerInfo original, LayerInfo update) {
        this.update(original, update, LayerInfo.class);
    }

    public void updateLayerGroup(LayerGroupInfo original, LayerGroupInfo update) {
        this.update(original, update, LayerGroupInfo.class);
    }

    public void updateStyle(StyleInfo original, StyleInfo update) {
        this.update(original, update, StyleInfo.class);
    }

    <T> void update(T original, T update, Class<T> clazz) {
        OwsUtils.copy(update, original, clazz);
    }

    public DataStoreInfo buildDataStore(String name) {
        DataStoreInfo info = this.catalog.getFactory().createDataStore();
        this.buildStore(info, name);
        return info;
    }

    public CoverageStoreInfo buildCoverageStore(String name) {
        CoverageStoreInfo info = this.catalog.getFactory().createCoverageStore();
        this.buildStore(info, name);
        return info;
    }

    public WMSStoreInfo buildWMSStore(String name) throws IOException {
        WMSStoreInfo info = this.catalog.getFactory().createWebMapServer();
        this.buildStore(info, name);
        info.setType("WMS");
        info.setMaxConnections(6);
        info.setConnectTimeout(30);
        info.setReadTimeout(60);
        return info;
    }

    void buildStore(StoreInfo info, String name) {
        info.setName(name);
        info.setEnabled(true);
        if (this.workspace != null) {
            info.setWorkspace(this.workspace);
        } else {
            info.setWorkspace(this.catalog.getDefaultWorkspace());
        }
    }

    public FeatureTypeInfo buildFeatureType(Name typeName) throws Exception {
        if (this.store == null || !(this.store instanceof DataStoreInfo)) {
            throw new IllegalStateException("Data store not set.");
        }
        DataStoreInfo dstore = (DataStoreInfo)this.store;
        return this.buildFeatureType(dstore.getDataStore(null).getFeatureSource(typeName));
    }

    public FeatureTypeInfo buildFeatureType(FeatureSource featureSource) {
        if (this.store == null || !(this.store instanceof DataStoreInfo)) {
            throw new IllegalStateException("Data store not set.");
        }
        FeatureType featureType = featureSource.getSchema();
        FeatureTypeInfo ftinfo = this.catalog.getFactory().createFeatureType();
        ftinfo.setStore(this.store);
        ftinfo.setEnabled(true);
        ftinfo.setNativeName(featureType.getName().getLocalPart());
        ftinfo.setName(featureType.getName().getLocalPart());
        WorkspaceInfo workspace = this.store.getWorkspace();
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(workspace.getName());
        if (namespace == null) {
            namespace = this.catalog.getDefaultNamespace();
        }
        ftinfo.setNamespace(namespace);
        CoordinateReferenceSystem crs = featureType.getCoordinateReferenceSystem();
        if (crs == null && featureType.getGeometryDescriptor() != null) {
            crs = featureType.getGeometryDescriptor().getCoordinateReferenceSystem();
        }
        ftinfo.setNativeCRS(crs);
        try {
            this.lookupSRS(ftinfo, false);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "SRS lookup failed", e);
        }
        this.setupProjectionPolicy(ftinfo);
        try {
            this.setupMetadata(ftinfo, featureSource);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Metadata lookup failed", e);
        }
        return ftinfo;
    }

    public void setupProjectionPolicy(ResourceInfo rinfo) {
        if (rinfo.getSRS() != null) {
            rinfo.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        } else {
            rinfo.setProjectionPolicy(ProjectionPolicy.NONE);
        }
    }

    public void setupBounds(FeatureTypeInfo ftinfo, FeatureSource featureSource) throws IOException {
        this.doSetupBounds(ftinfo, featureSource);
    }

    public void setupBounds(CoverageInfo cinfo, AbstractGridCoverage2DReader coverageReader) throws IOException {
        this.doSetupBounds(cinfo, coverageReader);
    }

    public void setupBounds(ResourceInfo rinfo) throws IOException {
        this.doSetupBounds(rinfo, null);
    }

    void doSetupBounds(ResourceInfo rinfo, Object data) throws IOException {
        if (rinfo.getNativeBoundingBox() == null) {
            ReferencedEnvelope bounds = this.getNativeBounds(rinfo, data);
            rinfo.setNativeBoundingBox(bounds);
        }
        rinfo.setLatLonBoundingBox(this.getLatLonBounds(rinfo.getNativeBoundingBox(), rinfo.getCRS()));
    }

    public void setupMetadata(FeatureTypeInfo ftinfo, FeatureSource featureSource) throws IOException {
        org.geotools.data.ResourceInfo rinfo;
        block8: {
            rinfo = null;
            try {
                rinfo = featureSource.getInfo();
            }
            catch (Exception ignore) {
                if (!LOGGER.isLoggable(Level.FINE)) break block8;
                LOGGER.log(Level.FINE, "Unable to get resource info from feature source", ignore);
            }
        }
        if (ftinfo.getTitle() == null) {
            ftinfo.setTitle(rinfo != null ? rinfo.getTitle() : ftinfo.getName());
        }
        if (rinfo != null && ftinfo.getDescription() == null) {
            ftinfo.setDescription(rinfo.getDescription());
        }
        if (rinfo != null && (ftinfo.getKeywords() == null || ftinfo.getKeywords().isEmpty()) && rinfo.getKeywords() != null) {
            if (ftinfo.getKeywords() == null) {
                ((FeatureTypeInfoImpl)ftinfo).setKeywords(new ArrayList<KeywordInfo>());
            }
            for (String kw : rinfo.getKeywords()) {
                if (kw == null || "".equals(kw.trim())) {
                    LOGGER.fine("Empty keyword ignored");
                    continue;
                }
                ftinfo.getKeywords().add(new Keyword(kw));
            }
        }
    }

    public ReferencedEnvelope getLatLonBounds(ReferencedEnvelope nativeBounds, CoordinateReferenceSystem declaredCRS) throws IOException {
        if (nativeBounds != null && declaredCRS != null) {
            if (!CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)declaredCRS)) {
                try {
                    ReferencedEnvelope bounds = new ReferencedEnvelope((Envelope)nativeBounds, declaredCRS);
                    return bounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                }
                catch (Exception e) {
                    throw (IOException)new IOException("transform error").initCause(e);
                }
            }
            return new ReferencedEnvelope((Envelope)nativeBounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        return null;
    }

    public ReferencedEnvelope getNativeBounds(ResourceInfo rinfo) throws IOException {
        return this.getNativeBounds(rinfo, null);
    }

    ReferencedEnvelope getNativeBounds(ResourceInfo rinfo, Object data) throws IOException {
        ReferencedEnvelope bounds = null;
        if (rinfo instanceof FeatureTypeInfo) {
            FeatureTypeInfo ftinfo = (FeatureTypeInfo)rinfo;
            bounds = data instanceof FeatureSource ? ((FeatureSource)data).getBounds() : ftinfo.getFeatureSource(null, null).getBounds();
            CoordinateReferenceSystem crs = ftinfo.getNativeCRS();
            if (bounds != null && bounds.getCoordinateReferenceSystem() == null && crs != null) {
                bounds = new ReferencedEnvelope((Envelope)bounds, crs);
            }
            if (bounds != null) {
                double expandBy = 1.0;
                if (bounds.getCoordinateReferenceSystem() instanceof GeographicCRS) {
                    expandBy = 1.0E-4;
                }
                if (bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) {
                    bounds.expandBy(expandBy);
                }
            }
        } else if (rinfo instanceof CoverageInfo) {
            CoverageInfo cinfo = (CoverageInfo)rinfo;
            AbstractGridCoverage2DReader reader = null;
            reader = data instanceof AbstractGridCoverage2DReader ? (AbstractGridCoverage2DReader)data : (AbstractGridCoverage2DReader)cinfo.getGridCoverageReader(null, GeoTools.getDefaultHints());
            bounds = new ReferencedEnvelope((org.opengis.geometry.Envelope)reader.getOriginalEnvelope());
        }
        if (rinfo.getProjectionPolicy() == ProjectionPolicy.REPROJECT_TO_DECLARED && bounds != null) {
            try {
                bounds = bounds.transform(rinfo.getCRS(), true);
            }
            catch (Exception e) {
                throw (IOException)new IOException("transform error").initCause(e);
            }
        }
        return bounds;
    }

    public void lookupSRS(FeatureTypeInfo ftinfo, boolean extensive) throws IOException {
        this.lookupSRS(ftinfo, null, extensive);
    }

    public void lookupSRS(FeatureTypeInfo ftinfo, FeatureSource data, boolean extensive) throws IOException {
        CoordinateReferenceSystem crs = ftinfo.getNativeCRS();
        if (crs == null) {
            crs = data != null ? data.getSchema().getCoordinateReferenceSystem() : ftinfo.getFeatureType().getCoordinateReferenceSystem();
        }
        if (crs != null) {
            try {
                Integer code = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)extensive);
                if (code != null) {
                    ftinfo.setSRS("EPSG:" + code);
                }
            }
            catch (FactoryException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
    }

    private void initResourceInfo(ResourceInfo resInfo) throws Exception {
        if (resInfo.getNativeName() == null && resInfo.getName() != null) {
            resInfo.setNativeName(resInfo.getName());
        }
        if (resInfo.getNativeName() != null && resInfo.getName() == null) {
            resInfo.setName(resInfo.getNativeName());
        }
    }

    public void initFeatureType(FeatureTypeInfo featureType) throws Exception {
        if (featureType.getCatalog() == null) {
            featureType.setCatalog(this.catalog);
        }
        this.initResourceInfo(featureType);
        if (featureType.getSRS() == null) {
            this.lookupSRS(featureType, true);
        }
        if (featureType.getProjectionPolicy() == null) {
            this.setupProjectionPolicy(featureType);
        }
        CoordinateReferenceSystem crs = featureType.getCRS();
        if (featureType.getLatLonBoundingBox() == null && featureType.getNativeBoundingBox() == null) {
            this.setupBounds(featureType);
        } else if (featureType.getLatLonBoundingBox() == null) {
            this.setupBounds(featureType);
        } else if (featureType.getNativeBoundingBox() == null && crs != null) {
            ReferencedEnvelope boundsLatLon = featureType.getLatLonBoundingBox();
            featureType.setNativeBoundingBox(boundsLatLon.transform(crs, true));
        }
    }

    public void initWMSLayer(WMSLayerInfo wmsLayer) throws Exception {
        wmsLayer.setCatalog(this.catalog);
        this.initResourceInfo(wmsLayer);
        OwsUtils.resolveCollections((Object)wmsLayer);
        WMSLayerInfo full = this.buildWMSLayer(wmsLayer.getNativeName());
        if (wmsLayer.getSRS() == null) {
            wmsLayer.setSRS(full.getSRS());
        }
        if (wmsLayer.getNativeCRS() == null) {
            wmsLayer.setNativeCRS(full.getNativeCRS());
        }
        if (wmsLayer.getProjectionPolicy() == null) {
            wmsLayer.setProjectionPolicy(full.getProjectionPolicy());
        }
        if (wmsLayer.getLatLonBoundingBox() == null && wmsLayer.getNativeBoundingBox() == null) {
            wmsLayer.setLatLonBoundingBox(full.getLatLonBoundingBox());
            wmsLayer.setNativeBoundingBox(full.getNativeBoundingBox());
        } else if (wmsLayer.getLatLonBoundingBox() == null) {
            this.setupBounds(wmsLayer);
        } else if (wmsLayer.getNativeBoundingBox() == null && wmsLayer.getNativeCRS() != null) {
            ReferencedEnvelope boundsLatLon = wmsLayer.getLatLonBoundingBox();
            wmsLayer.setNativeBoundingBox(boundsLatLon.transform(wmsLayer.getNativeCRS(), true));
        }
        if (wmsLayer.getTitle() == null) {
            wmsLayer.setTitle(full.getTitle());
        }
        if (wmsLayer.getDescription() == null) {
            wmsLayer.setDescription(full.getDescription());
        }
        if (wmsLayer.getAbstract() == null) {
            wmsLayer.setAbstract(full.getAbstract());
        }
        if (wmsLayer.getKeywords().isEmpty()) {
            wmsLayer.getKeywords().addAll(full.getKeywords());
        }
    }

    public void initCoverage(CoverageInfo cinfo) throws Exception {
        CoverageStoreInfo csinfo = (CoverageStoreInfo)this.store;
        AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)this.catalog.getResourcePool().getGridCoverageReader(csinfo, GeoTools.getDefaultHints());
        this.initResourceInfo(cinfo);
        if (reader == null) {
            throw new Exception("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
        }
        if (cinfo.getNativeCRS() == null) {
            cinfo.setNativeCRS(reader.getCrs());
        }
        CoordinateReferenceSystem nativeCRS = cinfo.getNativeCRS();
        if (cinfo.getSRS() == null) {
            cinfo.setSRS(nativeCRS.getIdentifiers().toArray()[0].toString());
        }
        if (cinfo.getProjectionPolicy() == null) {
            if (nativeCRS != null && !nativeCRS.getIdentifiers().isEmpty()) {
                cinfo.setProjectionPolicy(ProjectionPolicy.REPROJECT_TO_DECLARED);
            }
            if (nativeCRS == null) {
                cinfo.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
            }
        }
        if (cinfo.getLatLonBoundingBox() == null && cinfo.getNativeBoundingBox() == null) {
            GeneralEnvelope envelope = reader.getOriginalEnvelope();
            cinfo.setNativeBoundingBox(new ReferencedEnvelope((org.opengis.geometry.Envelope)envelope));
            cinfo.setLatLonBoundingBox(new ReferencedEnvelope((org.opengis.geometry.Envelope)CoverageStoreUtils.getWGS84LonLatEnvelope(envelope)));
        } else if (cinfo.getLatLonBoundingBox() == null) {
            this.setupBounds(cinfo);
        } else if (cinfo.getNativeBoundingBox() == null && cinfo.getNativeCRS() != null) {
            ReferencedEnvelope boundsLatLon = cinfo.getLatLonBoundingBox();
            cinfo.setNativeBoundingBox(boundsLatLon.transform(cinfo.getNativeCRS(), true));
        }
        if (cinfo.getGrid() == null) {
            GridEnvelope originalRange = reader.getOriginalGridRange();
            cinfo.setGrid((GridGeometry)new GridGeometry2D(originalRange, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), nativeCRS));
        }
    }

    public CoverageInfo buildCoverage() throws Exception {
        if (this.store == null || !(this.store instanceof CoverageStoreInfo)) {
            throw new IllegalStateException("Coverage store not set.");
        }
        CoverageStoreInfo csinfo = (CoverageStoreInfo)this.store;
        AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)this.catalog.getResourcePool().getGridCoverageReader(csinfo, GeoTools.getDefaultHints());
        if (reader == null) {
            throw new Exception("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
        }
        return this.buildCoverage(reader, null);
    }

    public CoverageInfo buildCoverage(AbstractGridCoverage2DReader reader, Map customParameters) throws Exception {
        if (this.store == null || !(this.store instanceof CoverageStoreInfo)) {
            throw new IllegalStateException("Coverage store not set.");
        }
        CoverageStoreInfo csinfo = (CoverageStoreInfo)this.store;
        CoverageInfo cinfo = this.catalog.getFactory().createCoverage();
        cinfo.setStore(csinfo);
        cinfo.setEnabled(true);
        WorkspaceInfo workspace = this.store.getWorkspace();
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(workspace.getName());
        if (namespace == null) {
            namespace = this.catalog.getDefaultNamespace();
        }
        cinfo.setNamespace(namespace);
        CoordinateReferenceSystem nativeCRS = reader.getCrs();
        cinfo.setNativeCRS(nativeCRS);
        if (nativeCRS != null && !nativeCRS.getIdentifiers().isEmpty()) {
            cinfo.setSRS(nativeCRS.getIdentifiers().toArray()[0].toString());
            cinfo.setProjectionPolicy(ProjectionPolicy.REPROJECT_TO_DECLARED);
        }
        if (nativeCRS == null) {
            cinfo.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        }
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        cinfo.setNativeBoundingBox(new ReferencedEnvelope((org.opengis.geometry.Envelope)envelope));
        cinfo.setLatLonBoundingBox(new ReferencedEnvelope((org.opengis.geometry.Envelope)CoverageStoreUtils.getWGS84LonLatEnvelope(envelope)));
        GridEnvelope originalRange = reader.getOriginalGridRange();
        cinfo.setGrid((GridGeometry)new GridGeometry2D(originalRange, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), nativeCRS));
        AbstractGridFormat format = csinfo.getFormat();
        ParameterValueGroup readParams = format.getReadParameters();
        Map parameters = CoverageUtils.getParametersKVP(readParams);
        int minX = originalRange.getLow(0);
        int minY = originalRange.getLow(1);
        int width = originalRange.getSpan(0);
        int height = originalRange.getSpan(1);
        int maxX = minX + (width <= 5 ? width : 5);
        int maxY = minY + (height <= 5 ? height : 5);
        GridEnvelope2D testRange = new GridEnvelope2D(minX, minY, maxX, maxY);
        MathTransform gridToWorldCorner = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        GeneralEnvelope testEnvelope = CRS.transform((MathTransform)gridToWorldCorner, (org.opengis.geometry.Envelope)new GeneralEnvelope((Rectangle2D)testRange.getBounds()));
        testEnvelope.setCoordinateReferenceSystem(nativeCRS);
        if (customParameters != null) {
            parameters.putAll(customParameters);
        }
        String maxAllowedTiles = ImageMosaicFormat.MAX_ALLOWED_TILES.getName().toString();
        if (parameters.keySet().contains(maxAllowedTiles)) {
            parameters.put(maxAllowedTiles, 1);
        }
        parameters.put(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), new GridGeometry2D((GridEnvelope)testRange, (org.opengis.geometry.Envelope)testEnvelope));
        GridCoverage2D gc = reader.read(CoverageUtils.getParameters(readParams, parameters, true));
        if (gc == null) {
            throw new Exception("Unable to acquire test coverage for format:" + format.getName());
        }
        parameters.remove(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString());
        cinfo.getDimensions().addAll(this.getCoverageDimensions(gc.getSampleDimensions()));
        String name = gc.getName().toString();
        cinfo.setName(name);
        cinfo.setNativeName(name);
        cinfo.setTitle(name);
        cinfo.setDescription("Generated from " + format.getName());
        cinfo.getKeywords().add(new Keyword("WCS"));
        cinfo.getKeywords().add(new Keyword(format.getName()));
        cinfo.getKeywords().add(new Keyword(name));
        cinfo.setNativeFormat(format.getName());
        cinfo.getMetadata().put("dirName", (Serializable)((Object)(this.store.getName() + "_" + name)));
        if (gc.getCoordinateReferenceSystem2D().getIdentifiers() != null && !gc.getCoordinateReferenceSystem2D().getIdentifiers().isEmpty()) {
            cinfo.getRequestSRS().add(((Identifier)gc.getCoordinateReferenceSystem2D().getIdentifiers().toArray()[0]).toString());
        }
        if (gc.getCoordinateReferenceSystem2D().getIdentifiers() != null && !gc.getCoordinateReferenceSystem2D().getIdentifiers().isEmpty()) {
            cinfo.getResponseSRS().add(((Identifier)gc.getCoordinateReferenceSystem2D().getIdentifiers().toArray()[0]).toString());
        }
        List formats = CoverageStoreUtils.listDataFormats();
        for (Format fTmp : formats) {
            String fName = fTmp.getName();
            if (fName.equalsIgnoreCase("WorldImage")) {
                cinfo.getSupportedFormats().add("GIF");
                cinfo.getSupportedFormats().add("PNG");
                cinfo.getSupportedFormats().add("JPEG");
                cinfo.getSupportedFormats().add("TIFF");
                continue;
            }
            if (fName.toLowerCase().startsWith("geotiff")) {
                cinfo.getSupportedFormats().add("GEOTIFF");
                continue;
            }
            cinfo.getSupportedFormats().add(fName);
        }
        cinfo.setDefaultInterpolationMethod("nearest neighbor");
        cinfo.getInterpolationMethods().add("nearest neighbor");
        cinfo.getInterpolationMethods().add("bilinear");
        cinfo.getInterpolationMethods().add("bicubic");
        cinfo.getParameters().putAll(CoverageUtils.getParametersKVP(readParams));
        gc.dispose(true);
        if (gc.getRenderedImage() instanceof PlanarImage) {
            ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)gc.getRenderedImage()));
        }
        return cinfo;
    }

    List<CoverageDimensionInfo> getCoverageDimensions(GridSampleDimension[] sampleDimensions) {
        int length = sampleDimensions.length;
        ArrayList<CoverageDimensionInfo> dims = new ArrayList<CoverageDimensionInfo>();
        for (int i = 0; i < length; ++i) {
            CoverageDimensionInfo dim = this.catalog.getFactory().createCoverageDimension();
            dim.setName(sampleDimensions[i].getDescription().toString(Locale.getDefault()));
            StringBuilder label = new StringBuilder("GridSampleDimension".intern());
            Unit uom = sampleDimensions[i].getUnits();
            if (uom != null) {
                label.append("(".intern());
                this.parseUOM(label, uom);
                label.append(")".intern());
            }
            label.append("[".intern());
            label.append(sampleDimensions[i].getMinimumValue());
            label.append(",".intern());
            label.append(sampleDimensions[i].getMaximumValue());
            label.append("]".intern());
            dim.setDescription(label.toString());
            dim.setRange(sampleDimensions[i].getRange());
            List categories = sampleDimensions[i].getCategories();
            if (categories != null) {
                for (Category cat : categories) {
                    if (cat == null || !cat.getName().toString().equalsIgnoreCase("no data")) continue;
                    double min = cat.getRange().getMinimum();
                    double max = cat.getRange().getMaximum();
                    dim.getNullValues().add(min);
                    if (min == max) continue;
                    dim.getNullValues().add(max);
                }
            }
            dims.add(dim);
        }
        return dims;
    }

    public WMSLayerInfo buildWMSLayer(String layerName) throws IOException {
        String published;
        CRSEnvelope llbbox;
        if (this.store == null || !(this.store instanceof WMSStoreInfo)) {
            throw new IllegalStateException("WMS store not set.");
        }
        WMSStoreInfo wms = (WMSStoreInfo)this.store;
        WMSLayerInfo wli = this.catalog.getFactory().createWMSLayer();
        wli.setName(layerName);
        wli.setNativeName(layerName);
        wli.setStore(this.store);
        wli.setEnabled(true);
        WorkspaceInfo workspace = this.store.getWorkspace();
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(workspace.getName());
        if (namespace == null) {
            namespace = this.catalog.getDefaultNamespace();
        }
        wli.setNamespace(namespace);
        Layer layer = wli.getWMSLayer(null);
        for (String srs : layer.getBoundingBoxes().keySet()) {
            try {
                CoordinateReferenceSystem crs = CRS.decode((String)srs);
                wli.setSRS(srs);
                wli.setNativeCRS(crs);
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Skipping " + srs + " definition, it was not recognized by the referencing subsystem");
            }
        }
        String srs = wli.getSRS();
        try {
            if (srs == null || srs.equals("CRS:84")) {
                wli.setSRS("EPSG:4326");
                srs = "EPSG:4326";
                wli.setNativeCRS(CRS.decode((String)"EPSG:4326"));
            } else if (srs.equals("CRS:83")) {
                wli.setSRS("EPSG:4269");
                srs = "EPSG:4269";
                wli.setNativeCRS(CRS.decode((String)"EPSG:4269"));
            } else if (srs.equals("CRS:27")) {
                wli.setSRS("EPSG:4267");
                srs = "EPSG:4267";
                wli.setNativeCRS(CRS.decode((String)"EPSG:4267"));
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException("Failed to compute the layer declared SRS code").initCause(e);
        }
        wli.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        GeneralEnvelope envelope = layer.getEnvelope(wli.getNativeCRS());
        if (envelope != null) {
            ReferencedEnvelope re = new ReferencedEnvelope(envelope.getMinimum(0), envelope.getMaximum(0), envelope.getMinimum(1), envelope.getMaximum(1), wli.getNativeCRS());
            WebMapServer mapServer = wms.getWebMapServer(null);
            Version version = new Version(mapServer.getCapabilities().getVersion());
            if (this.axisFlipped(version, srs)) {
                double minx = re.getMinX();
                double miny = re.getMinY();
                double maxx = re.getMaxX();
                double maxy = re.getMaxY();
                re = new ReferencedEnvelope(miny, maxy, minx, maxx, wli.getNativeCRS());
            }
            wli.setNativeBoundingBox(re);
        }
        if ((llbbox = layer.getLatLonBoundingBox()) != null) {
            ReferencedEnvelope re = new ReferencedEnvelope(llbbox.getMinX(), llbbox.getMaxX(), llbbox.getMinY(), llbbox.getMaxY(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            wli.setLatLonBoundingBox(re);
        } else if (wli.getNativeBoundingBox() != null) {
            try {
                wli.setLatLonBoundingBox(wli.getNativeBoundingBox().transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true));
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Could not transform native bbox into a lat/lon one", e);
            }
        }
        wli.setAbstract(layer.get_abstract());
        wli.setDescription(layer.get_abstract());
        wli.setTitle(layer.getTitle());
        if (layer.getKeywords() != null) {
            for (String kw : layer.getKeywords()) {
                if (kw == null) continue;
                wli.getKeywords().add(new Keyword(kw));
            }
        }
        if ((published = wli.getName()).contains(":")) {
            wli.setName(published.substring(published.lastIndexOf(58) + 1));
        }
        return wli;
    }

    private boolean axisFlipped(Version version, String srsName) {
        if (version.compareTo(new Version("1.3.0")) < 0) {
            return false;
        }
        if (srsName.startsWith("EPSG:")) {
            try {
                String epsgNative = "urn:x-ogc:def:crs:EPSG:".concat(srsName.substring(5));
                return CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)epsgNative)) == CRS.AxisOrder.NORTH_EAST;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to determine axis order for " + srsName + ", assuming east/north", e);
                return false;
            }
        }
        return false;
    }

    void parseUOM(StringBuilder label, Unit uom) {
        String uomString = uom.toString();
        uomString = uomString.replaceAll("\ufffd", "^2");
        uomString = uomString.replaceAll("\ufffd", "^3");
        uomString = uomString.replaceAll("\ufffd", "A");
        uomString = uomString.replaceAll("\ufffd", "");
        label.append(uomString);
    }

    public LayerInfo buildLayer(FeatureTypeInfo featureType) throws IOException {
        LayerInfo layer = this.buildLayer((ResourceInfo)featureType);
        StyleInfo style = this.getDefaultStyle(featureType);
        layer.setDefaultStyle(style);
        return layer;
    }

    public LayerInfo buildLayer(CoverageInfo coverage) throws IOException {
        LayerInfo layer = this.buildLayer((ResourceInfo)coverage);
        layer.setDefaultStyle(this.getDefaultStyle(coverage));
        return layer;
    }

    public LayerInfo buildLayer(WMSLayerInfo wms) throws IOException {
        LayerInfo layer = this.buildLayer((ResourceInfo)wms);
        layer.setDefaultStyle(this.getDefaultStyle(wms));
        return layer;
    }

    public StyleInfo getDefaultStyle(ResourceInfo resource) throws IOException {
        if (resource instanceof CoverageInfo || resource instanceof WMSLayerInfo) {
            return this.catalog.getStyleByName("raster");
        }
        FeatureTypeInfo featureType = (FeatureTypeInfo)resource;
        if (featureType.getFeatureType() == null) {
            return null;
        }
        GeometryDescriptor gd = featureType.getFeatureType().getGeometryDescriptor();
        if (gd == null) {
            return null;
        }
        Class gtype = gd.getType().getBinding();
        String styleName = Point.class.isAssignableFrom(gtype) || MultiPoint.class.isAssignableFrom(gtype) ? "point" : (LineString.class.isAssignableFrom(gtype) || MultiLineString.class.isAssignableFrom(gtype) ? "line" : (Polygon.class.isAssignableFrom(gtype) || MultiPolygon.class.isAssignableFrom(gtype) ? "polygon" : "point"));
        return this.catalog.getStyleByName(styleName);
    }

    public LayerInfo buildLayer(ResourceInfo resource) {
        LayerInfo layer = this.catalog.getFactory().createLayer();
        layer.setResource(resource);
        layer.setName(resource.getName());
        layer.setEnabled(true);
        if (layer.getResource() instanceof FeatureTypeInfo) {
            layer.setType(LayerInfo.Type.VECTOR);
        } else if (layer.getResource() instanceof CoverageInfo) {
            layer.setType(LayerInfo.Type.RASTER);
        } else if (layer.getResource() instanceof WMSLayerInfo) {
            layer.setType(LayerInfo.Type.WMS);
        }
        return layer;
    }

    public void calculateLayerGroupBounds(LayerGroupInfo lg, CoordinateReferenceSystem crs) throws Exception {
        if (lg.getLayers().isEmpty()) {
            return;
        }
        LayerInfo l = lg.getLayers().get(0);
        ReferencedEnvelope bounds = this.transform(l.getResource().getLatLonBoundingBox(), crs);
        for (int i = 1; i < lg.getLayers().size(); ++i) {
            l = lg.getLayers().get(i);
            bounds.expandToInclude((Envelope)this.transform(l.getResource().getLatLonBoundingBox(), crs));
        }
        lg.setBounds(bounds);
    }

    public void calculateLayerGroupBounds(LayerGroupInfo lg) throws Exception {
        if (lg.getLayers().isEmpty()) {
            return;
        }
        LayerInfo l = lg.getLayers().get(0);
        ReferencedEnvelope bounds = l.getResource().boundingBox();
        boolean latlon = false;
        if (bounds == null) {
            bounds = l.getResource().getLatLonBoundingBox();
            latlon = true;
        }
        if (bounds == null) {
            throw new IllegalArgumentException("Could not calculate bounds from layer with no bounds, " + l.getName());
        }
        for (int i = 1; i < lg.getLayers().size(); ++i) {
            l = lg.getLayers().get(i);
            ReferencedEnvelope re = latlon ? l.getResource().getLatLonBoundingBox() : l.getResource().boundingBox();
            if ((re = this.transform(re, bounds.getCoordinateReferenceSystem())) == null) {
                throw new IllegalArgumentException("Could not calculate bounds from layer with no bounds, " + l.getName());
            }
            bounds.expandToInclude((Envelope)re);
        }
        lg.setBounds(bounds);
    }

    ReferencedEnvelope transform(ReferencedEnvelope e, CoordinateReferenceSystem crs) throws TransformException, FactoryException {
        if (!CRS.equalsIgnoreMetadata((Object)crs, (Object)e.getCoordinateReferenceSystem())) {
            return e.transform(crs, true);
        }
        return e;
    }

    public void removeWorkspace(WorkspaceInfo workspace, boolean recursive) {
        if (recursive) {
            workspace.accept(new CascadeDeleteVisitor(this.catalog));
        } else {
            this.catalog.remove(workspace);
        }
    }

    public void removeStore(StoreInfo store, boolean recursive) {
        if (recursive) {
            store.accept(new CascadeDeleteVisitor(this.catalog));
        } else {
            this.catalog.remove(store);
        }
    }

    public void removeResource(ResourceInfo resource, boolean recursive) {
        if (recursive) {
            resource.accept(new CascadeDeleteVisitor(this.catalog));
        } else {
            this.catalog.remove(resource);
        }
    }

    public void attach(StoreInfo storeInfo) {
        storeInfo = ModificationProxy.unwrap(storeInfo);
        ((StoreInfoImpl)storeInfo).setCatalog(this.catalog);
    }

    public void attach(ResourceInfo resourceInfo) {
        resourceInfo = ModificationProxy.unwrap(resourceInfo);
        ((ResourceInfoImpl)resourceInfo).setCatalog(this.catalog);
    }

    public void attach(LayerInfo layerInfo) {
        this.attach(layerInfo.getResource());
    }

    public void attach(MapInfo mapInfo) {
        for (LayerInfo layer : mapInfo.getLayers()) {
            this.attach(layer);
        }
    }

    public void attach(LayerGroupInfo groupInfo) {
        for (LayerInfo layer : groupInfo.getLayers()) {
            this.attach(layer);
        }
        for (StyleInfo style : groupInfo.getStyles()) {
            if (style == null) continue;
            this.attach(style);
        }
    }

    public void attach(StyleInfo styleInfo) {
        styleInfo = ModificationProxy.unwrap(styleInfo);
        ((StyleInfoImpl)styleInfo).setCatalog(this.catalog);
    }

    public void attach(NamespaceInfo nsInfo) {
    }

    public void attach(WorkspaceInfo wsInfo) {
    }
}

