/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.util.Collection;
import java.util.List;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.platform.GeoServerResourceLoader;
import org.opengis.feature.type.Name;

public interface Catalog
extends CatalogInfo {
    public static final String DEFAULT = "default";

    public CatalogFacade getFacade();

    public CatalogFactory getFactory();

    public void add(StoreInfo var1);

    public List<RuntimeException> validate(StoreInfo var1, boolean var2);

    public void remove(StoreInfo var1);

    public void save(StoreInfo var1);

    public <T extends StoreInfo> T detach(T var1);

    public <T extends StoreInfo> T getStore(String var1, Class<T> var2);

    public <T extends StoreInfo> T getStoreByName(String var1, Class<T> var2);

    public <T extends StoreInfo> T getStoreByName(String var1, String var2, Class<T> var3);

    public <T extends StoreInfo> T getStoreByName(WorkspaceInfo var1, String var2, Class<T> var3);

    public <T extends StoreInfo> List<T> getStores(Class<T> var1);

    public <T extends StoreInfo> List<T> getStoresByWorkspace(WorkspaceInfo var1, Class<T> var2);

    public <T extends StoreInfo> List<T> getStoresByWorkspace(String var1, Class<T> var2);

    public DataStoreInfo getDataStore(String var1);

    public DataStoreInfo getDataStoreByName(String var1);

    public DataStoreInfo getDataStoreByName(String var1, String var2);

    public DataStoreInfo getDataStoreByName(WorkspaceInfo var1, String var2);

    public List<DataStoreInfo> getDataStoresByWorkspace(String var1);

    public List<DataStoreInfo> getDataStoresByWorkspace(WorkspaceInfo var1);

    public List<DataStoreInfo> getDataStores();

    public DataStoreInfo getDefaultDataStore(WorkspaceInfo var1);

    public void setDefaultDataStore(WorkspaceInfo var1, DataStoreInfo var2);

    public CoverageStoreInfo getCoverageStore(String var1);

    public CoverageStoreInfo getCoverageStoreByName(String var1);

    public CoverageStoreInfo getCoverageStoreByName(String var1, String var2);

    public CoverageStoreInfo getCoverageStoreByName(WorkspaceInfo var1, String var2);

    public List<CoverageStoreInfo> getCoverageStoresByWorkspace(String var1);

    public List<CoverageStoreInfo> getCoverageStoresByWorkspace(WorkspaceInfo var1);

    public List<CoverageStoreInfo> getCoverageStores();

    public <T extends ResourceInfo> T getResource(String var1, Class<T> var2);

    public <T extends ResourceInfo> T getResourceByName(String var1, String var2, Class<T> var3);

    public <T extends ResourceInfo> T getResourceByName(NamespaceInfo var1, String var2, Class<T> var3);

    public <T extends ResourceInfo> T getResourceByName(Name var1, Class<T> var2);

    public <T extends ResourceInfo> T getResourceByName(String var1, Class<T> var2);

    public void add(ResourceInfo var1);

    public List<RuntimeException> validate(ResourceInfo var1, boolean var2);

    public void remove(ResourceInfo var1);

    public void save(ResourceInfo var1);

    public <T extends ResourceInfo> T detach(T var1);

    public <T extends ResourceInfo> List<T> getResources(Class<T> var1);

    public <T extends ResourceInfo> List<T> getResourcesByNamespace(NamespaceInfo var1, Class<T> var2);

    public <T extends ResourceInfo> List<T> getResourcesByNamespace(String var1, Class<T> var2);

    public <T extends ResourceInfo> T getResourceByStore(StoreInfo var1, String var2, Class<T> var3);

    public <T extends ResourceInfo> List<T> getResourcesByStore(StoreInfo var1, Class<T> var2);

    public FeatureTypeInfo getFeatureType(String var1);

    public FeatureTypeInfo getFeatureTypeByName(String var1, String var2);

    public FeatureTypeInfo getFeatureTypeByName(NamespaceInfo var1, String var2);

    public FeatureTypeInfo getFeatureTypeByName(Name var1);

    public FeatureTypeInfo getFeatureTypeByName(String var1);

    public List<FeatureTypeInfo> getFeatureTypes();

    public List<FeatureTypeInfo> getFeatureTypesByNamespace(NamespaceInfo var1);

    public FeatureTypeInfo getFeatureTypeByStore(DataStoreInfo var1, String var2);

    public FeatureTypeInfo getFeatureTypeByDataStore(DataStoreInfo var1, String var2);

    public List<FeatureTypeInfo> getFeatureTypesByStore(DataStoreInfo var1);

    public List<FeatureTypeInfo> getFeatureTypesByDataStore(DataStoreInfo var1);

    public CoverageInfo getCoverage(String var1);

    public CoverageInfo getCoverageByName(String var1, String var2);

    public CoverageInfo getCoverageByName(NamespaceInfo var1, String var2);

    public CoverageInfo getCoverageByName(Name var1);

    public CoverageInfo getCoverageByName(String var1);

    public List<CoverageInfo> getCoverages();

    public List<CoverageInfo> getCoveragesByNamespace(NamespaceInfo var1);

    public CoverageInfo getCoverageByCoverageStore(CoverageStoreInfo var1, String var2);

    public List<CoverageInfo> getCoveragesByCoverageStore(CoverageStoreInfo var1);

    public void add(LayerInfo var1);

    public List<RuntimeException> validate(LayerInfo var1, boolean var2);

    public void remove(LayerInfo var1);

    public void save(LayerInfo var1);

    public LayerInfo detach(LayerInfo var1);

    public List<CoverageInfo> getCoveragesByStore(CoverageStoreInfo var1);

    public LayerInfo getLayer(String var1);

    public LayerInfo getLayerByName(String var1);

    public LayerInfo getLayerByName(Name var1);

    public List<LayerInfo> getLayers();

    public List<LayerInfo> getLayers(ResourceInfo var1);

    public List<LayerInfo> getLayers(StyleInfo var1);

    public void add(MapInfo var1);

    public void remove(MapInfo var1);

    public void save(MapInfo var1);

    public MapInfo detach(MapInfo var1);

    public List<MapInfo> getMaps();

    public MapInfo getMap(String var1);

    public MapInfo getMapByName(String var1);

    public void add(LayerGroupInfo var1);

    public List<RuntimeException> validate(LayerGroupInfo var1, boolean var2);

    public void remove(LayerGroupInfo var1);

    public void save(LayerGroupInfo var1);

    public LayerGroupInfo detach(LayerGroupInfo var1);

    public List<LayerGroupInfo> getLayerGroups();

    public List<LayerGroupInfo> getLayerGroupsByWorkspace(String var1);

    public List<LayerGroupInfo> getLayerGroupsByWorkspace(WorkspaceInfo var1);

    public LayerGroupInfo getLayerGroup(String var1);

    public LayerGroupInfo getLayerGroupByName(String var1);

    public LayerGroupInfo getLayerGroupByName(String var1, String var2);

    public LayerGroupInfo getLayerGroupByName(WorkspaceInfo var1, String var2);

    public void add(StyleInfo var1);

    public List<RuntimeException> validate(StyleInfo var1, boolean var2);

    public void remove(StyleInfo var1);

    public void save(StyleInfo var1);

    public StyleInfo detach(StyleInfo var1);

    public StyleInfo getStyle(String var1);

    public StyleInfo getStyleByName(String var1, String var2);

    public StyleInfo getStyleByName(WorkspaceInfo var1, String var2);

    public StyleInfo getStyleByName(String var1);

    public List<StyleInfo> getStyles();

    public List<StyleInfo> getStylesByWorkspace(String var1);

    public List<StyleInfo> getStylesByWorkspace(WorkspaceInfo var1);

    public void add(NamespaceInfo var1);

    public List<RuntimeException> validate(NamespaceInfo var1, boolean var2);

    public void remove(NamespaceInfo var1);

    public void save(NamespaceInfo var1);

    public NamespaceInfo detach(NamespaceInfo var1);

    public NamespaceInfo getNamespace(String var1);

    public NamespaceInfo getNamespaceByPrefix(String var1);

    public NamespaceInfo getNamespaceByURI(String var1);

    public NamespaceInfo getDefaultNamespace();

    public void setDefaultNamespace(NamespaceInfo var1);

    public List<NamespaceInfo> getNamespaces();

    public void add(WorkspaceInfo var1);

    public List<RuntimeException> validate(WorkspaceInfo var1, boolean var2);

    public void remove(WorkspaceInfo var1);

    public void save(WorkspaceInfo var1);

    public WorkspaceInfo detach(WorkspaceInfo var1);

    public WorkspaceInfo getDefaultWorkspace();

    public void setDefaultWorkspace(WorkspaceInfo var1);

    public List<WorkspaceInfo> getWorkspaces();

    public WorkspaceInfo getWorkspace(String var1);

    public WorkspaceInfo getWorkspaceByName(String var1);

    public Collection<CatalogListener> getListeners();

    public void addListener(CatalogListener var1);

    public void removeListener(CatalogListener var1);

    public void fireAdded(CatalogInfo var1);

    public void fireModified(CatalogInfo var1, List<String> var2, List var3, List var4);

    public void firePostModified(CatalogInfo var1);

    public void fireRemoved(CatalogInfo var1);

    public ResourcePool getResourcePool();

    public void setResourcePool(ResourcePool var1);

    public GeoServerResourceLoader getResourceLoader();

    public void setResourceLoader(GeoServerResourceLoader var1);

    public void dispose();
}

