/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import java.awt.RenderingHints;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.RegistryMode;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataStoreFinder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.image.io.ImageIOExt;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.util.WeakCollectionCleaner;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;

public class GeoserverInitStartupListener
implements ServletContextListener {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.logging");
    boolean relinquishLoggingControl;
    private Iterator<Class<?>> products;

    public void contextInitialized(ServletContextEvent sce) {
        String strValue = GeoServerExtensions.getProperty((String)"RELINQUISH_LOG4J_CONTROL", (ServletContext)sce.getServletContext());
        this.relinquishLoggingControl = Boolean.valueOf(strValue);
        if (System.getProperty("org.geotools.referencing.forceXY") == null) {
            System.setProperty("org.geotools.referencing.forceXY", "true");
        }
        if (Boolean.TRUE.equals(Hints.getSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER))) {
            Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING, (Object)"http");
        }
        Hints.putSystemDefault((RenderingHints.Key)Hints.COMPARISON_TOLERANCE, (Object)1.0E-9);
        System.setProperty("org.geotools.epsg.factory.timeout", "-1");
        System.setProperty("java.util.prefs.syncInterval", "5000000");
        if (System.getProperty("java.version").startsWith("1.4") && System.getProperty("com.sun.media.imageio.disableCodecLib") == null) {
            LOGGER.warning("Disabling mediaLib acceleration since this is a java 1.4 VM.\n If you want to force its enabling, set -Dcom.sun.media.imageio.disableCodecLib=true in your virtual machine");
            System.setProperty("com.sun.media.imageio.disableCodecLib", "true");
        } else {
            ImageIOExt.allowNativeCodec((String)"png", ImageReaderSpi.class, (boolean)false);
        }
        ImageIO.scanForPlugins();
        Hints.putSystemDefault((RenderingHints.Key)Hints.FILTER_FACTORY, (Object)CommonFactoryFinder.getFilterFactory2(null));
        Hints.putSystemDefault((RenderingHints.Key)Hints.STYLE_FACTORY, (Object)CommonFactoryFinder.getStyleFactory(null));
        Hints.putSystemDefault((RenderingHints.Key)Hints.FEATURE_FACTORY, (Object)CommonFactoryFinder.getFeatureFactory(null));
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 5, 30000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        Hints.putSystemDefault((RenderingHints.Key)Hints.EXECUTOR_SERVICE, (Object)executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        try {
            Driver driver;
            LOGGER.info("Beginning GeoServer cleanup sequence");
            ClassLoader webappClassLoader = this.getClass().getClassLoader();
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            HashSet<Driver> driversToUnload = new HashSet<Driver>();
            while (drivers.hasMoreElements()) {
                driver = drivers.nextElement();
                try {
                    ClassLoader driverClassLoader = driver.getClass().getClassLoader();
                    if (driverClassLoader == null || !webappClassLoader.equals(driverClassLoader)) continue;
                    driversToUnload.add(driver);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            for (Driver driver2 : driversToUnload) {
                try {
                    DriverManager.deregisterDriver(driver2);
                    LOGGER.info("Unregistered JDBC driver " + driver2);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Could now unload driver " + driver2.getClass(), e);
                }
            }
            drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                driver = drivers.nextElement();
            }
            try {
                Class<?> h2Driver = Class.forName("org.h2.Driver");
                Method m = h2Driver.getMethod("unload", new Class[0]);
                m.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to unload the H2 driver", e);
            }
            try {
                this.disposeAuthorityFactories(ReferencingFactoryFinder.getCoordinateOperationAuthorityFactories(null));
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Error occurred trying to dispose authority factories", e);
            }
            try {
                this.disposeAuthorityFactories(ReferencingFactoryFinder.getCRSAuthorityFactories(null));
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Error occurred trying to dispose authority factories", e);
            }
            try {
                this.disposeAuthorityFactories(ReferencingFactoryFinder.getCSAuthorityFactories(null));
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Error occurred trying to dispose authority factories", e);
            }
            WeakCollectionCleaner.DEFAULT.exit();
            DeferredAuthorityFactory.exit();
            CRS.reset((String)"all");
            LOGGER.info("Shut down GT referencing threads ");
            ReferencingFactoryFinder.reset();
            CommonFactoryFinder.reset();
            DataStoreFinder.reset();
            DataAccessFinder.reset();
            LOGGER.info("Shut down GT  SPI ");
            LOGGER.info("Shut down coverage thread pool ");
            Object o = Hints.getSystemDefault((RenderingHints.Key)Hints.EXECUTOR_SERVICE);
            if (o != null && o instanceof ExecutorService) {
                ThreadPoolExecutor executor = (ThreadPoolExecutor)o;
                try {
                    executor.shutdown();
                }
                finally {
                    executor.shutdownNow();
                }
            }
            IIORegistry ioRegistry = IIORegistry.getDefaultInstance();
            HashSet<IIOServiceProvider> providersToUnload = new HashSet<IIOServiceProvider>();
            Iterator<Class<?>> cats = ioRegistry.getCategories();
            while (cats.hasNext()) {
                Class<?> category = cats.next();
                Iterator<?> it = ioRegistry.getServiceProviders(category, false);
                while (it.hasNext()) {
                    IIOServiceProvider provider = (IIOServiceProvider)it.next();
                    if (!webappClassLoader.equals(provider.getClass().getClassLoader())) continue;
                    providersToUnload.add(provider);
                }
            }
            for (IIOServiceProvider provider : providersToUnload) {
                ioRegistry.deregisterServiceProvider(provider);
                LOGGER.info("Unregistering Image I/O provider " + provider);
            }
            OperationRegistry opRegistry = JAI.getDefaultInstance().getOperationRegistry();
            for (String mode : RegistryMode.getModeNames()) {
                Iterator descriptors = opRegistry.getDescriptors(mode).iterator();
                while (descriptors != null && descriptors.hasNext()) {
                    RegistryElementDescriptor red = (RegistryElementDescriptor)descriptors.next();
                    int factoryCount = 0;
                    int unregisteredCount = 0;
                    Iterator factories = opRegistry.getFactoryIterator(mode, red.getName());
                    while (factories != null && factories.hasNext()) {
                        Object factory = factories.next();
                        if (factory == null) continue;
                        ++factoryCount;
                        if (!webappClassLoader.equals(factory.getClass().getClassLoader())) continue;
                        boolean unregistered = false;
                        Vector orderedProductList = opRegistry.getOrderedProductList(mode, red.getName());
                        if (orderedProductList != null) {
                            Iterator products = orderedProductList.iterator();
                            while (products != null && products.hasNext()) {
                                String product = (String)products.next();
                                try {
                                    opRegistry.unregisterFactory(mode, red.getName(), product, factory);
                                    LOGGER.info("Unregistering JAI factory " + factory.getClass());
                                }
                                catch (Throwable t) {}
                            }
                        }
                        if (!unregistered) continue;
                        ++unregisteredCount;
                    }
                    if (factoryCount <= 0 || unregisteredCount != factoryCount) continue;
                    opRegistry.unregisterDescriptor(red);
                }
            }
            Introspector.flushCaches();
            LOGGER.info("Cleaned up javabean caches");
            if (!this.relinquishLoggingControl) {
                LogManager.shutdown();
            }
            LogFactory.release((ClassLoader)Thread.currentThread().getContextClassLoader());
            try {
                System.gc();
                System.runFinalization();
                System.gc();
                System.runFinalization();
                System.gc();
                System.runFinalization();
            }
            catch (Throwable t) {
                System.out.println("Failed to perform closing up finalization");
                t.printStackTrace();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void disposeAuthorityFactories(Set<? extends AuthorityFactory> factories) throws FactoryException {
        for (AuthorityFactory authorityFactory : factories) {
            if (!(authorityFactory instanceof AbstractAuthorityFactory)) continue;
            LOGGER.info("Disposing referencing factory " + authorityFactory);
            ((AbstractAuthorityFactory)authorityFactory).dispose();
        }
    }
}

