/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

public class GeoServerConfigurationLock {
    private static final Level LEVEL = Level.FINE;
    private static final Logger LOGGER = Logging.getLogger(GeoServerConfigurationLock.class);
    private static final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private boolean enabled;

    public GeoServerConfigurationLock() {
        String pvalue = System.getProperty("GeoServerConfigurationLock.enabled");
        this.enabled = pvalue != null ? Boolean.parseBoolean(pvalue) : true;
        LOGGER.info("GeoServer configuration lock is " + (this.enabled ? "enabled" : "disabled"));
    }

    public void lock(LockType type) {
        if (!this.enabled) {
            return;
        }
        Lock lock = type == LockType.WRITE ? readWriteLock.writeLock() : readWriteLock.readLock();
        if (LOGGER.isLoggable(LEVEL)) {
            LOGGER.log(LEVEL, "Thread " + Thread.currentThread().getId() + " locking in mode " + (Object)((Object)type));
        }
        lock.lock();
        if (LOGGER.isLoggable(LEVEL)) {
            LOGGER.log(LEVEL, "Thread " + Thread.currentThread().getId() + " got the lock in mode " + (Object)((Object)type));
        }
    }

    public void unlock(LockType type) {
        if (!this.enabled) {
            return;
        }
        Lock lock = type == LockType.WRITE ? readWriteLock.writeLock() : readWriteLock.readLock();
        if (LOGGER.isLoggable(LEVEL)) {
            LOGGER.log(LEVEL, "Thread " + Thread.currentThread().getId() + " releasing the lock in mode " + (Object)((Object)type));
        }
        lock.unlock();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static enum LockType {
        READ,
        WRITE;

    }
}

