/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Rectangle;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.util.Cloneable;

public class GridEnvelope2D
extends Rectangle
implements GridEnvelope,
Cloneable {
    private static final long serialVersionUID = -3370515914148690059L;

    public GridEnvelope2D() {
    }

    public GridEnvelope2D(Rectangle rectangle) {
        super(rectangle);
    }

    public GridEnvelope2D(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public GridEnvelope2D(Envelope2D envelope, PixelInCell anchor) throws IllegalArgumentException {
        this(envelope, anchor, false);
    }

    public GridEnvelope2D(Envelope2D envelope, PixelInCell anchor, boolean isHighIncluded) throws IllegalArgumentException {
        int i;
        double offset = PixelTranslation.getPixelTranslation((PixelInCell)anchor) + 0.5;
        int dimension = envelope.getDimension();
        assert (dimension == 2);
        int[] index = new int[dimension * 2];
        for (i = 0; i < dimension; ++i) {
            index[i] = (int)Math.round(envelope.getMinimum(i) + offset);
            index[i + dimension] = (int)Math.round(envelope.getMaximum(i) + offset);
        }
        if (isHighIncluded) {
            i = index.length / 2;
            while (i < index.length) {
                int n = i++;
                index[n] = index[n] + 1;
            }
        }
        this.setLocation(index[0], index[1]);
        this.setSize(index[0 + dimension] - index[0], index[1 + dimension] - index[1]);
    }

    public final int getDimension() {
        return 2;
    }

    public GridCoordinates2D getLow() {
        return new GridCoordinates2D(this.x, this.y);
    }

    public GridCoordinates2D getHigh() {
        return new GridCoordinates2D(this.x + this.width - 1, this.y + this.height - 1);
    }

    public int getLow(int dimension) {
        switch (dimension) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(dimension));
    }

    public int getHigh(int dimension) {
        switch (dimension) {
            case 0: {
                return this.x + this.width - 1;
            }
            case 1: {
                return this.y + this.height - 1;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(dimension));
    }

    public int getSpan(int dimension) {
        switch (dimension) {
            case 0: {
                return this.width;
            }
            case 1: {
                return this.height;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(dimension));
    }

    @Override
    public String toString() {
        return GeneralGridEnvelope.toString(this);
    }

    @Override
    public GridEnvelope2D clone() {
        return (GridEnvelope2D)super.clone();
    }
}

