/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.tms;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.Service;
import org.geowebcache.service.ServiceException;
import org.geowebcache.service.tms.TMSDocumentFactory;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.ServletUtils;

public class TMSService
extends Service {
    public static final String SERVICE_TMS = "tms";
    private StorageBroker sb;
    private TileLayerDispatcher tld;
    private GridSetBroker gsb;
    private String baseUrl;
    private RuntimeStats stats;

    protected TMSService() {
        super(SERVICE_TMS);
    }

    public TMSService(StorageBroker sb, TileLayerDispatcher tld, GridSetBroker gsb, RuntimeStats stats) {
        super(SERVICE_TMS);
        this.sb = sb;
        this.tld = tld;
        this.gsb = gsb;
        this.stats = stats;
    }

    public void setBaseURL(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public ConveyorTile getConveyor(HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException {
        String gridSetId;
        String layerId;
        String pathInfo = request.getPathInfo();
        pathInfo = pathInfo.substring(pathInfo.indexOf("tms/1.0.0"));
        String[] params = pathInfo.split("/");
        int paramsLength = params.length;
        if (params.length < 4) {
            ConveyorTile tile = new ConveyorTile(this.sb, null, request, response);
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        long[] gridLoc = new long[3];
        String[] yExt = params[paramsLength - 1].split("\\.");
        try {
            gridLoc[0] = Integer.parseInt(params[paramsLength - 2]);
            gridLoc[1] = Integer.parseInt(yExt[0]);
            gridLoc[2] = Integer.parseInt(params[paramsLength - 3]);
        }
        catch (NumberFormatException nfe) {
            throw new ServiceException("Unable to parse number " + nfe.getMessage() + " from " + pathInfo);
        }
        String layerNameAndSRS = params[2];
        String[] lsf = ServletUtils.URLDecode((String)layerNameAndSRS, (String)request.getCharacterEncoding()).split("@");
        if (lsf.length < 3) {
            layerId = lsf[0];
            TileLayer layer = this.tld.getTileLayer(layerId);
            gridSetId = (String)layer.getGridSubsets().iterator().next();
        } else {
            layerId = lsf[0];
            gridSetId = lsf[1];
        }
        MimeType mimeType = null;
        try {
            mimeType = MimeType.createFromExtension((String)yExt[1]);
        }
        catch (MimeException me) {
            throw new ServiceException("Unable to determine requested format based on extension " + yExt[1]);
        }
        ConveyorTile ret = new ConveyorTile(this.sb, layerId, gridSetId, gridLoc, mimeType, null, request, response);
        return ret;
    }

    public void handleRequest(Conveyor conv) throws GeoWebCacheException {
        String pathInfo = conv.servletReq.getPathInfo();
        pathInfo = pathInfo.substring(pathInfo.indexOf("tms/1.0.0"));
        String[] params = pathInfo.split("/");
        int paramsLength = params.length;
        String base = this.baseUrl;
        if (base == null) {
            String reqUrl = conv.servletReq.getRequestURL().toString();
            int idx = reqUrl.indexOf("/service/tms/1.0.0");
            base = reqUrl.substring(0, idx);
        }
        TMSDocumentFactory tdf = new TMSDocumentFactory(this.tld, this.gsb, base);
        String ret = null;
        if (paramsLength < 2) {
            throw new GeoWebCacheException("Path is too short to be a valid TMS path");
        }
        if (paramsLength == 2) {
            String version = params[1];
            if (!version.equals("1.0.0")) {
                throw new GeoWebCacheException("Unknown version " + version + ", only 1.0.0 is supported.");
            }
            ret = tdf.getTileMapServiceDoc();
        } else {
            String layerNameAndSRS = params[2];
            String layerAtSRS = ServletUtils.URLDecode((String)layerNameAndSRS, (String)conv.servletReq.getCharacterEncoding());
            String[] layerSRSFormatExtension = layerAtSRS.split("@");
            TileLayer tl = this.tld.getTileLayer(layerSRSFormatExtension[0]);
            GridSubset gridSub = tl.getGridSubset(layerSRSFormatExtension[1]);
            MimeType mimeType = MimeType.createFromExtension((String)layerSRSFormatExtension[2]);
            ret = tdf.getTileMapDoc(tl, gridSub, this.gsb, mimeType);
        }
        byte[] data = ret.getBytes();
        this.stats.log(data.length, Conveyor.CacheResult.OTHER);
        conv.servletResp.setStatus(200);
        conv.servletResp.setContentType("text/xml");
        try {
            conv.servletResp.getOutputStream().write(data);
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

