/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageReader;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.opengis.feature.simple.SimpleFeature;

public abstract class PropertiesCollector {
    private List<String> propertyNames;
    private PropertiesCollectorSPI spi;
    private List<String> matches = new ArrayList<String>();

    public PropertiesCollector(PropertiesCollectorSPI spi, List<String> propertyNames) {
        this.spi = spi;
        this.propertyNames = new ArrayList<String>(propertyNames);
    }

    public PropertiesCollectorSPI getSpi() {
        return this.spi;
    }

    public PropertiesCollector collect(File file) {
        return this;
    }

    public PropertiesCollector collect(ImageReader imageReader) {
        return this;
    }

    public PropertiesCollector collect(AbstractGridCoverage2DReader abstractGridCoverageReader) {
        return this;
    }

    public abstract void setProperties(SimpleFeature var1);

    public void reset() {
        this.matches = new ArrayList<String>();
    }

    public List<String> getPropertyNames() {
        return Collections.unmodifiableList(this.propertyNames);
    }

    protected void addMatch(String match) {
        this.matches.add(match);
    }

    protected List<String> getMatches() {
        return Collections.unmodifiableList(this.matches);
    }
}

