/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.processing;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.operator.BandCombineDescriptor;
import org.geotools.util.logging.Logging;

public final class ArtifactsFilterOpImage
extends PointOpImage {
    private static final Logger LOGGER = Logging.getLogger(ArtifactsFilterOpImage.class);
    private static final double[][] RGB_TO_GRAY_MATRIX = new double[][]{{0.114, 0.587, 0.299, 0.0}};
    private static final byte FILL_VALUE = 1;
    private RoiAccessor roiAccessor;
    private RoiAccessor thresholdRoiAccessor;
    private RoiAccessor zeroRoiAccessor;
    private RandomIter iter;
    private final double[] backgroundValues;
    private final int numBands;
    private final BorderExtender sourceExtender;
    private int filterSize;

    public ArtifactsFilterOpImage(RenderedImage source, ImageLayout layout, Map<?, ?> config, ROI sourceROI, double[] backgroundValues, int threshold, int filterSize) {
        super(source, layout, config, true);
        double sourceExtensionConstant;
        RenderedImage inputRI = source;
        this.iter = RandomIterFactory.create((RenderedImage)inputRI, null);
        int tr = inputRI.getColorModel().getTransparency();
        this.numBands = this.sampleModel.getNumBands();
        this.filterSize = filterSize;
        ROI thresholdRoi = null;
        ROI zeroRoi = null;
        if (sourceROI != null) {
            RenderedImage image = inputRI;
            if (threshold != Integer.MAX_VALUE) {
                if (this.numBands == 3) {
                    image = BandCombineDescriptor.create((RenderedImage)image, (double[][])RGB_TO_GRAY_MATRIX, null);
                } else {
                    double fillValue = tr == 1 ? 1.0 / (double)this.numBands : 1.0 / (double)(this.numBands - 1);
                    double[][] matrix = new double[1][this.numBands + 1];
                    for (int i = 0; i < this.numBands; ++i) {
                        matrix[0][i] = fillValue;
                    }
                    image = BandCombineDescriptor.create((RenderedImage)image, (double[][])matrix, null);
                }
                thresholdRoi = new ROI(image, threshold);
                thresholdRoi = thresholdRoi.intersect(sourceROI);
                zeroRoi = new ROI(image, 1);
            }
        }
        this.backgroundValues = new double[this.numBands];
        if (backgroundValues == null) {
            backgroundValues = new double[]{0.0};
        }
        if (backgroundValues.length < this.numBands) {
            Arrays.fill(this.backgroundValues, backgroundValues[0]);
        } else {
            System.arraycopy(backgroundValues, 0, this.backgroundValues, 0, this.numBands);
        }
        int dataType = this.sampleModel.getDataType();
        switch (dataType) {
            case 0: {
                sourceExtensionConstant = 0.0;
                break;
            }
            case 1: {
                sourceExtensionConstant = 0.0;
                break;
            }
            case 2: {
                sourceExtensionConstant = -32768.0;
                break;
            }
            case 3: {
                sourceExtensionConstant = -2.147483648E9;
                break;
            }
            case 4: {
                sourceExtensionConstant = -3.4028234663852886E38;
                break;
            }
            default: {
                sourceExtensionConstant = -1.7976931348623157E308;
            }
        }
        this.sourceExtender = sourceExtensionConstant == 0.0 ? BorderExtender.createInstance((int)0) : new BorderExtenderConstant(new double[]{sourceExtensionConstant});
        this.roiAccessor = this.buildRoiAccessor(sourceROI);
        this.thresholdRoiAccessor = this.buildRoiAccessor(thresholdRoi);
        this.zeroRoiAccessor = this.buildRoiAccessor(zeroRoi);
    }

    private RoiAccessor buildRoiAccessor(ROI sourceROI) {
        if (sourceROI != null) {
            PlanarImage roiImage = sourceROI.getAsImage();
            RandomIter roiIter = RandomIterFactory.create((RenderedImage)roiImage, null);
            int minRoiX = roiImage.getMinX();
            int minRoiY = roiImage.getMinY();
            int roiW = roiImage.getWidth();
            int roiH = roiImage.getHeight();
            return new RoiAccessor(roiIter, sourceROI, roiImage, minRoiX, minRoiY, roiW, roiH);
        }
        return null;
    }

    public Raster computeTile(int tileX, int tileY) {
        PlanarImage source;
        WritableRaster dest = this.createWritableRaster(this.sampleModel, new Point(this.tileXToX(tileX), this.tileYToY(tileY)));
        Rectangle destRect = this.getTileRect(tileX, tileY);
        int numSources = this.getNumSources();
        Raster rasterSources = null;
        for (int i = 0; i < numSources; ++i) {
            source = this.getSourceImage(i);
            Rectangle srcRect = this.mapDestRect(destRect, i);
            rasterSources = srcRect != null && srcRect.isEmpty() ? null : source.getExtendedData(destRect, this.sourceExtender);
        }
        this.computeRect(rasterSources, dest, destRect);
        Raster sourceData = rasterSources;
        if (sourceData != null && (source = this.getSourceImage(0)).overlapsMultipleTiles(sourceData.getBounds())) {
            this.recycleTile(sourceData);
        }
        return dest;
    }

    private void computeRect(Raster sources, WritableRaster destinationRaster, Rectangle destRect) {
        if (sources == null) {
            ImageUtil.fillBackground((WritableRaster)destinationRaster, (Rectangle)destRect, (double[])this.backgroundValues);
            return;
        }
        SampleModel[] sourceSM = new SampleModel[]{sources.getSampleModel()};
        int formatTagID = RasterAccessor.findCompatibleTag((SampleModel[])sourceSM, (SampleModel)destinationRaster.getSampleModel());
        RasterAccessor rasterAccessor = new RasterAccessor((Raster)destinationRaster, destRect, new RasterFormatTag(destinationRaster.getSampleModel(), formatTagID), null);
        int dataType = rasterAccessor.getDataType();
        switch (dataType) {
            case 0: {
                this.computeRect(rasterAccessor);
                break;
            }
            default: {
                throw new UnsupportedOperationException("The following datatype isn't actually supported " + dataType);
            }
        }
        rasterAccessor.copyDataToRaster();
    }

    private synchronized void computeRect(RasterAccessor dest) {
        int dwidth = dest.getWidth();
        int dheight = dest.getHeight();
        int dnumBands = dest.getNumBands();
        byte[][] dstDataArrays = dest.getByteDataArrays();
        int[] dstBandOffsets = dest.getBandOffsets();
        int dstPixelStride = dest.getPixelStride();
        int dstScanlineStride = dest.getScanlineStride();
        int x = dest.getX();
        int y = dest.getY();
        int[][] valuess = new int[this.filterSize * this.filterSize][dnumBands];
        int min = -(this.filterSize / 2);
        int max = this.filterSize / 2;
        int[] dstPixelOffset = new int[dnumBands];
        int[] dstScanlineOffset = new int[dnumBands];
        int[] val = new int[dnumBands];
        int valueCount = 0;
        for (int k = 0; k < dnumBands; ++k) {
            dstScanlineOffset[k] = dstBandOffsets[k];
        }
        for (int j = 0; j < dheight; ++j) {
            int k;
            for (k = 0; k < dnumBands; ++k) {
                dstPixelOffset[k] = dstScanlineOffset[k];
            }
            for (int i = 0; i < dwidth; ++i) {
                block21: {
                    int k2;
                    block23: {
                        block22: {
                            boolean set;
                            int v;
                            int u;
                            boolean outsideRoi;
                            valueCount = 0;
                            for (int k3 = 0; k3 < dnumBands; ++k3) {
                                val[k3] = Integer.MIN_VALUE;
                            }
                            boolean bl = outsideRoi = !ArtifactsFilterOpImage.contains(this.roiAccessor, x + i, y + j);
                            if (outsideRoi) break block21;
                            boolean isBorder = this.isBorder(this.roiAccessor, x + i, y + j);
                            if (!isBorder) break block22;
                            if (ArtifactsFilterOpImage.contains(this.thresholdRoiAccessor, x + i, y + j)) break block23;
                            for (u = min; u <= max; ++u) {
                                for (v = min; v <= max; ++v) {
                                    set = false;
                                    if (ArtifactsFilterOpImage.contains(this.thresholdRoiAccessor, x + i + v, y + j + u)) {
                                        set = true;
                                    }
                                    if (!set) continue;
                                    this.iter.getPixel(x + i + v, y + j + u, valuess[valueCount++]);
                                }
                            }
                            if (valueCount == 0) {
                                for (u = min - 1; u <= max + 1; u += this.filterSize + 1) {
                                    for (v = min - 1; v <= max + 1; v += this.filterSize + 1) {
                                        set = false;
                                        if (ArtifactsFilterOpImage.contains(this.thresholdRoiAccessor, x + i + v, y + j + u)) {
                                            set = true;
                                        }
                                        if (!set) continue;
                                        this.iter.getPixel(x + i + v, y + j + u, valuess[valueCount++]);
                                    }
                                }
                            }
                            if (valueCount <= 0) break block23;
                            this.computeValueAtOnce(valuess, valueCount, val);
                            break block23;
                        }
                        if (!ArtifactsFilterOpImage.contains(this.zeroRoiAccessor, x + i, y + j)) {
                            for (int k4 = 0; k4 < dnumBands; ++k4) {
                                val[k4] = 1;
                            }
                        }
                    }
                    int zeros = 0;
                    for (k2 = 0; k2 < dnumBands; ++k2) {
                        if (val[k2] == Integer.MIN_VALUE) {
                            val[k2] = this.iter.getSample(x + i, y + j, k2) & 0xFF;
                        }
                        if (val[k2] != 0) continue;
                        ++zeros;
                    }
                    if (zeros == dnumBands) {
                        for (k2 = 0; k2 < dnumBands; ++k2) {
                            val[k2] = 1;
                        }
                    }
                    for (k2 = 0; k2 < dnumBands; ++k2) {
                        dstDataArrays[k2][dstPixelOffset[k2]] = (byte)val[k2];
                    }
                }
                int k5 = 0;
                while (k5 < dnumBands) {
                    int n = k5++;
                    dstPixelOffset[n] = dstPixelOffset[n] + dstPixelStride;
                }
            }
            k = 0;
            while (k < dnumBands) {
                int n = k++;
                dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
            }
        }
    }

    private void computeValueAtOnce(int[][] values, int valueCount, int[] val) {
        for (int k = 0; k < this.numBands; ++k) {
            val[k] = this.computeValueBands(values, valueCount, k);
        }
    }

    private int computeValueBands(int[][] data, int valueCount, int band) {
        int left = 0;
        int right = valueCount - 1;
        int target = valueCount / 2;
        while (true) {
            int oleft = left;
            int oright = right;
            int mid = data[(left + right) / 2][band];
            while (true) {
                if (data[left][band] < mid) {
                    ++left;
                    continue;
                }
                while (mid < data[right][band]) {
                    --right;
                }
                if (left <= right) {
                    int tmp = data[left][band];
                    data[left][band] = data[right][band];
                    data[right][band] = tmp;
                    ++left;
                    --right;
                }
                if (left > right) break;
            }
            if (oleft < right && right >= target) {
                left = oleft;
                continue;
            }
            if (left >= oright || left > target) break;
            right = oright;
        }
        return data[target][band];
    }

    private boolean isBorder(RoiAccessor roi, int dstX, int dstY) {
        int leftX = dstX - 1;
        int lowerY = dstY - 1;
        int rightX = dstX + 1;
        int upperY = dstY + 1;
        if (!ArtifactsFilterOpImage.contains(roi, leftX, lowerY)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, leftX, dstY)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, leftX, upperY)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, dstX, lowerY)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, dstX, upperY)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, rightX, lowerY)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, rightX, dstY)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, rightX, upperY)) {
            return true;
        }
        int leftX2 = dstX - 2;
        int lowerY2 = dstY - 2;
        int rightX2 = dstX + 2;
        int upperY2 = dstY + 2;
        if (!ArtifactsFilterOpImage.contains(roi, rightX2, dstY)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, leftX2, dstY)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, dstX, upperY2)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, dstX, lowerY2)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, rightX, lowerY2)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, leftX, lowerY2)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, rightX, upperY2)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, leftX, upperY2)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, rightX2, upperY)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, leftX2, upperY)) {
            return true;
        }
        if (!ArtifactsFilterOpImage.contains(roi, rightX2, lowerY)) {
            return true;
        }
        return !ArtifactsFilterOpImage.contains(roi, leftX2, lowerY);
    }

    private static final boolean contains(RoiAccessor roiAccessor, int x, int y) {
        return x >= roiAccessor.minX && x < roiAccessor.minX + roiAccessor.w && y >= roiAccessor.minY && y < roiAccessor.minY + roiAccessor.h && roiAccessor.iterator.getSample(x, y, 0) >= 1;
    }

    public void dispose() {
        super.dispose();
        if (this.roiAccessor != null) {
            this.roiAccessor.dispose();
            this.roiAccessor = null;
        }
        if (this.thresholdRoiAccessor != null) {
            this.thresholdRoiAccessor.dispose();
            this.thresholdRoiAccessor = null;
        }
        if (this.zeroRoiAccessor != null) {
            this.zeroRoiAccessor.dispose();
            this.zeroRoiAccessor = null;
        }
        this.iter.done();
    }

    class RoiAccessor {
        RandomIter iterator;
        ROI roi;
        PlanarImage image;
        int minX;
        int minY;
        int w;
        int h;

        public RoiAccessor(RandomIter iterator, ROI roi, PlanarImage image, int minX, int minY, int w, int h) {
            this.iterator = iterator;
            this.roi = roi;
            this.image = image;
            this.minX = minX;
            this.minY = minY;
            this.w = w;
            this.h = h;
        }

        public void dispose() {
            this.image.dispose();
            this.iterator.done();
            this.roi = null;
        }
    }
}

