/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GTDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.STRTreeGranuleCatalog;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;

public abstract class GranuleCatalogFactory {
    private static final Logger LOGGER = Logging.getLogger((String)"GranuleCatalogFactory");

    private GranuleCatalogFactory() {
    }

    public static GranuleCatalog createGranuleCatalog(Map<String, Serializable> params, boolean caching, boolean create, DataStoreFactorySpi spi) {
        GTDataStoreGranuleCatalog catalogue = new GTDataStoreGranuleCatalog(params, create, spi);
        if (caching) {
            return new STRTreeGranuleCatalog(catalogue);
        }
        return catalogue;
    }

    public static GranuleCatalog createGranuleCatalog(URL sourceURL, MosaicConfigurationBean configuration) {
        File sourceFile = DataUtilities.urlToFile((URL)sourceURL);
        String extension = FilenameUtils.getExtension((String)sourceFile.getAbsolutePath());
        if (extension.equalsIgnoreCase("shp")) {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put(ShapefileDataStoreFactory.URLP.key, sourceURL);
            if (sourceURL.getProtocol().equalsIgnoreCase("file")) {
                params.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, Boolean.TRUE);
            }
            params.put(ShapefileDataStoreFactory.MEMORY_MAPPED.key, Boolean.TRUE);
            params.put(ShapefileDataStoreFactory.CACHE_MEMORY_MAPS.key, Boolean.TRUE);
            params.put(ShapefileDataStoreFactory.DBFTIMEZONE.key, TimeZone.getTimeZone("UTC"));
            params.put("PathType", (Serializable)((Object)(configuration.isAbsolutePath() ? PathType.ABSOLUTE : PathType.RELATIVE)));
            params.put("LocationAttribute", (Serializable)((Object)configuration.getLocationAttribute()));
            params.put("SuggestedSPI", (Serializable)((Object)configuration.getSuggestedSPI()));
            params.put("Heterogeneous", Boolean.valueOf(configuration.isHeterogeneous()));
            File parentDirectory = DataUtilities.urlToFile((URL)sourceURL);
            if (parentDirectory.isFile()) {
                parentDirectory = parentDirectory.getParentFile();
            }
            params.put("ParentLocation", (Serializable)((Object)DataUtilities.fileToURL((File)parentDirectory).toString()));
            return configuration.isCaching() ? new STRTreeGranuleCatalog(params, Utils.SHAPE_SPI) : new GTDataStoreGranuleCatalog(params, false, Utils.SHAPE_SPI);
        }
        Properties properties = Utils.loadPropertiesFromURL(sourceURL);
        if (properties == null) {
            return null;
        }
        String SPIClass = properties.getProperty("SPI");
        try {
            DataAccessFactory.Param[] paramsInfo;
            DataStoreFactorySpi spi = (DataStoreFactorySpi)Class.forName(SPIClass).newInstance();
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            for (DataAccessFactory.Param p : paramsInfo = spi.getParametersInfo()) {
                if (properties.containsKey(p.key)) {
                    params.put(p.key, (Serializable)Converters.convert(properties.getProperty(p.key), p.type));
                    continue;
                }
                if (!p.required || p.sample != null) continue;
                throw new IOException("Required parameter missing: " + p.toString());
            }
            params.put("PathType", (Serializable)((Object)(configuration.isAbsolutePath() ? PathType.ABSOLUTE : PathType.RELATIVE)));
            params.put("LocationAttribute", (Serializable)((Object)configuration.getLocationAttribute()));
            params.put("SuggestedSPI", (Serializable)((Object)configuration.getSuggestedSPI()));
            params.put("Heterogeneous", Boolean.valueOf(configuration.isHeterogeneous()));
            if (sourceURL != null) {
                File parentDirectory = DataUtilities.urlToFile((URL)sourceURL);
                if (parentDirectory.isFile()) {
                    parentDirectory = parentDirectory.getParentFile();
                }
                params.put("ParentLocation", (Serializable)((Object)DataUtilities.fileToURL((File)parentDirectory).toString()));
            } else {
                params.put("ParentLocation", null);
            }
            return configuration.isCaching() ? new STRTreeGranuleCatalog(params, spi) : new GTDataStoreGranuleCatalog(params, false, spi);
        }
        catch (ClassNotFoundException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (InstantiationException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }
}

