/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.DecimationPolicy;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.ReadType;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class RasterLayerRequest {
    private static final Logger LOGGER = Logging.getLogger(RasterLayerRequest.class);
    private ReadType readType = (Boolean)AbstractGridFormat.USE_JAI_IMAGEREAD.getDefaultValue() != false ? ReadType.JAI_IMAGEREAD : ReadType.DIRECT_READ;
    private BoundingBox requestedBBox;
    private BoundingBox cropBBox;
    private DecimationPolicy decimationPolicy;
    private OverviewPolicy overviewPolicy;
    private Interpolation interpolation;
    private Rectangle requestedRasterArea;
    private Rectangle destinationRasterArea;
    private CoordinateReferenceSystem requestCRS;
    private boolean footprintManagement;
    private int defaultArtifactsFilterThreshold = Integer.MIN_VALUE;
    private double artifactsFilterPTileThreshold;
    private boolean setRoiProperty;
    private boolean needsReprojection = false;
    private boolean heterogeneousGranules = false;
    RasterManager rasterManager;
    private boolean empty;
    private Color inputTransparentColor = (Color)AbstractGridFormat.INPUT_TRANSPARENT_COLOR.getDefaultValue();
    private boolean blend = (Boolean)ImageMosaicFormat.FADING.getDefaultValue();
    private Color outputTransparentColor = (Color)ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getDefaultValue();
    private int maximumNumberOfGranules = (Integer)ImageMosaicFormat.MAX_ALLOWED_TILES.getDefaultValue();
    private AffineTransform requestedGridToWorld;
    private double[] requestedResolution;
    private double[] backgroundValues;
    private MathTransform destinationToSourceTransform;
    private GeneralEnvelope requestedBBOXInCoverageGeographicCRS;
    private MathTransform requestCRSToCoverageGeographicCRS2D;
    private GeneralEnvelope approximateRequestedBBoInNativeCRS;
    private Dimension tileDimensions;
    private boolean multithreadingAllowed;
    private List<?> requestedTimes;
    private List<?> elevation;
    private Filter filter = null;

    public List<?> getElevation() {
        return this.elevation;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public List<?> getRequestedTimes() {
        return this.requestedTimes;
    }

    public boolean isMultithreadingAllowed() {
        return this.multithreadingAllowed;
    }

    public DecimationPolicy getDecimationPolicy() {
        return this.decimationPolicy;
    }

    public boolean isNeedsReprojection() {
        return this.needsReprojection;
    }

    public boolean isHeterogeneousGranules() {
        return this.heterogeneousGranules;
    }

    public void setHeterogeneousGranules(boolean heterogeneousGranules) {
        this.heterogeneousGranules = heterogeneousGranules;
    }

    RasterManager getRasterManager() {
        return this.rasterManager;
    }

    public RasterLayerRequest(GeneralParameterValue[] params, RasterManager rasterManager) throws DataSourceException {
        this.rasterManager = rasterManager;
        this.heterogeneousGranules = rasterManager.heterogeneousGranules;
        this.setDefaultParameterValues();
        if (params != null) {
            for (GeneralParameterValue gParam : params) {
                if (!(gParam instanceof ParameterValue)) continue;
                ParameterValue param = (ParameterValue)gParam;
                ReferenceIdentifier name = param.getDescriptor().getName();
                this.extractParameter(param, (Identifier)name);
            }
        }
        this.checkReadType();
        this.prepare();
    }

    private void setDefaultParameterValues() {
        ParameterValueGroup readParams = this.rasterManager.parent.getFormat().getReadParameters();
        if (readParams == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("No default values for the read parameters!");
            }
            return;
        }
        List parametersDescriptors = readParams.getDescriptor().descriptors();
        for (GeneralParameterDescriptor descriptor : parametersDescriptors) {
            String[] tilesSize;
            String suggestedTileSize;
            if (!(descriptor instanceof ParameterDescriptor)) continue;
            ParameterDescriptor desc = (ParameterDescriptor)descriptor;
            ReferenceIdentifier name = desc.getName();
            Object value = desc.getDefaultValue();
            if (descriptor.getName().equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
                if (value == null) continue;
                GridGeometry2D gg = (GridGeometry2D)value;
                this.requestedBBox = new ReferencedEnvelope((Envelope)gg.getEnvelope2D());
                this.requestedRasterArea = gg.getGridRange2D().getBounds();
                this.requestedGridToWorld = (AffineTransform)gg.getGridToCRS2D();
                continue;
            }
            if (name.equals(AbstractGridFormat.USE_JAI_IMAGEREAD.getName())) {
                if (value == null) continue;
                this.readType = (Boolean)value != false ? ReadType.JAI_IMAGEREAD : ReadType.DIRECT_READ;
                continue;
            }
            if (name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName())) {
                if (value == null) continue;
                this.overviewPolicy = (OverviewPolicy)value;
                continue;
            }
            if (name.equals(AbstractGridFormat.DECIMATION_POLICY.getName())) {
                if (value == null) continue;
                this.decimationPolicy = (DecimationPolicy)value;
                continue;
            }
            if (name.equals(ImageMosaicFormat.INTERPOLATION.getName())) {
                if (value == null) continue;
                this.interpolation = (Interpolation)value;
                continue;
            }
            if (name.equals(AbstractGridFormat.INPUT_TRANSPARENT_COLOR.getName())) {
                if (value == null) continue;
                this.inputTransparentColor = (Color)value;
                this.inputTransparentColor = new Color(this.inputTransparentColor.getRed(), this.inputTransparentColor.getGreen(), this.inputTransparentColor.getBlue());
                continue;
            }
            if (name.equals(ImageMosaicFormat.FADING.getName())) {
                if (value == null) continue;
                this.blend = (Boolean)value;
                continue;
            }
            if (name.equals(ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getName())) {
                if (value == null) continue;
                this.outputTransparentColor = (Color)value;
                this.outputTransparentColor = new Color(this.outputTransparentColor.getRed(), this.outputTransparentColor.getGreen(), this.outputTransparentColor.getBlue());
                continue;
            }
            if (name.equals(ImageMosaicFormat.BACKGROUND_VALUES.getName())) {
                if (value == null) continue;
                this.backgroundValues = (double[])value;
                continue;
            }
            if (name.equals(ImageMosaicFormat.MAX_ALLOWED_TILES.getName())) {
                if (value == null) continue;
                this.maximumNumberOfGranules = (Integer)value;
                continue;
            }
            if (name.equals(ImageMosaicFormat.DEFAULT_ARTIFACTS_FILTER_THRESHOLD.getName())) {
                if (value == null) continue;
                this.defaultArtifactsFilterThreshold = (Integer)value;
                continue;
            }
            if (name.equals(ImageMosaicFormat.ARTIFACTS_FILTER_PTILE_THRESHOLD.getName())) {
                if (value == null) continue;
                this.artifactsFilterPTileThreshold = (Double)value;
                continue;
            }
            if (name.equals(ImageMosaicFormat.ALLOW_MULTITHREADING.getName())) {
                if (value == null) continue;
                this.multithreadingAllowed = (Boolean)value;
                continue;
            }
            if (name.equals(ImageMosaicFormat.HANDLE_FOOTPRINT.getName())) {
                if (value == null) continue;
                this.footprintManagement = (Boolean)value;
                continue;
            }
            if (name.equals(ImageMosaicFormat.SET_ROI_PROPERTY.getName())) {
                if (value == null) continue;
                this.setRoiProperty = (Boolean)value;
                return;
            }
            if (!name.equals(AbstractGridFormat.SUGGESTED_TILE_SIZE.getName()) || (suggestedTileSize = (String)value) == null || suggestedTileSize.trim().length() <= 0 || !suggestedTileSize.contains(",") || (tilesSize = suggestedTileSize.split(",")).length != 2) continue;
            try {
                int tileWidth = Integer.valueOf(tilesSize[0].trim());
                int tileHeight = Integer.valueOf(tilesSize[1].trim());
                this.tileDimensions = new Dimension(tileWidth, tileHeight);
            }
            catch (NumberFormatException nfe) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "Unable to parse suggested tile size parameter");
            }
        }
    }

    private void extractParameter(ParameterValue<?> param, Identifier name) {
        Object value;
        block40: {
            String[] tilesSize;
            String suggestedTileSize;
            if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
                Object value2 = param.getValue();
                if (value2 == null) {
                    return;
                }
                GridGeometry2D gg = (GridGeometry2D)value2;
                this.requestedBBox = new ReferencedEnvelope((Envelope)gg.getEnvelope2D());
                this.requestedRasterArea = gg.getGridRange2D().getBounds();
                this.requestedGridToWorld = (AffineTransform)gg.getGridToCRS2D();
                return;
            }
            if (name.equals(AbstractGridFormat.USE_JAI_IMAGEREAD.getName())) {
                Object value3 = param.getValue();
                if (value3 == null) {
                    return;
                }
                this.readType = param.booleanValue() ? ReadType.JAI_IMAGEREAD : ReadType.DIRECT_READ;
                return;
            }
            if (name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName())) {
                Object value4 = param.getValue();
                if (value4 == null) {
                    return;
                }
                this.overviewPolicy = (OverviewPolicy)value4;
                return;
            }
            if (name.equals(AbstractGridFormat.DECIMATION_POLICY.getName())) {
                Object value5 = param.getValue();
                if (value5 == null) {
                    return;
                }
                this.decimationPolicy = (DecimationPolicy)value5;
                return;
            }
            if (name.equals(ImageMosaicFormat.INTERPOLATION.getName())) {
                Object value6 = param.getValue();
                if (value6 == null) {
                    return;
                }
                this.interpolation = (Interpolation)value6;
                return;
            }
            if (name.equals(AbstractGridFormat.INPUT_TRANSPARENT_COLOR.getName())) {
                Object value7 = param.getValue();
                if (value7 == null) {
                    return;
                }
                this.inputTransparentColor = (Color)value7;
                this.inputTransparentColor = new Color(this.inputTransparentColor.getRed(), this.inputTransparentColor.getGreen(), this.inputTransparentColor.getBlue());
                return;
            }
            if (name.equals(ImageMosaicFormat.FADING.getName())) {
                Object value8 = param.getValue();
                if (value8 == null) {
                    return;
                }
                this.blend = (Boolean)value8;
                return;
            }
            if (name.equals(ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getName())) {
                Object value9 = param.getValue();
                if (value9 == null) {
                    return;
                }
                this.outputTransparentColor = (Color)value9;
                this.outputTransparentColor = new Color(this.outputTransparentColor.getRed(), this.outputTransparentColor.getGreen(), this.outputTransparentColor.getBlue());
                return;
            }
            if (name.equals(ImageMosaicFormat.BACKGROUND_VALUES.getName())) {
                Object value10 = param.getValue();
                if (value10 == null) {
                    return;
                }
                this.backgroundValues = (double[])value10;
                return;
            }
            if (name.equals(ImageMosaicFormat.MAX_ALLOWED_TILES.getName())) {
                Object value11 = param.getValue();
                if (value11 == null) {
                    return;
                }
                this.maximumNumberOfGranules = param.intValue();
                return;
            }
            if (name.equals(ImageMosaicFormat.DEFAULT_ARTIFACTS_FILTER_THRESHOLD.getName())) {
                Object value12 = param.getValue();
                if (value12 == null) {
                    return;
                }
                this.defaultArtifactsFilterThreshold = param.intValue();
                return;
            }
            if (name.equals(ImageMosaicFormat.ARTIFACTS_FILTER_PTILE_THRESHOLD.getName())) {
                Object value13 = param.getValue();
                if (value13 == null) {
                    return;
                }
                this.artifactsFilterPTileThreshold = param.doubleValue();
                return;
            }
            if (name.equals(ImageMosaicFormat.ALLOW_MULTITHREADING.getName())) {
                Object value14 = param.getValue();
                if (value14 == null) {
                    return;
                }
                this.multithreadingAllowed = (Boolean)value14;
                return;
            }
            if (name.equals(ImageMosaicFormat.HANDLE_FOOTPRINT.getName())) {
                Object value15 = param.getValue();
                if (value15 == null) {
                    return;
                }
                this.footprintManagement = (Boolean)value15;
                return;
            }
            if (name.equals(ImageMosaicFormat.SET_ROI_PROPERTY.getName())) {
                Object value16 = param.getValue();
                if (value16 == null) {
                    return;
                }
                this.setRoiProperty = (Boolean)value16;
                return;
            }
            if (name.equals(AbstractGridFormat.SUGGESTED_TILE_SIZE.getName()) && (suggestedTileSize = (String)param.getValue()) != null && suggestedTileSize.trim().length() > 0 && suggestedTileSize.contains(",") && (tilesSize = suggestedTileSize.split(",")).length == 2) {
                try {
                    int tileWidth = Integer.valueOf(tilesSize[0].trim());
                    int tileHeight = Integer.valueOf(tilesSize[1].trim());
                    this.tileDimensions = new Dimension(tileWidth, tileHeight);
                }
                catch (NumberFormatException nfe) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block40;
                    LOGGER.log(Level.WARNING, "Unable to parse suggested tile size parameter");
                }
            }
        }
        if (name.equals(ImageMosaicFormat.TIME.getName())) {
            value = param.getValue();
            if (value == null) {
                return;
            }
            List dates = (List)value;
            if (dates == null || dates.size() <= 0) {
                return;
            }
            this.requestedTimes = dates;
            return;
        }
        if (name.equals(ImageMosaicFormat.ELEVATION.getName())) {
            value = param.getValue();
            if (value == null) {
                return;
            }
            this.elevation = (List)value;
            return;
        }
        if (name.equals(ImageMosaicFormat.FILTER.getName())) {
            value = param.getValue();
            if (value == null) {
                return;
            }
            this.filter = (Filter)value;
            return;
        }
    }

    private void prepare() throws DataSourceException {
        if (this.requestedBBox == null) {
            this.requestedBBox = this.rasterManager.spatialDomainManager.coverageBBox;
            this.cropBBox = this.rasterManager.spatialDomainManager.coverageBBox;
            this.requestedRasterArea = (Rectangle)this.rasterManager.spatialDomainManager.coverageRasterArea.clone();
            this.destinationRasterArea = (Rectangle)this.rasterManager.spatialDomainManager.coverageRasterArea.clone();
            this.requestedResolution = (double[])this.rasterManager.spatialDomainManager.coverageFullResolution.clone();
            this.requestedGridToWorld = (AffineTransform)this.rasterManager.spatialDomainManager.coverageGridToWorld2D;
            return;
        }
        this.computeRequestSpatialElements();
    }

    private void inspectCoordinateReferenceSystems() throws DataSourceException {
        this.requestCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.requestedBBox.getCoordinateReferenceSystem());
        if (!CRS.equalsIgnoreMetadata((Object)this.requestCRS, (Object)this.rasterManager.spatialDomainManager.coverageCRS2D)) {
            try {
                this.destinationToSourceTransform = CRS.findMathTransform((CoordinateReferenceSystem)this.requestCRS, (CoordinateReferenceSystem)this.rasterManager.spatialDomainManager.coverageCRS2D, (boolean)true);
            }
            catch (FactoryException e) {
                throw new DataSourceException("Unable to inspect request CRS", e);
            }
        }
        if (this.destinationToSourceTransform != null && this.destinationToSourceTransform.isIdentity()) {
            this.destinationToSourceTransform = null;
        } else if (this.destinationToSourceTransform instanceof AffineTransform) {
            this.needsReprojection = true;
            AffineTransform mutableTransform = (AffineTransform)this.requestedGridToWorld.clone();
            mutableTransform.preConcatenate((AffineTransform)this.destinationToSourceTransform);
            try {
                MathTransform tempTransform = PixelTranslation.translate((MathTransform)ProjectiveTransform.create((AffineTransform)mutableTransform), (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER);
                this.requestedBBox = new ReferencedEnvelope((Envelope)CRS.transform((MathTransform)tempTransform, (Envelope)new GeneralEnvelope((Rectangle2D)this.requestedRasterArea)));
            }
            catch (MismatchedDimensionException e) {
                throw new DataSourceException("Unable to inspect request CRS", e);
            }
            catch (TransformException e) {
                throw new DataSourceException("Unable to inspect request CRS", e);
            }
            this.destinationToSourceTransform = null;
        }
    }

    private void checkReadType() {
        Object o;
        if (this.readType != ReadType.UNSPECIFIED) {
            return;
        }
        Hints hints = this.rasterManager.getHints();
        if (hints != null && (o = hints.get((Object)Hints.USE_JAI_IMAGEREAD)) != null) {
            this.readType = (ReadType)((Object)o);
        }
        this.readType = ReadType.getDefault();
    }

    private void computeCropRasterArea() throws DataSourceException {
        MathTransform2D requestedWorldToGrid;
        if (this.cropBBox == null) {
            this.destinationRasterArea = null;
            return;
        }
        try {
            requestedWorldToGrid = (MathTransform2D)PixelTranslation.translate((MathTransform)ProjectiveTransform.create((AffineTransform)this.requestedGridToWorld), (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER).inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new DataSourceException(e);
        }
        if (this.destinationToSourceTransform == null || this.destinationToSourceTransform.isIdentity()) {
            try {
                this.destinationRasterArea = new GeneralGridEnvelope((Envelope)CRS.transform((MathTransform)requestedWorldToGrid, (Envelope)new GeneralEnvelope((Envelope)this.cropBBox)), PixelInCell.CELL_CORNER, false).toRectangle();
            }
            catch (IllegalStateException e) {
                throw new DataSourceException(e);
            }
            catch (TransformException e) {
                throw new DataSourceException(e);
            }
        }
        try {
            GeneralEnvelope cropBBOXInRequestCRS = CRS.transform((MathTransform)this.destinationToSourceTransform.inverse(), (Envelope)this.cropBBox);
            cropBBOXInRequestCRS.setCoordinateReferenceSystem(this.requestedBBox.getCoordinateReferenceSystem());
            cropBBOXInRequestCRS.intersect((Envelope)this.requestedBBox);
            this.destinationRasterArea = new GeneralGridEnvelope((Envelope)CRS.transform((MathTransform)requestedWorldToGrid, (Envelope)cropBBOXInRequestCRS), PixelInCell.CELL_CORNER, false).toRectangle();
            XRectangle2D.intersect((Rectangle2D)this.destinationRasterArea, (Rectangle2D)this.requestedRasterArea, (Rectangle2D)this.destinationRasterArea);
        }
        catch (NoninvertibleTransformException e) {
            throw new DataSourceException(e);
        }
        catch (TransformException e) {
            throw new DataSourceException(e);
        }
        if (this.destinationRasterArea.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Requested envelope too small resulting in empty cropped raster region. cropBbox:" + this.cropBBox);
            }
            this.empty = true;
            return;
        }
    }

    private void computeRequestSpatialElements() throws DataSourceException {
        this.inspectCoordinateReferenceSystems();
        this.computeCropBBOX();
        if (this.empty || this.cropBBox != null && this.cropBBox.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "RequestedBBox empty or null");
            }
            this.empty = true;
            return;
        }
        this.computeCropRasterArea();
        if (this.empty || this.destinationRasterArea != null && this.destinationRasterArea.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "CropRasterArea empty or null");
            }
            return;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            StringBuilder sb = new StringBuilder("Adjusted Requested Envelope = ").append(this.requestedBBox.toString()).append("\n").append("Requested raster dimension = ").append(this.requestedRasterArea.toString()).append("\n").append("Corresponding raster source region = ").append(this.requestedRasterArea.toString());
            LOGGER.log(Level.FINER, sb.toString());
        }
        this.computeRequestedResolution();
    }

    private void computeRequestedResolution() throws DataSourceException {
        try {
            if (this.requestedGridToWorld instanceof LinearTransform) {
                if (this.destinationToSourceTransform != null && !this.destinationToSourceTransform.isIdentity()) {
                    this.requestedResolution = null;
                    GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(this.destinationRasterArea), (Envelope)this.cropBBox);
                    AffineTransform tempTransform = geMapper.createAffineTransform();
                    this.requestedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)tempTransform), XAffineTransform.getScaleY0((AffineTransform)tempTransform)};
                } else {
                    this.requestedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)this.requestedGridToWorld), XAffineTransform.getScaleY0((AffineTransform)this.requestedGridToWorld)};
                }
            } else {
                throw new UnsupportedOperationException(Errors.format((int)205, (Object)this.requestedGridToWorld.toString()));
            }
            return;
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to compute requested resolution", e);
            }
            LOGGER.log(Level.WARNING, "Unable to compute requested resolution, using highest available");
            this.requestedResolution = this.rasterManager.spatialDomainManager.coverageFullResolution;
            return;
        }
    }

    private void computeCropBBOX() throws DataSourceException {
        if (this.requestCRS == null) {
            this.requestCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.requestedBBox.getCoordinateReferenceSystem());
        }
        try {
            if (this.destinationToSourceTransform != null && !this.destinationToSourceTransform.isIdentity()) {
                GeneralEnvelope temp = CRS.transform((MathTransform)this.destinationToSourceTransform, (Envelope)this.requestedBBox);
                temp.setCoordinateReferenceSystem(this.rasterManager.spatialDomainManager.coverageCRS2D);
                this.cropBBox = new ReferencedEnvelope((Envelope)temp);
                this.needsReprojection = true;
            } else {
                this.cropBBox = new ReferencedEnvelope(this.requestedBBox.getMinX(), this.requestedBBox.getMaxX(), this.requestedBBox.getMinY(), this.requestedBBox.getMaxY(), this.rasterManager.spatialDomainManager.coverageCRS2D);
            }
            if (!this.cropBBox.intersects((BoundingBox)this.rasterManager.spatialDomainManager.coverageBBox)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("The computed CropBoundingBox " + this.cropBBox + " Doesn't intersect the coverage BoundingBox " + this.rasterManager.spatialDomainManager.coverageBBox + " resulting in an empty request");
                }
                this.cropBBox = null;
                this.empty = true;
                return;
            }
            this.cropBBox = new ReferencedEnvelope(((ReferencedEnvelope)this.cropBBox).intersection(this.rasterManager.spatialDomainManager.coverageBBox), this.rasterManager.spatialDomainManager.coverageCRS2D);
            return;
        }
        catch (TransformException te) {
            block17: {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                }
                try {
                    if (this.rasterManager.spatialDomainManager.coverageGeographicCRS2D != null && this.rasterManager.spatialDomainManager.coverageGeographicBBox != null) {
                        if (!CRS.equalsIgnoreMetadata((Object)this.rasterManager.spatialDomainManager.coverageGeographicCRS2D, (Object)this.requestCRS)) {
                            this.requestCRSToCoverageGeographicCRS2D = CRS.findMathTransform((CoordinateReferenceSystem)this.requestCRS, (CoordinateReferenceSystem)this.rasterManager.spatialDomainManager.coverageGeographicCRS2D, (boolean)true);
                            if (!this.requestCRSToCoverageGeographicCRS2D.isIdentity()) {
                                this.requestedBBOXInCoverageGeographicCRS = CRS.transform((MathTransform)this.requestCRSToCoverageGeographicCRS2D, (Envelope)this.requestedBBox);
                                this.requestedBBOXInCoverageGeographicCRS.setCoordinateReferenceSystem(this.rasterManager.spatialDomainManager.coverageGeographicCRS2D);
                            }
                        }
                        if (this.requestedBBOXInCoverageGeographicCRS == null) {
                            this.requestedBBOXInCoverageGeographicCRS = new GeneralEnvelope(this.requestCRS);
                        }
                        if (!this.requestedBBOXInCoverageGeographicCRS.intersects((Envelope)this.rasterManager.spatialDomainManager.coverageGeographicBBox, true)) {
                            this.cropBBox = null;
                            this.empty = true;
                            return;
                        }
                        this.requestedBBOXInCoverageGeographicCRS.intersect((Envelope)this.rasterManager.spatialDomainManager.coverageGeographicBBox);
                        this.requestedBBOXInCoverageGeographicCRS.setCoordinateReferenceSystem(this.rasterManager.spatialDomainManager.coverageGeographicCRS2D);
                        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)this.requestedBBOXInCoverageGeographicCRS.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.rasterManager.spatialDomainManager.coverageCRS2D, (boolean)true);
                        this.approximateRequestedBBoInNativeCRS = CRS.transform((MathTransform)transform, (Envelope)this.requestedBBOXInCoverageGeographicCRS);
                        this.approximateRequestedBBoInNativeCRS.setCoordinateReferenceSystem(this.rasterManager.spatialDomainManager.coverageCRS2D);
                        this.cropBBox = new ReferencedEnvelope((Envelope)this.approximateRequestedBBoInNativeCRS);
                        return;
                    }
                }
                catch (TransformException te2) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, te2.getLocalizedMessage(), te2);
                    }
                }
                catch (FactoryException fe) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block17;
                    LOGGER.log(Level.FINE, fe.getLocalizedMessage(), fe);
                }
            }
            LOGGER.log(Level.INFO, "We did not manage to crop the requested envelope, we fall back onto loading the whole coverage.");
            this.cropBBox = null;
            return;
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public BoundingBox getRequestedBBox() {
        return this.requestedBBox;
    }

    public OverviewPolicy getOverviewPolicy() {
        return this.overviewPolicy;
    }

    public Rectangle getRequestedRasterArea() {
        return (Rectangle)(this.requestedRasterArea != null ? this.requestedRasterArea.clone() : this.requestedRasterArea);
    }

    public double[] getRequestedResolution() {
        return this.requestedResolution != null ? (double[])this.requestedResolution.clone() : null;
    }

    public Color getInputTransparentColor() {
        return this.inputTransparentColor;
    }

    public Color getOutputTransparentColor() {
        return this.outputTransparentColor;
    }

    public int getMaximumNumberOfGranules() {
        return this.maximumNumberOfGranules;
    }

    public boolean isFootprintManagement() {
        return this.footprintManagement;
    }

    public int getDefaultArtifactsFilterThreshold() {
        return this.defaultArtifactsFilterThreshold;
    }

    public double getArtifactsFilterPTileThreshold() {
        return this.artifactsFilterPTileThreshold;
    }

    public boolean isSetRoiProperty() {
        return this.setRoiProperty;
    }

    public boolean isBlend() {
        return this.blend;
    }

    public ReadType getReadType() {
        return this.readType;
    }

    public double[] getBackgroundValues() {
        return this.backgroundValues;
    }

    public void setInterpolation(Interpolation interpolation) {
        this.interpolation = interpolation;
    }

    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    public Rectangle getDestinationRasterArea() {
        return this.destinationRasterArea;
    }

    public BoundingBox getCropBBox() {
        return this.cropBBox;
    }

    public AffineTransform getRequestedGridToWorld() {
        return this.requestedGridToWorld;
    }

    public Dimension getTileDimensions() {
        return this.tileDimensions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RasterLayerRequest description: \n");
        builder.append("\tRequestedBBox=").append(this.requestedBBox).append("\n");
        builder.append("\tRequestedRasterArea=").append(this.requestedRasterArea).append("\n");
        builder.append("\tRequestedGridToWorld=").append(this.requestedGridToWorld).append("\n");
        builder.append("\tReadType=").append((Object)this.readType);
        return builder.toString();
    }
}

