/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.DataSourceException;
import org.geotools.data.ResourceInfo;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureTypes;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapefileURLResourceInfo
implements ResourceInfo {
    private ShapefileDataStore shapefile;

    public ShapefileURLResourceInfo(ShapefileDataStore shapefile) {
        this.shapefile = shapefile;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        try {
            return this.shapefile.getBounds();
        }
        catch (DataSourceException e) {
            return new ReferencedEnvelope(this.getCRS());
        }
    }

    @Override
    public CoordinateReferenceSystem getCRS() {
        return this.shapefile.schema.getCoordinateReferenceSystem();
    }

    @Override
    public String getDescription() {
        return "Contents of shapefile";
    }

    @Override
    public Set<String> getKeywords() {
        HashSet<String> words = new HashSet<String>();
        words.add(this.shapefile.getCurrentTypeName());
        words.add("features");
        return words;
    }

    @Override
    public String getName() {
        return this.shapefile.getCurrentTypeName();
    }

    @Override
    public URI getSchema() {
        return FeatureTypes.DEFAULT_NAMESPACE;
    }

    @Override
    public String getTitle() {
        return this.shapefile.getCurrentTypeName();
    }
}

