/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.storage;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.diskquota.storage.PagePyramid;
import org.geowebcache.diskquota.storage.TilePage;
import org.geowebcache.diskquota.storage.TileSet;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilePageCalculator {
    private TileLayerDispatcher tld;

    public TilePageCalculator(TileLayerDispatcher tld) {
        this.tld = tld;
    }

    public TilePage pageForTile(TileSet tileSet, long[] tileIndex) {
        int[] pageIndexForTile = new int[3];
        this.pageIndexForTile(tileSet, tileIndex, null);
        String tileSetId = tileSet.getId();
        int pageX = pageIndexForTile[0];
        int pageY = pageIndexForTile[1];
        byte zoomLevel = (byte)pageIndexForTile[2];
        return new TilePage(tileSetId, pageX, pageY, zoomLevel);
    }

    public int[] pageIndexForTile(TileSet tileSet, long[] tileIndex, int[] pageIndexTarget) {
        Assert.notNull((Object)tileSet);
        Assert.notNull((Object)tileIndex);
        Assert.isTrue((pageIndexTarget != null && pageIndexTarget.length > 2 ? 1 : 0) != 0);
        PagePyramid pagePyramid = this.getPagePyramid(tileSet);
        pagePyramid.pageIndexForTile(tileIndex[0], tileIndex[1], (int)tileIndex[2], pageIndexTarget);
        return pageIndexTarget;
    }

    private PagePyramid getPagePyramid(TileSet tileSet) {
        PagePyramid pagePyramid = this.newPagePyramid(tileSet);
        return pagePyramid;
    }

    public BigInteger getTilesPerPage(TileSet tileSet, int zoomLevel) {
        PagePyramid pagePyramid = this.getPagePyramid(tileSet);
        PagePyramid.PageLevelInfo pageInfo = pagePyramid.getPageInfo(zoomLevel);
        BigInteger tilesPerPage = pageInfo.tilesPerPage;
        return tilesPerPage;
    }

    public long[][] toGridCoverage(TileSet tileSet, TilePage page) {
        PagePyramid pagePyramid = this.getPagePyramid(tileSet);
        int pageX = page.getPageX();
        int pageY = page.getPageY();
        byte level = page.getZoomLevel();
        long[][] gridCoverage = pagePyramid.toGridCoverage(pageX, pageY, level);
        return gridCoverage;
    }

    public Set<String> getLayerNames() {
        return this.tld.getLayerNames();
    }

    public Set<TileSet> getTileSetsFor(String layerName) {
        TileLayer tileLayer;
        try {
            tileLayer = this.tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            throw new IllegalArgumentException(e);
        }
        ArrayList<GridSubset> gridSubSets = new ArrayList<GridSubset>();
        for (String gridSetId : tileLayer.getGridSubsets()) {
            GridSubset subset = tileLayer.getGridSubset(gridSetId);
            gridSubSets.add(subset);
        }
        List mimeTypes = tileLayer.getMimeTypes();
        return this.getTileSetsFor(layerName, gridSubSets, mimeTypes);
    }

    public Set<TileSet> getTileSetsFor(String layerName, Collection<GridSubset> gridSubSets, List<MimeType> mimeTypes) {
        HashSet<TileSet> layerTileSets = new HashSet<TileSet>();
        Long parametersId = null;
        for (GridSubset gridSubset : gridSubSets) {
            String gridsetId = gridSubset.getName();
            for (MimeType mime : mimeTypes) {
                String blobFormat = mime.getFormat();
                TileSet tileSet = new TileSet(layerName, gridsetId, blobFormat, parametersId);
                layerTileSets.add(tileSet);
            }
        }
        return layerTileSets;
    }

    private PagePyramid newPagePyramid(TileSet tileSet) {
        TileLayer tileLayer;
        String layerName = tileSet.getLayerName();
        try {
            tileLayer = this.tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            throw new IllegalArgumentException(e);
        }
        String gridsetId = tileSet.getGridsetId();
        GridSubset gridSubset = tileLayer.getGridSubset(gridsetId);
        return this.newPagePyramid(gridSubset);
    }

    PagePyramid newPagePyramid(GridSubset gridSubset) {
        int zoomStart = gridSubset.getZoomStart();
        int zoomStop = gridSubset.getZoomStop();
        long[][] coverages = gridSubset.getCoverages();
        PagePyramid pagePyramid = new PagePyramid(coverages, zoomStart, zoomStop);
        return pagePyramid;
    }
}

