/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.storage;

import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum StorageUnit {
    B(BigDecimal.ONE),
    KiB(StorageUnit.B.bytes.multiply(BigDecimal.valueOf(1024L))),
    MiB(StorageUnit.KiB.bytes.multiply(BigDecimal.valueOf(1024L))),
    GiB(StorageUnit.MiB.bytes.multiply(BigDecimal.valueOf(1024L))),
    TiB(StorageUnit.GiB.bytes.multiply(BigDecimal.valueOf(1024L))),
    PiB(StorageUnit.TiB.bytes.multiply(BigDecimal.valueOf(1024L))),
    EiB(StorageUnit.PiB.bytes.multiply(BigDecimal.valueOf(1024L))),
    ZiB(StorageUnit.EiB.bytes.multiply(BigDecimal.valueOf(1024L))),
    YiB(StorageUnit.ZiB.bytes.multiply(BigDecimal.valueOf(1024L)));

    private final BigDecimal bytes;

    private StorageUnit(BigDecimal bytes) {
        this.bytes = bytes;
    }

    public final BigInteger toBytes(double value) {
        return this.toBytes(BigDecimal.valueOf(value));
    }

    public final BigInteger toBytes(BigDecimal value) {
        BigDecimal toBytes = this.bytes.multiply(value);
        return toBytes.toBigInteger();
    }

    public final BigDecimal fromBytes(BigInteger value) {
        return new BigDecimal(value).divide(this.bytes);
    }

    public BigDecimal convertTo(double value, StorageUnit target) {
        return this.convertTo(BigDecimal.valueOf(value), target);
    }

    public final BigDecimal convertTo(BigDecimal value, StorageUnit target) {
        return target.fromBytes(this.toBytes(value));
    }

    public static StorageUnit bestFit(double value, StorageUnit units) {
        return StorageUnit.bestFit(BigDecimal.valueOf(value), units);
    }

    public static StorageUnit bestFit(BigDecimal value, StorageUnit units) {
        BigDecimal bytes = new BigDecimal(units.toBytes(value));
        if (bytes.compareTo(StorageUnit.YiB.bytes) >= 0) {
            return YiB;
        }
        if (bytes.compareTo(StorageUnit.ZiB.bytes) >= 0) {
            return ZiB;
        }
        if (bytes.compareTo(StorageUnit.EiB.bytes) >= 0) {
            return EiB;
        }
        if (bytes.compareTo(StorageUnit.PiB.bytes) >= 0) {
            return PiB;
        }
        if (bytes.compareTo(StorageUnit.TiB.bytes) >= 0) {
            return TiB;
        }
        if (bytes.compareTo(StorageUnit.GiB.bytes) >= 0) {
            return GiB;
        }
        if (bytes.compareTo(StorageUnit.MiB.bytes) >= 0) {
            return MiB;
        }
        if (bytes.compareTo(StorageUnit.KiB.bytes) >= 0) {
            return KiB;
        }
        return B;
    }

    public static StorageUnit bestFit(BigInteger bytes) {
        return StorageUnit.bestFit(new BigDecimal(bytes), B);
    }

    public String toNiceString() {
        String s = this.toString();
        if (B == this) {
            return s;
        }
        return "" + s.charAt(0) + s.charAt(2);
    }
}

