/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.storage;

import com.sleepycat.persist.model.DeleteAction;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import org.geowebcache.diskquota.storage.StorageUnit;
import org.geowebcache.diskquota.storage.TileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Quota
implements Cloneable,
Comparable<Quota>,
Serializable {
    private static final long serialVersionUID = -3817255124248938529L;
    private static final NumberFormat NICE_FORMATTER = NumberFormat.getNumberInstance();
    @PrimaryKey(sequence="quota_id")
    private int id;
    @SecondaryKey(name="tileset_id", relatedEntity=TileSet.class, relate=Relationship.ONE_TO_ONE, onRelatedEntityDelete=DeleteAction.CASCADE)
    private String tileSetId;
    private BigInteger bytes;

    public Quota() {
        this(BigInteger.ZERO);
    }

    public Quota(BigInteger bytes) {
        this.bytes = bytes;
    }

    public Quota(Quota quota) {
        this.id = quota.id;
        this.tileSetId = quota.tileSetId;
        this.bytes = quota.getBytes();
    }

    int getId() {
        return this.id;
    }

    String getTileSetId() {
        return this.tileSetId;
    }

    void setTileSetId(String tileSetId) {
        this.tileSetId = tileSetId;
    }

    public BigInteger getBytes() {
        return this.bytes;
    }

    public void setBytes(BigInteger bytes) {
        this.bytes = bytes;
    }

    public void setBytes(long bytes) {
        this.setBytes(BigInteger.valueOf(bytes));
    }

    public Quota(double value, StorageUnit units) {
        this(BigDecimal.valueOf(value), units);
    }

    public Quota(BigDecimal value, StorageUnit units) {
        this.bytes = units.toBytes(value);
    }

    private Object readResolve() {
        if (this.bytes == null) {
            this.bytes = BigInteger.ZERO;
        }
        return this;
    }

    public String toString() {
        StorageUnit bestFit = StorageUnit.bestFit(this.bytes);
        BigDecimal value = StorageUnit.B.convertTo(new BigDecimal(this.bytes), bestFit);
        return NICE_FORMATTER.format(value) + bestFit.toString();
    }

    public void add(BigInteger bytes) {
        this.bytes = this.bytes.add(bytes);
    }

    public void addBytes(long bytes) {
        this.bytes = this.bytes.add(BigInteger.valueOf(bytes));
    }

    public void add(double amount, StorageUnit units) {
        this.bytes = this.bytes.add(units.toBytes(amount));
    }

    public void add(Quota quota) {
        this.bytes = this.bytes.add(quota.getBytes());
    }

    public void subtract(BigInteger bytes) {
        this.bytes = this.bytes.subtract(bytes);
    }

    public void subtract(Quota quota) {
        this.subtract(quota.getBytes());
    }

    public void subtract(double amount, StorageUnit units) {
        this.subtract(units.toBytes(amount));
    }

    public Quota difference(Quota quota) {
        BigInteger difference = this.bytes.subtract(quota.getBytes());
        return new Quota(difference);
    }

    public String toNiceString() {
        StorageUnit bestFit = StorageUnit.bestFit(this.bytes);
        BigDecimal value = StorageUnit.B.convertTo(new BigDecimal(this.bytes), bestFit);
        return NICE_FORMATTER.format(value) + ' ' + bestFit.toNiceString();
    }

    public Quota min(Quota quota) {
        BigInteger min = this.bytes.min(quota.getBytes());
        return this.bytes.equals(min) ? this : quota;
    }

    @Override
    public int compareTo(Quota o) {
        if (o == null) {
            throw new NullPointerException("Can't compare against null");
        }
        return this.bytes.compareTo(o.getBytes());
    }

    public void setValue(double value, StorageUnit unit) {
        this.setBytes(unit.convertTo(value, StorageUnit.B).toBigInteger());
    }

    public Quota clone() {
        return new Quota(this);
    }

    static {
        NICE_FORMATTER.setMinimumFractionDigits(1);
        NICE_FORMATTER.setMaximumFractionDigits(2);
    }
}

