/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.storage;

import com.sleepycat.persist.model.DeleteAction;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.geowebcache.diskquota.storage.SystemUtils;
import org.geowebcache.diskquota.storage.TilePage;

@Entity
public class PageStats
implements Serializable {
    private static final long serialVersionUID = 719776699585233200L;
    @PrimaryKey(sequence="page_stats_seq")
    private long id;
    @SecondaryKey(name="page_stats_by_page_id", relate=Relationship.ONE_TO_ONE, relatedEntity=TilePage.class, onRelatedEntityDelete=DeleteAction.CASCADE)
    private long pageId;
    @SecondaryKey(name="LFU", relate=Relationship.MANY_TO_ONE)
    private float frequencyOfUse;
    @SecondaryKey(name="LRU", relate=Relationship.MANY_TO_ONE)
    private int lastAccessTimeMinutes;
    @SecondaryKey(name="fill_factor", relate=Relationship.MANY_TO_ONE)
    private float fillFactor;
    private BigInteger numHits;

    PageStats() {
    }

    public PageStats(long pageId) {
        this.pageId = pageId;
        this.numHits = BigInteger.ZERO;
        this.lastAccessTimeMinutes = SystemUtils.get().currentTimeMinutes();
    }

    PageStats(TilePage page) {
        this(page.getId());
    }

    public void addHitsAndAccessTime(long addedHits, int lastAccessTimeMinutes, int creationTimeMinutes) {
        if (lastAccessTimeMinutes < creationTimeMinutes) {
            lastAccessTimeMinutes = creationTimeMinutes;
        }
        if (this.fillFactor <= 0.0f) {
            this.fillFactor = Float.MIN_VALUE;
        }
        this.numHits = this.numHits.add(BigInteger.valueOf(addedHits));
        BigDecimal age = new BigDecimal(1 + lastAccessTimeMinutes - creationTimeMinutes);
        this.frequencyOfUse = new BigDecimal(this.numHits).divide(age, 7, RoundingMode.CEILING).multiply(new BigDecimal(this.fillFactor)).floatValue();
        this.lastAccessTimeMinutes = lastAccessTimeMinutes;
    }

    public void addTiles(long numTiles, BigInteger maxTiles) {
        if (this.fillFactor == 1.0f && numTiles >= 0L) {
            return;
        }
        if (this.fillFactor == 0.0f && numTiles <= 0L) {
            return;
        }
        BigDecimal currFillFactor = new BigDecimal(this.fillFactor);
        BigDecimal addedTiles = new BigDecimal(numTiles);
        BigDecimal addedFillFactor = addedTiles.divide(new BigDecimal(maxTiles), 7, RoundingMode.CEILING);
        currFillFactor = currFillFactor.add(addedFillFactor);
        this.fillFactor = currFillFactor.floatValue();
        if (this.fillFactor > 1.0f) {
            this.fillFactor = 1.0f;
        } else if (this.fillFactor < 0.0f) {
            this.fillFactor = 0.0f;
        }
    }

    public float getFillFactor() {
        return this.fillFactor;
    }

    public void setFillFactor(float fillFactor) {
        this.fillFactor = fillFactor;
    }

    public int getLastAccessTimeMinutes() {
        return this.lastAccessTimeMinutes;
    }

    public void setLastAccessMinutes(int lastAccessMinutes) {
        this.lastAccessTimeMinutes = lastAccessMinutes;
    }

    public long getPageId() {
        return this.pageId;
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public float getFrequencyOfUsePerMinute() {
        return this.frequencyOfUse;
    }

    public void setFrequencyOfUsePerMinute(float lfuHotnes) {
        this.frequencyOfUse = lfuHotnes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[page: ").append(this.pageId);
        sb.append(", fillFactor: ").append(this.fillFactor);
        sb.append(", frequencyOfUse: ").append(this.frequencyOfUse);
        sb.append(", last access: ").append(SystemUtils.get().currentTimeMinutes() - this.lastAccessTimeMinutes).append("m ago]");
        return sb.toString();
    }
}

