/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.storage;

import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.util.Assert;

class PagePyramid {
    private Map<Integer, PageLevelInfo> pageInfo;
    private Map<Integer, long[]> gridSubsetCoverages = new TreeMap<Integer, long[]>();
    private final int zoomStart;
    private final int zoomStop;

    public PagePyramid(long[][] gridSubsetCoverages, int zoomStart, int zoomStop) {
        for (long[] coverage : gridSubsetCoverages) {
            this.gridSubsetCoverages.put((int)coverage[4], coverage);
        }
        this.zoomStart = zoomStart;
        this.zoomStop = zoomStop;
        this.pageInfo = new TreeMap<Integer, PageLevelInfo>();
    }

    public int getZoomStart() {
        return this.zoomStart;
    }

    public int getZoomStop() {
        return this.zoomStop;
    }

    public PageLevelInfo getPageInfo(int zoomLevel) {
        Assert.isTrue((zoomLevel >= this.zoomStart ? 1 : 0) != 0);
        Assert.isTrue((zoomLevel <= this.zoomStop ? 1 : 0) != 0);
        Integer key = zoomLevel;
        PageLevelInfo levelInfo = this.pageInfo.get(key);
        if (levelInfo == null) {
            long[] coverage = this.gridSubsetCoverages.get(key);
            levelInfo = this.calculatePageInfo(coverage);
            this.pageInfo.put(key, levelInfo);
        }
        return levelInfo;
    }

    public PageLevelInfo calculatePageInfo(long[] coverage) {
        int level = (int)coverage[4];
        long coverageMinX = coverage[0];
        long coverageMaxX = coverage[2];
        long coverageMinY = coverage[1];
        long coverageMaxY = coverage[3];
        long coverageTilesWide = 1L + coverageMaxX - coverageMinX;
        long coverageTilesHigh = 1L + coverageMaxY - coverageMinY;
        int tilesPerPageX = this.calculateNumTilesPerPage(coverageTilesWide);
        int tilesPerPageY = this.calculateNumTilesPerPage(coverageTilesHigh);
        int numPagesX = (int)Math.ceil((double)coverageTilesWide / (double)tilesPerPageX);
        int numPagesY = (int)Math.ceil((double)coverageTilesHigh / (double)tilesPerPageY);
        PageLevelInfo pli = new PageLevelInfo(numPagesX, numPagesY, tilesPerPageX, tilesPerPageY, coverageMinX, coverageMinY, coverageMaxX, coverageMaxY);
        return pli;
    }

    private int calculateNumTilesPerPage(long numTilesInAxis) {
        double logBase = 1.1;
        double log = Math.log(numTilesInAxis) / Math.log(1.1);
        int numTilesPerPage = numTilesInAxis == 1L ? 1 : (int)Math.ceil((double)numTilesInAxis / log);
        return numTilesPerPage;
    }

    public int[] pageIndexForTile(long x, long y, int level, int[] pageIndexTarget) {
        Assert.notNull((Object)pageIndexTarget);
        Assert.isTrue((pageIndexTarget.length >= 3 ? 1 : 0) != 0);
        PageLevelInfo levelInfo = this.getPageInfo(level);
        int tilePageX = (int)((x - levelInfo.coverageMinX) / (long)levelInfo.tilesPerPageX);
        int tilePageY = (int)((y - levelInfo.coverageMinY) / (long)levelInfo.tilesPerPageY);
        pageIndexTarget[0] = tilePageX;
        pageIndexTarget[1] = tilePageY;
        pageIndexTarget[2] = level;
        return pageIndexTarget;
    }

    public long[][] toGridCoverage(int pageX, int pageY, int level) {
        PageLevelInfo pageLevelInfo = this.getPageInfo(level);
        long coverageMinX = pageLevelInfo.coverageMinX;
        long coverageMinY = pageLevelInfo.coverageMinY;
        int numTilesPerPageX = pageLevelInfo.tilesPerPageX;
        int numTilesPerPageY = pageLevelInfo.tilesPerPageY;
        long minTileX = coverageMinX + (long)pageX * (long)numTilesPerPageX;
        long minTileY = coverageMinY + (long)pageY * (long)numTilesPerPageY;
        long maxTileX = minTileX + (long)numTilesPerPageX - 1L;
        long maxTileY = minTileY + (long)numTilesPerPageY - 1L;
        long[] pageCoverage = new long[]{minTileX, minTileY, maxTileX, maxTileY, level};
        int numLevels = this.gridSubsetCoverages.size();
        long[][] allLevelsCoverage = new long[numLevels][];
        allLevelsCoverage[level] = pageCoverage;
        return allLevelsCoverage;
    }

    public int getTilesPerPageX(int level) {
        return this.getPageInfo((int)level).tilesPerPageX;
    }

    public int getTilesPerPageY(int level) {
        return this.getPageInfo((int)level).tilesPerPageY;
    }

    public int getPagesPerLevelX(int level) {
        return this.getPageInfo((int)level).pagesX;
    }

    public int getPagesPerLevelY(int level) {
        return this.getPageInfo((int)level).pagesY;
    }

    public static final class PageLevelInfo {
        public final int pagesX;
        public final int pagesY;
        public final int tilesPerPageX;
        public final int tilesPerPageY;
        public final BigInteger tilesPerPage;
        public final long coverageMinX;
        public final long coverageMinY;
        public final long coverageMaxX;
        public final long coverageMaxY;

        public PageLevelInfo(int pagesX, int pagesY, int tilesPerPageX, int tilesPerPageY, long coverageMinX, long coverageMinY, long coverageMaxX, long coverageMaxY) {
            this.pagesX = pagesX;
            this.pagesY = pagesY;
            this.tilesPerPageX = tilesPerPageX;
            this.tilesPerPageY = tilesPerPageY;
            this.tilesPerPage = BigInteger.valueOf(tilesPerPageX).multiply(BigInteger.valueOf(tilesPerPageY));
            this.coverageMinX = coverageMinX;
            this.coverageMinY = coverageMinY;
            this.coverageMaxX = coverageMaxX;
            this.coverageMaxY = coverageMaxY;
        }

        public String toString() {
            NumberFormat nf = NumberFormat.getInstance(new Locale("es"));
            nf.setGroupingUsed(true);
            return "Pages: " + this.pagesX + " x " + this.pagesY + " (" + nf.format(this.pagesX * this.pagesY) + "), " + "tiles:" + this.tilesPerPageX + " x " + this.tilesPerPageY + " (" + nf.format((long)this.tilesPerPageX * (long)this.tilesPerPageY) + ")";
        }
    }
}

