/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.QueuedQuotaUpdatesConsumer;
import org.geowebcache.diskquota.QueuedQuotaUpdatesProducer;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.QuotaUpdate;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.StorageBroker;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;

public class QuotaUpdatesMonitor {
    private static final Log log = LogFactory.getLog(QuotaUpdatesMonitor.class);
    private static final CustomizableThreadFactory tf = new CustomizableThreadFactory("GWC DiskQuota Updates Gathering Thread-");
    private final DiskQuotaConfig quotaConfig;
    private final StorageBroker storageBroker;
    private final QuotaStore quotaStore;
    private ExecutorService executorService;
    private BlockingQueue<QuotaUpdate> sharedQueue;
    private QueuedQuotaUpdatesProducer quotaDiffsProducer;
    private QueuedQuotaUpdatesConsumer quotaUsageUpdatesConsumer;

    public QuotaUpdatesMonitor(DiskQuotaConfig quotaConfig, StorageBroker storageBroker, QuotaStore quotaStore) {
        Assert.notNull((Object)quotaConfig, (String)"quotaConfig is null");
        Assert.notNull((Object)storageBroker, (String)"storageBroker is null");
        Assert.notNull((Object)quotaStore, (String)"quotaStore is null");
        this.quotaConfig = quotaConfig;
        this.storageBroker = storageBroker;
        this.quotaStore = quotaStore;
    }

    public void startUp() {
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)tf);
        this.sharedQueue = new LinkedBlockingQueue<QuotaUpdate>(1000);
        this.quotaDiffsProducer = new QueuedQuotaUpdatesProducer(this.quotaConfig, this.sharedQueue, this.quotaStore);
        this.quotaUsageUpdatesConsumer = new QueuedQuotaUpdatesConsumer(this.quotaStore, this.sharedQueue);
        this.storageBroker.addBlobStoreListener((BlobStoreListener)this.quotaDiffsProducer);
        this.executorService.submit(this.quotaUsageUpdatesConsumer);
    }

    private void shutDown(boolean cancel) {
        log.info((Object)"Shutting down quota usage monitor...");
        try {
            this.storageBroker.removeBlobStoreListener((BlobStoreListener)this.quotaDiffsProducer);
        }
        catch (RuntimeException e) {
            log.error((Object)"Unexpected exception while removing the disk quota monitor listener from the StorageBroker. Ignoring in order to continue with the monitor's shutdown process", (Throwable)e);
        }
        if (cancel) {
            this.quotaDiffsProducer.setCancelled(true);
            this.executorService.shutdownNow();
        } else {
            this.executorService.shutdown();
        }
        this.sharedQueue = null;
    }

    public void shutDownNow() {
        this.shutDown(true);
    }

    public void shutDown() {
        boolean cancel = false;
        this.shutDown(false);
        int maxAttempts = 6;
        int seconds = 5;
        int attempts = 1;
        while (!this.executorService.isTerminated()) {
            ++attempts;
            try {
                this.awaitTermination(5, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                String message = "Usage statistics thread helper for DiskQuota failed to shutdown within " + attempts * 5 + " seconds. Attempt " + attempts + " of " + 6 + "...";
                log.warn((Object)message);
                if (attempts != 6) continue;
                throw new RuntimeException(message, e);
            }
        }
    }

    public void tileStored(String layerName, String gridSetId, String blobFormat, Long parametersId, long x, long y, int z, long blobSize) {
        this.quotaDiffsProducer.tileStored(layerName, gridSetId, blobFormat, parametersId, x, y, z, blobSize);
    }

    public void awaitTermination(int timeout, TimeUnit units) throws InterruptedException {
        if (!this.executorService.isShutdown()) {
            throw new IllegalStateException("Called awaitTermination but the UsageStatsMonitor is not shutting down");
        }
        this.executorService.awaitTermination(10000L, TimeUnit.MILLISECONDS);
    }
}

