/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.diskquota.CacheCleaner;
import org.geowebcache.diskquota.CacheCleanerTask;
import org.geowebcache.diskquota.ConfigLoader;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.ExpirationPolicy;
import org.geowebcache.diskquota.LayerCacheInfoBuilder;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.QuotaUpdatesMonitor;
import org.geowebcache.diskquota.UsageStatsMonitor;
import org.geowebcache.diskquota.storage.LayerQuota;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageBroker;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskQuotaMonitor
implements InitializingBean,
DisposableBean {
    private static final Log log = LogFactory.getLog(DiskQuotaMonitor.class);
    public static final String GWC_DISKQUOTA_DISABLED = "GWC_DISKQUOTA_DISABLED";
    private final TileLayerDispatcher tileLayerDispatcher;
    private final StorageBroker storageBroker;
    private final CacheCleaner cacheCleaner;
    private final ConfigLoader configLoader;
    private DiskQuotaConfig quotaConfig;
    private LayerCacheInfoBuilder cacheInfoBuilder;
    private QuotaStore quotaStore;
    private ScheduledExecutorService cleanUpExecutorService;
    private QuotaUpdatesMonitor quotaUsageMonitor;
    private UsageStatsMonitor usageStatsMonitor;
    private volatile boolean isRunning;
    private final DefaultStorageFinder storageFinder;
    private boolean diskQuotaEnabled;

    public DiskQuotaMonitor(DefaultStorageFinder storageFinder, ConfigLoader configLoader, TileLayerDispatcher tld, StorageBroker sb, QuotaStore quotaStore, CacheCleaner cacheCleaner) throws IOException, ConfigurationException {
        boolean disabled = Boolean.valueOf(storageFinder.findEnvVar(GWC_DISKQUOTA_DISABLED));
        if (disabled) {
            log.warn((Object)" -- Found environment variable GWC_DISKQUOTA_DISABLED set to true. DiskQuotaMonitor is disabled.");
        }
        this.diskQuotaEnabled = !disabled;
        this.storageFinder = storageFinder;
        this.configLoader = configLoader;
        this.storageBroker = sb;
        this.tileLayerDispatcher = tld;
        this.quotaStore = quotaStore;
        this.cacheCleaner = cacheCleaner;
    }

    public boolean isEnabled() {
        return this.diskQuotaEnabled;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.diskQuotaEnabled) {
            return;
        }
        this.startUp();
    }

    public void destroy() throws Exception {
        if (!this.diskQuotaEnabled) {
            return;
        }
        this.shutDown(30);
    }

    public void startUp() throws ConfigurationException {
        Assert.isTrue((boolean)this.diskQuotaEnabled, (String)"startUp called but DiskQuotaMonitor is disabled!");
        Assert.isTrue((!this.isRunning ? 1 : 0) != 0, (String)"DiskQuotaMonitor is already running");
        try {
            this.startUpInternal();
            this.isRunning = true;
        }
        catch (InterruptedException e) {
            log.info((Object)"DiskQuotaMonitor startup process interrupted", (Throwable)e);
        }
    }

    private void startUpInternal() throws InterruptedException, ConfigurationException {
        try {
            this.quotaConfig = this.configLoader.loadConfig();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.quotaUsageMonitor = new QuotaUpdatesMonitor(this.quotaConfig, this.storageBroker, this.quotaStore);
        this.usageStatsMonitor = new UsageStatsMonitor(this.quotaStore, this.tileLayerDispatcher);
        if (this.cleanUpExecutorService != null) {
            log.info((Object)"Shutting down clean up executor service...");
            this.cleanUpExecutorService.shutdownNow();
        }
        this.cleanUpExecutorService = this.createCleanUpExecutor();
        this.attachConfiguredLayers();
        this.quotaUsageMonitor.startUp();
        this.usageStatsMonitor.startUp();
        this.setUpScheduledCleanUp();
        this.cacheInfoBuilder = this.launchCacheInfoGatheringThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown(int timeOutSecs) throws InterruptedException {
        Assert.isTrue((boolean)this.diskQuotaEnabled, (String)"shutDown called but DiskQuotaMonitor is disabled!");
        Assert.isTrue((timeOutSecs > 0 ? 1 : 0) != 0, (String)("timeOut for shutdown must be > 0: " + timeOutSecs));
        try {
            log.info((Object)"Disk quota monitor shutting down...");
            if (this.cacheInfoBuilder != null) {
                this.cacheInfoBuilder.shutDown();
            }
            if (this.cleanUpExecutorService != null) {
                this.cleanUpExecutorService.shutdownNow();
            }
            log.info((Object)"Shutting down quota usage monitor...");
            this.quotaUsageMonitor.shutDownNow();
            log.info((Object)"Shutting down quota statistics gathering monitor...");
            this.usageStatsMonitor.shutDownNow();
            this.quotaUsageMonitor.awaitTermination(timeOutSecs * 1000, TimeUnit.MILLISECONDS);
            this.usageStatsMonitor.awaitTermination(timeOutSecs * 1000, TimeUnit.MILLISECONDS);
        }
        finally {
            this.isRunning = false;
        }
    }

    public DiskQuotaConfig getConfig() {
        Assert.isTrue((boolean)this.diskQuotaEnabled, (String)"called saveConfig but DiskQuota is disabled!");
        return this.quotaConfig;
    }

    public void saveConfig(DiskQuotaConfig config) {
        Assert.isTrue((boolean)this.diskQuotaEnabled, (String)"called saveConfig but DiskQuota is disabled!");
        try {
            this.configLoader.saveConfig(config);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (config != this.quotaConfig) {
            this.quotaConfig.setFrom(config);
        }
    }

    public void saveConfig() {
        this.saveConfig(this.quotaConfig);
    }

    private LayerCacheInfoBuilder launchCacheInfoGatheringThreads() throws InterruptedException {
        File cacheRoot;
        try {
            cacheRoot = new File(this.storageFinder.getDefaultPath());
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        LayerCacheInfoBuilder cacheInfoBuilder = new LayerCacheInfoBuilder(cacheRoot, this.cleanUpExecutorService, this.quotaUsageMonitor);
        for (String layerName : this.tileLayerDispatcher.getLayerNames()) {
            TileLayer tileLayer;
            Quota usedQuota = this.quotaStore.getUsedQuotaByLayerName(layerName);
            if (usedQuota.getBytes().compareTo(BigInteger.ZERO) > 0) {
                log.debug((Object)("Using saved quota information for layer " + layerName + ": " + usedQuota.toNiceString()));
                continue;
            }
            log.debug((Object)(layerName + " has no saved used quota information," + "traversing layer cache to compute its disk usage."));
            try {
                tileLayer = this.tileLayerDispatcher.getTileLayer(layerName);
            }
            catch (GeoWebCacheException e) {
                e.printStackTrace();
                continue;
            }
            cacheInfoBuilder.buildCacheInfo(tileLayer);
        }
        return cacheInfoBuilder;
    }

    private ScheduledExecutorService createCleanUpExecutor() {
        int numCleaningThreads = this.quotaConfig.getMaxConcurrentCleanUps();
        log.info((Object)"Setting up disk quota periodic enforcement task");
        CustomizableThreadFactory tf = new CustomizableThreadFactory("GWC DiskQuota clean up thread-");
        tf.setThreadPriority(2);
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(numCleaningThreads, (ThreadFactory)tf);
        return executorService;
    }

    private void setUpScheduledCleanUp() {
        CacheCleanerTask scheduledCleaningTask = new CacheCleanerTask(this, this.cleanUpExecutorService);
        long delay = this.quotaConfig.getCacheCleanUpFrequency().intValue();
        long period = this.quotaConfig.getCacheCleanUpFrequency().intValue();
        TimeUnit unit = this.quotaConfig.getCacheCleanUpUnits();
        this.cleanUpExecutorService.scheduleAtFixedRate(scheduledCleaningTask, delay, period, unit);
        log.info((Object)("Disk quota periodic enforcement task set up every " + period + " " + (Object)((Object)unit)));
    }

    private void attachConfiguredLayers() throws ConfigurationException {
        List<LayerQuota> layerQuotas = this.quotaConfig.getLayerQuotas();
        ExpirationPolicy globalExpirationPolicy = this.quotaConfig.getGlobalExpirationPolicyName();
        Quota globalQuota = this.quotaConfig.getGlobalQuota();
        int explicitConfigs = 0;
        if (layerQuotas != null) {
            for (LayerQuota layerQuota : layerQuotas) {
                String layerName = layerQuota.getLayer();
                ExpirationPolicy policyName = layerQuota.getExpirationPolicyName();
                if (policyName == null) continue;
                Quota quota = layerQuota.getQuota();
                ++explicitConfigs;
                log.trace((Object)("Attaching layer " + layerName + " to quota " + quota + " with expiration policy " + (Object)((Object)policyName)));
            }
        }
        log.info((Object)(explicitConfigs + " layers configured with their own quotas. "));
        if (globalExpirationPolicy != null) {
            int globallyConfigured = this.tileLayerDispatcher.getLayerCount() - explicitConfigs;
            log.info((Object)(globallyConfigured + " layers attached to global quota " + globalQuota.toNiceString()));
        }
    }

    public CacheCleaner.QuotaResolver newLayerQuotaResolver(String layerName) {
        LayerQuota layerQuota = this.quotaConfig.layerQuota(layerName);
        return new CacheCleaner.LayerQuotaResolver(layerQuota, this.quotaStore);
    }

    public CacheCleaner.QuotaResolver newGlobalQuotaResolver() {
        return new CacheCleaner.GlobalQuotaResolver(this.quotaConfig, this.quotaStore);
    }

    public Set<String> getLayerNames() {
        return this.tileLayerDispatcher.getLayerNames();
    }

    public boolean isCacheInfoBuilderRunning(String layerName) {
        return this.cacheInfoBuilder != null && this.cacheInfoBuilder.isRunning(layerName);
    }

    public Quota getUsedQuotaByLayerName(String layerName) throws InterruptedException {
        return this.quotaStore.getUsedQuotaByLayerName(layerName);
    }

    public Quota getGloballyUsedQuota() throws InterruptedException {
        return this.quotaStore.getGloballyUsedQuota();
    }

    public void expireByLayerNames(Set<String> layerNames, CacheCleaner.QuotaResolver quotaResolver) throws InterruptedException {
        this.cacheCleaner.expireByLayerNames(layerNames, quotaResolver);
    }
}

