/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ViewParamsKvpParser
extends KvpParser
implements ApplicationContextAware {
    ApplicationContext applicationContext;

    public ViewParamsKvpParser() {
        super("viewparams", List.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Object parse(String value) throws Exception {
        ArrayList<Object> ret = new ArrayList<Object>();
        List parsers = GeoServerExtensions.extensions(KvpParser.class, (ApplicationContext)this.applicationContext);
        KvpParser formatOptionsParser = null;
        for (Object o : parsers) {
            KvpParser parser = (KvpParser)o;
            if (!parser.getKey().equalsIgnoreCase("format_options")) continue;
            formatOptionsParser = parser;
            break;
        }
        if (formatOptionsParser == null) {
            throw new IllegalStateException("Missing format options parser.");
        }
        for (String kvp : KvpUtils.escapedTokens(value, ',')) {
            ret.add(formatOptionsParser.parse(kvp));
        }
        return ret;
    }
}

