/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Level;
import org.geoserver.ows.KvpParser;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.DateRange;
import org.geotools.util.Range;

public class TimeKvpParser
extends KvpParser {
    private static final String[] PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:sss'Z'", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm'Z'", "yyyy-MM-dd'T'HH'Z'", "yyyy-MM-dd", "yyyy-MM", "yyyy"};
    static final TimeZone UTC_TZ = TimeZone.getTimeZone("UTC");
    static final long MILLIS_IN_DAY = 86400000L;
    private static final int MAX_ELEMENTS_TIMES_KVP;
    private static final int DEFAULT_MAX_ELEMENTS_TIMES_KVP = 100;

    public TimeKvpParser(String key) {
        super(key, List.class);
    }

    @Override
    public Object parse(String value) throws ParseException {
        String[] listDates;
        if (value == null) {
            return Collections.emptyList();
        }
        if ((value = value.trim()).length() == 0) {
            return Collections.emptyList();
        }
        TreeSet result = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                boolean o1Date = o1 instanceof Date;
                boolean o2Date = o2 instanceof Date;
                if (o1Date) {
                    Date dateLeft = (Date)o1;
                    if (o2Date) {
                        return dateLeft.compareTo((Date)o2);
                    }
                    return dateLeft.compareTo(((DateRange)o2).getMinValue());
                }
                DateRange left = (DateRange)o1;
                if (o2Date) {
                    return left.getMinValue().compareTo((Date)o2);
                }
                return left.getMinValue().compareTo(((DateRange)o2).getMinValue());
            }
        });
        block0: for (String date : listDates = value.split(",")) {
            Date end;
            Date begin;
            if (date.indexOf("/") <= 0) {
                TimeKvpParser.addDate(result, TimeKvpParser.getDate(date));
                continue;
            }
            Object[] period = date.split("/");
            if (period.length == 3) {
                long time;
                begin = TimeKvpParser.getDate(period[0]);
                end = TimeKvpParser.getDate(period[1]);
                long millisIncrement = TimeKvpParser.parsePeriod(period[2]);
                long startTime = begin.getTime();
                long endTime = end.getTime();
                int j = 0;
                while ((time = (long)j * millisIncrement + startTime) <= endTime) {
                    Calendar calendar = Calendar.getInstance(UTC_TZ);
                    calendar.setTimeInMillis(time);
                    TimeKvpParser.addDate(result, calendar.getTime());
                    if (++j < MAX_ELEMENTS_TIMES_KVP) continue;
                    if (!LOGGER.isLoggable(Level.INFO)) continue block0;
                    LOGGER.info("Lmiting number of elements in this periodo to " + MAX_ELEMENTS_TIMES_KVP);
                    continue block0;
                }
                continue;
            }
            if (period.length == 2) {
                begin = TimeKvpParser.getDate(period[0]);
                end = TimeKvpParser.getDate(period[1]);
                TimeKvpParser.addPeriod(result, new DateRange(begin, end));
                continue;
            }
            throw new ParseException("Invalid time period: " + Arrays.toString(period), 0);
        }
        return new ArrayList(result);
    }

    private static void addDate(Collection result, Date time) {
        for (Object element : result) {
            Date local;
            if (!(element instanceof Date ? (local = (Date)element).equals(time) : (local = (DateRange)element).contains(time))) continue;
            return;
        }
        result.add(time);
    }

    private static void addPeriod(Collection result, DateRange newRange) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            Date local;
            Object element = it.next();
            if (element instanceof Date) {
                local = (Date)element;
                if (!newRange.contains((Comparable)local)) continue;
                it.remove();
                continue;
            }
            local = (DateRange)element;
            if (local.contains((Range)newRange)) {
                return;
            }
            if (!newRange.contains((Range)local)) continue;
            it.remove();
        }
        result.add(newRange);
    }

    private static Date getDate(String value) throws ParseException {
        if (value.equalsIgnoreCase("current") || value.equalsIgnoreCase("now")) {
            return null;
        }
        for (int i = 0; i < PATTERNS.length; ++i) {
            SimpleDateFormat format = new SimpleDateFormat(PATTERNS[i], Locale.CANADA);
            format.setTimeZone(UTC_TZ);
            ParsePosition pos = new ParsePosition(0);
            Date time = format.parse(value, pos);
            if (pos.getIndex() != value.length()) continue;
            return time;
        }
        throw new ParseException("Invalid date: " + value, 0);
    }

    static long parsePeriod(String period) throws ParseException {
        int length = period.length();
        if (length != 0 && Character.toUpperCase(period.charAt(0)) != 'P') {
            throw new ParseException("Invalid period increment given: " + period, 0);
        }
        long millis = 0L;
        boolean time = false;
        int lower = 0;
        while (++lower < length) {
            double factor;
            double value;
            int upper;
            block17: {
                char letter;
                block16: {
                    letter = Character.toUpperCase(period.charAt(lower));
                    if (letter == 'T') {
                        time = true;
                        if (++lower >= length) break;
                    }
                    upper = lower;
                    letter = period.charAt(upper);
                    while (!Character.isLetter(letter) || letter == 'e' || letter == 'E') {
                        if (++upper >= length) {
                            throw new ParseException("Missing symbol in \"" + period + "\".", lower);
                        }
                        letter = period.charAt(upper);
                    }
                    letter = Character.toUpperCase(letter);
                    value = Double.parseDouble(period.substring(lower, upper));
                    if (!time) break block16;
                    switch (letter) {
                        case 'S': {
                            factor = 1000.0;
                            break block17;
                        }
                        case 'M': {
                            factor = 60000.0;
                            break block17;
                        }
                        case 'H': {
                            factor = 3600000.0;
                            break block17;
                        }
                        default: {
                            throw new ParseException("Unknown time symbol: " + letter, upper);
                        }
                    }
                }
                switch (letter) {
                    case 'D': {
                        factor = 8.64E7;
                        break;
                    }
                    case 'W': {
                        factor = 6.048E8;
                        break;
                    }
                    case 'M': {
                        factor = 2.592E9;
                        break;
                    }
                    case 'Y': {
                        factor = 3.15576E10;
                        break;
                    }
                    default: {
                        throw new ParseException("Unknown period symbol: " + letter, upper);
                    }
                }
            }
            millis += Math.round(value * factor);
            lower = upper;
        }
        return millis;
    }

    static {
        String value = GeoServerExtensions.getProperty((String)"MAX_ELEMENTS_TIMES_KVP");
        if (value == null) {
            MAX_ELEMENTS_TIMES_KVP = 100;
        } else {
            int iVal = -1;
            try {
                iVal = Integer.parseInt(value.trim());
            }
            catch (Exception e) {
                iVal = 100;
            }
            MAX_ELEMENTS_TIMES_KVP = iVal;
        }
    }
}

