/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.logging.Level;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.Request;
import org.geoserver.ows.ServiceExceptionHandler;
import org.geoserver.platform.ServiceException;

public class SOAPServiceExceptionHandler
extends ServiceExceptionHandler {
    ServiceExceptionHandler delegate;

    public SOAPServiceExceptionHandler(ServiceExceptionHandler delegate) {
        super(delegate.getServices());
        this.delegate = delegate;
    }

    @Override
    public void handleServiceException(ServiceException exception, Request request) {
        HttpServletResponse response = request.getHttpResponse();
        response.setContentType("application/soap+xml");
        try {
            StringBuilder sb = new StringBuilder("<soap:Fault xmlns:soap='").append("http://www.w3.org/2003/05/soap-envelope").append("'>");
            if (exception.getCode() != null) {
                sb.append("<soap:faultcode>").append(exception.getCode()).append("</soap:faultcode>");
            }
            sb.append("<soap:faultstring>").append(exception.getLocalizedMessage()).append("</soap:faultstring>");
            sb.append("<soap:detail>");
            response.getOutputStream().write(sb.toString().getBytes());
            this.delegate.handleServiceException(exception, request);
            response.getOutputStream().write("</soap:detail></soap:Fault>".getBytes());
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error encoding SOAP fault", e);
        }
    }
}

