/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web;

import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.MinimumValidator;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.web.services.BaseServiceAdminPage;
import org.geotools.coverage.grid.io.OverviewPolicy;

public class WCSAdminPage
extends BaseServiceAdminPage<WCSInfo> {
    public WCSAdminPage() {
    }

    public WCSAdminPage(PageParameters pageParams) {
        super(pageParams);
    }

    public WCSAdminPage(WCSInfo service) {
        super((ServiceInfo)service);
    }

    protected Class<WCSInfo> getServiceClass() {
        return WCSInfo.class;
    }

    protected void build(IModel info, Form form) {
        form.add(new Component[]{new DropDownChoice("overviewPolicy", Arrays.asList(OverviewPolicy.values()), (IChoiceRenderer)new OverviewPolicyRenderer())});
        form.add(new Component[]{new CheckBox("subsamplingEnabled")});
        TextField maxInputMemory = new TextField("maxInputMemory");
        maxInputMemory.add((IValidator)new MinimumValidator((Comparable)Long.valueOf(0L)));
        form.add(new Component[]{maxInputMemory});
        TextField maxOutputMemory = new TextField("maxOutputMemory");
        maxOutputMemory.add((IValidator)new MinimumValidator((Comparable)Long.valueOf(0L)));
        form.add(new Component[]{maxOutputMemory});
    }

    protected String getServiceName() {
        return "WCS";
    }

    private class OverviewPolicyRenderer
    implements IChoiceRenderer {
        private OverviewPolicyRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel(((OverviewPolicy)object).name(), (Component)WCSAdminPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return ((OverviewPolicy)object).name();
        }
    }
}

