/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.catalog.rest.ResourceHTMLFormat;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class WMSLayerResource
extends AbstractCatalogResource {
    public WMSLayerResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, WMSLayerInfo.class, catalog);
    }

    @Override
    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new ResourceHTMLFormat(WMSLayerInfo.class, request, response, (Resource)this);
    }

    protected Object handleObjectGet() {
        String workspace = this.getAttribute("workspace");
        String wmsstore = this.getAttribute("wmsstore");
        String wmslayer = this.getAttribute("wmslayer");
        if (wmsstore == null) {
            LOGGER.fine("GET feature type" + workspace + "," + wmslayer);
            NamespaceInfo ns = this.catalog.getNamespaceByPrefix(workspace);
            if (ns != null) {
                return this.catalog.getResourceByName(ns, wmslayer, WMSLayerInfo.class);
            }
            throw new RestletException("", Status.CLIENT_ERROR_NOT_FOUND);
        }
        LOGGER.fine("GET wms layer " + wmsstore + "," + wmslayer);
        WMSStoreInfo wms = (WMSStoreInfo)this.catalog.getStoreByName(workspace, wmsstore, WMSStoreInfo.class);
        return this.catalog.getResourceByStore((StoreInfo)wms, wmslayer, WMSLayerInfo.class);
    }

    public boolean allowPost() {
        return this.getAttribute("wmslayer") == null;
    }

    protected String handleObjectPost(Object object) throws Exception {
        String workspace = this.getAttribute("workspace");
        String wmsstore = this.getAttribute("wmsstore");
        WMSLayerInfo wml = (WMSLayerInfo)object;
        WMSStoreInfo wms = (WMSStoreInfo)this.catalog.getStoreByName(workspace, wmsstore, WMSStoreInfo.class);
        if (wml.getStore() != null) {
            if (!wmsstore.equals(wml.getStore().getName())) {
                throw new RestletException("Expected wms store " + wmsstore + " but client specified " + wml.getStore().getName(), Status.CLIENT_ERROR_FORBIDDEN);
            }
        } else {
            wml.setStore((StoreInfo)wms);
        }
        if (wml.getNamespace() != null) {
            if (!workspace.equals(wml.getNamespace().getPrefix())) {
                throw new RestletException("Expected workspace " + workspace + " but client specified " + wml.getNamespace().getPrefix(), Status.CLIENT_ERROR_FORBIDDEN);
            }
        } else {
            wml.setNamespace(this.catalog.getNamespaceByPrefix(workspace));
        }
        wml.setEnabled(true);
        NamespaceInfo ns = wml.getNamespace();
        if (ns != null && !ns.getPrefix().equals(workspace)) {
            LOGGER.warning("Namespace: " + ns.getPrefix() + " does not match workspace: " + workspace + ", overriding.");
            ns = null;
        }
        if (ns == null) {
            ns = this.catalog.getNamespaceByPrefix(workspace);
            wml.setNamespace(ns);
        }
        CatalogBuilder cb = new CatalogBuilder(this.catalog);
        cb.setStore((StoreInfo)wms);
        cb.initWMSLayer(wml);
        wml.setEnabled(true);
        this.catalog.add((ResourceInfo)wml);
        this.catalog.add(new CatalogBuilder(this.catalog).buildLayer(wml));
        LOGGER.info("POST wms layer " + wmsstore + "," + wml.getName());
        return wml.getName();
    }

    public boolean allowPut() {
        return this.getAttribute("wmslayer") != null;
    }

    protected void handleObjectPut(Object object) throws Exception {
        WMSLayerInfo wml = (WMSLayerInfo)object;
        String workspace = this.getAttribute("workspace");
        String wmsstore = this.getAttribute("wmsstore");
        String wmslayer = this.getAttribute("wmslayer");
        WMSStoreInfo wms = (WMSStoreInfo)this.catalog.getStoreByName(workspace, wmsstore, WMSStoreInfo.class);
        WMSLayerInfo original = (WMSLayerInfo)this.catalog.getResourceByStore((StoreInfo)wms, wmslayer, WMSLayerInfo.class);
        new CatalogBuilder(this.catalog).updateWMSLayer(original, wml);
        this.catalog.save((ResourceInfo)original);
        LOGGER.info("PUT wms layer " + wmsstore + "," + wmslayer);
    }

    public boolean allowDelete() {
        return this.getAttribute("wmslayer") != null;
    }

    public void handleObjectDelete() throws Exception {
        String workspace = this.getAttribute("workspace");
        String wmsstore = this.getAttribute("wmsstore");
        String wmslayer = this.getAttribute("wmslayer");
        boolean recurse = (Boolean)this.getQueryStringValue("recurse", Boolean.class, false);
        WMSStoreInfo wms = (WMSStoreInfo)this.catalog.getStoreByName(workspace, wmsstore, WMSStoreInfo.class);
        WMSLayerInfo wml = (WMSLayerInfo)this.catalog.getResourceByStore((StoreInfo)wms, wmslayer, WMSLayerInfo.class);
        List layers = this.catalog.getLayers((ResourceInfo)wml);
        if (recurse) {
            for (LayerInfo l : layers) {
                this.catalog.remove(l);
                LOGGER.info("DELETE layer " + l.getName());
            }
        } else if (!layers.isEmpty()) {
            throw new RestletException("wms layer referenced by layer(s)", Status.CLIENT_ERROR_FORBIDDEN);
        }
        this.catalog.remove((ResourceInfo)wml);
        LOGGER.info("DELETE wms layer" + wmsstore + "," + wmslayer);
    }

    @Override
    protected void configurePersister(XStreamPersister persister, DataFormat format) {
        persister.setHideFeatureTypeAttributes();
        persister.setCallback(new XStreamPersister.Callback(){

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof NamespaceInfo) {
                    NamespaceInfo ns = (NamespaceInfo)obj;
                    WMSLayerResource.this.encodeLink("/namespaces/" + ns.getPrefix(), writer);
                }
                if (obj instanceof WMSStoreInfo) {
                    WMSStoreInfo ds = (WMSStoreInfo)obj;
                    WMSLayerResource.this.encodeLink("/workspaces/" + ds.getWorkspace().getName() + "/wmsstores/" + ds.getName(), writer);
                }
            }
        });
    }
}

