/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.catalog.rest.SLDFormat;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.MediaTypes;
import org.geotools.styling.Style;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class StyleResource
extends AbstractCatalogResource {
    public static final MediaType MEDIATYPE_SLD = new MediaType("application/vnd.ogc.sld+xml");

    public StyleResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, StyleInfo.class, catalog);
    }

    protected List<DataFormat> createSupportedFormats(Request request, Response response) {
        List formats = super.createSupportedFormats(request, response);
        formats.add(new SLDFormat());
        return formats;
    }

    protected Object handleObjectGet() {
        String workspace = this.getAttribute("workspace");
        String style = this.getAttribute("style");
        LOGGER.fine("GET style " + style);
        StyleInfo sinfo = workspace == null ? this.catalog.getStyleByName(style) : this.catalog.getStyleByName(workspace, style);
        DataFormat format = this.getFormatGet();
        if (format instanceof SLDFormat) {
            try {
                return sinfo.getStyle();
            }
            catch (IOException e) {
                throw new RestletException("", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
        }
        return sinfo;
    }

    public boolean allowPost() {
        if (this.getAttribute("workspace") == null && !this.isAuthenticatedAsAdmin()) {
            return false;
        }
        return this.getAttribute("style") == null;
    }

    protected String handleObjectPost(Object object) throws Exception {
        String workspace = this.getAttribute("workspace");
        String layer = this.getAttribute("layer");
        if (object instanceof StyleInfo) {
            StyleInfo style = (StyleInfo)object;
            if (layer != null) {
                StyleInfo existing = this.catalog.getStyleByName(style.getName());
                if (existing == null) {
                    throw new RestletException("No such style: " + style.getName(), Status.CLIENT_ERROR_NOT_FOUND);
                }
                LayerInfo l = this.catalog.getLayerByName(layer);
                l.getStyles().add(existing);
                String def = this.getRequest().getResourceRef().getQueryAsForm().getFirstValue("default");
                if ("true".equals(def)) {
                    l.setDefaultStyle(existing);
                }
                this.catalog.save(l);
                LOGGER.info("POST style " + style.getName() + " to layer " + layer);
            } else {
                if (workspace != null) {
                    style.setWorkspace(this.catalog.getWorkspaceByName(workspace));
                }
                this.catalog.add(style);
                LOGGER.info("POST style " + style.getName());
            }
            return style.getName();
        }
        if (object instanceof Style) {
            File f;
            Style style = (Style)object;
            String name = this.getRequest().getResourceRef().getQueryAsForm().getFirstValue("name");
            if (name == null) {
                name = style.getName();
            }
            if (name == null) {
                throw new RestletException("Style must have a name.", Status.CLIENT_ERROR_BAD_REQUEST);
            }
            if (this.catalog.getStyleByName(workspace, name) != null) {
                throw new RestletException("Style " + name + " already exists.", Status.CLIENT_ERROR_FORBIDDEN);
            }
            GeoServerResourceLoader loader = this.catalog.getResourceLoader();
            String path = "styles/" + name + ".sld";
            if (workspace != null) {
                path = "workspaces/" + workspace + "/" + path;
            }
            try {
                f = loader.find(path);
            }
            catch (IOException e) {
                throw new RestletException("Error looking up file", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
            if (f != null) {
                String msg = "SLD file " + path + ".sld already exists.";
                throw new RestletException(msg, Status.CLIENT_ERROR_FORBIDDEN);
            }
            try {
                f = loader.createFile(path);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
                SLDFormat format = new SLDFormat(true);
                format.toRepresentation(style).write((OutputStream)out);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                throw new RestletException("Error creating file", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
            StyleInfo sinfo = this.catalog.getFactory().createStyle();
            sinfo.setName(name);
            sinfo.setFilename(f.getName());
            if (workspace != null) {
                sinfo.setWorkspace(this.catalog.getWorkspaceByName(workspace));
            }
            this.catalog.add(sinfo);
            LOGGER.info("POST SLD " + name);
            return name;
        }
        return null;
    }

    public boolean allowPut() {
        if (this.getAttribute("workspace") == null && !this.isAuthenticatedAsAdmin()) {
            return false;
        }
        return this.getAttribute("style") != null;
    }

    protected void handleObjectPut(Object object) throws Exception {
        String style = this.getAttribute("style");
        String workspace = this.getAttribute("workspace");
        if (object instanceof StyleInfo) {
            StyleInfo s = (StyleInfo)object;
            StyleInfo original = this.catalog.getStyleByName(workspace, style);
            if (s.getWorkspace() != null && !s.getWorkspace().equals(original.getWorkspace())) {
                throw new RestletException("Can't change the workspace of a style, instead DELETE from existing workspace and POST to new workspace", Status.CLIENT_ERROR_FORBIDDEN);
            }
            new CatalogBuilder(this.catalog).updateStyle(original, s);
            this.catalog.save(original);
        } else if (object instanceof Style) {
            StyleInfo s = this.catalog.getStyleByName(workspace, style);
            this.catalog.getResourcePool().writeStyle(s, (Style)object, true);
            this.catalog.save(s);
        }
        LOGGER.info("PUT style " + style);
    }

    public boolean allowDelete() {
        return this.getAttribute("style") != null;
    }

    protected void handleObjectDelete() throws Exception {
        String workspace = this.getAttribute("workspace");
        String style = this.getAttribute("style");
        StyleInfo s = workspace != null ? this.catalog.getStyleByName(workspace, style) : this.catalog.getStyleByName(style);
        List layers = this.catalog.getLayers(s);
        if (!layers.isEmpty()) {
            throw new RestletException("Can't delete style referenced by existing layers.", Status.CLIENT_ERROR_FORBIDDEN);
        }
        this.catalog.remove(s);
        String p = this.getRequest().getResourceRef().getQueryAsForm().getFirstValue("purge");
        boolean purge = p != null ? Boolean.parseBoolean(p) : false;
        this.catalog.getResourcePool().deleteStyle(s, purge);
        LOGGER.info("DELETE style " + style);
    }

    static {
        MediaTypes.registerExtension((String)"sld", (MediaType)MEDIATYPE_SLD);
    }
}

